/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.aninteger;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleAnotB;
import org.apache.datasketches.tuple.TupleIntersection;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.apache.datasketches.tuple.aninteger.IntegerTupleSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IntegerSketchTest {
    @Test
    public void serDeTest() {
        int lgK = 12;
        int K = 4096;
        IntegerSummary.Mode a1Mode = IntegerSummary.Mode.AlwaysOne;
        IntegerTupleSketch a1Sk = new IntegerTupleSketch(12, a1Mode);
        int m = 8192;
        for (int i = 0; i < 8192; ++i) {
            a1Sk.update((long)i, Integer.valueOf(1));
        }
        double est1 = a1Sk.getEstimate();
        MemorySegment seg = MemorySegment.ofArray(a1Sk.toByteArray());
        IntegerTupleSketch a1Sk2 = new IntegerTupleSketch(seg, a1Mode);
        double est2 = a1Sk2.getEstimate();
        Assert.assertEquals((double)est1, (double)est2);
    }

    @Test
    public void intersectTest() {
        int lgK = 12;
        int K = 4096;
        IntegerSummary.Mode a1Mode = IntegerSummary.Mode.AlwaysOne;
        IntegerTupleSketch a1Sk1 = new IntegerTupleSketch(12, a1Mode);
        IntegerTupleSketch a1Sk2 = new IntegerTupleSketch(12, a1Mode);
        int m = 8192;
        for (int i = 0; i < 8192; ++i) {
            a1Sk1.update((long)i, Integer.valueOf(1));
            a1Sk2.update((long)(i + 4096), Integer.valueOf(1));
        }
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)new IntegerSummarySetOperations(a1Mode, a1Mode));
        inter.intersect((TupleSketch)a1Sk1);
        inter.intersect((TupleSketch)a1Sk2);
        CompactTupleSketch csk = inter.getResult();
        Assert.assertEquals((double)csk.getEstimate(), (double)4096.0, (double)122.88);
    }

    @Test
    public void aNotBTest() {
        int lgK = 4;
        int u = 5;
        IntegerSummary.Mode a1Mode = IntegerSummary.Mode.AlwaysOne;
        IntegerTupleSketch a1Sk1 = new IntegerTupleSketch(4, a1Mode);
        TupleSketch a1Sk2 = null;
        TupleAnotB anotb = new TupleAnotB();
        for (int i = 0; i < 5; ++i) {
            a1Sk1.update((long)i, Integer.valueOf(1));
        }
        anotb.setA((TupleSketch)a1Sk1);
        anotb.notB(a1Sk2);
        CompactTupleSketch cSk = anotb.getResult(true);
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)5);
    }

    @Test
    public void checkMinMaxMode() {
        int lgK = 12;
        int K = 4096;
        IntegerSummary.Mode minMode = IntegerSummary.Mode.Min;
        IntegerSummary.Mode maxMode = IntegerSummary.Mode.Max;
        IntegerTupleSketch a1Sk1 = new IntegerTupleSketch(12, minMode);
        IntegerTupleSketch a1Sk2 = new IntegerTupleSketch(12, maxMode);
        int m = 2048;
        for (int key = 0; key < 2048; ++key) {
            a1Sk1.update((long)key, Integer.valueOf(1));
            a1Sk1.update((long)key, Integer.valueOf(0));
            a1Sk1.update((long)key, Integer.valueOf(2));
            a1Sk2.update((long)(key + 1024), Integer.valueOf(1));
            a1Sk2.update((long)(key + 1024), Integer.valueOf(0));
            a1Sk2.update((long)(key + 1024), Integer.valueOf(2));
        }
        double est1 = a1Sk1.getEstimate();
        double est2 = a1Sk2.getEstimate();
        Assert.assertEquals((double)est1, (double)est2);
    }

    @Test
    public void checkStringKey() {
        int lgK = 12;
        int K = 4096;
        IntegerSummary.Mode a1Mode = IntegerSummary.Mode.AlwaysOne;
        IntegerTupleSketch a1Sk1 = new IntegerTupleSketch(12, a1Mode);
        int m = 2048;
        for (int key = 0; key < 2048; ++key) {
            a1Sk1.update(Integer.toHexString(key), Integer.valueOf(1));
        }
        Assert.assertEquals((double)a1Sk1.getEstimate(), (double)2048.0);
    }

    static void println(Object o) {
    }

    static void printf(String fmt, Object ... args) {
    }
}

