/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleIntersection;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.TupleUnion;
import org.apache.datasketches.tuple.UpdatableTupleSketch;
import org.apache.datasketches.tuple.UpdatableTupleSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TupleExamples2Test {
    private final DoubleSummary.Mode umode = DoubleSummary.Mode.Sum;
    private final DoubleSummary.Mode imode = DoubleSummary.Mode.AlwaysOne;
    private final DoubleSummarySetOperations dsso0 = new DoubleSummarySetOperations();
    private final DoubleSummarySetOperations dsso1 = new DoubleSummarySetOperations(this.umode);
    private final DoubleSummarySetOperations dsso2 = new DoubleSummarySetOperations(this.umode, this.imode);
    private final DoubleSummaryFactory ufactory = new DoubleSummaryFactory(this.umode);
    private final DoubleSummaryFactory ifactory = new DoubleSummaryFactory(this.imode);
    private final UpdatableThetaSketchBuilder thetaBldr = UpdatableThetaSketch.builder();
    private final UpdatableTupleSketchBuilder<Double, DoubleSummary> tupleBldr = new UpdatableTupleSketchBuilder((SummaryFactory)this.ufactory);

    @Test
    public void example1() {
        UpdatableTupleSketch tupleSk = this.tupleBldr.build();
        UpdatableThetaSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1.0);
            thetaSk.update((long)(i + 3));
        }
        TupleUnion union = new TupleUnion((SummarySetOperations)this.dsso2);
        union.union((TupleSketch)tupleSk);
        union.union((ThetaSketch)thetaSk, (Summary)this.ufactory.newSummary().update(Double.valueOf(1.0)));
        CompactTupleSketch ucsk = union.getResult();
        int entries = ucsk.getRetainedEntries();
        TupleExamples2Test.println("TupleUnion Stateful: tuple, theta: " + entries);
        TupleSketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = (int)((DoubleSummary)uiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)this.dsso2);
        inter.intersect((TupleSketch)tupleSk);
        inter.intersect((ThetaSketch)thetaSk, (Summary)this.ifactory.newSummary().update(Double.valueOf(1.0)));
        CompactTupleSketch icsk = inter.getResult();
        entries = icsk.getRetainedEntries();
        TupleExamples2Test.println("TupleIntersection Stateful: tuple, theta: " + entries);
        TupleSketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = (int)((DoubleSummary)iiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void example2() {
        UpdatableTupleSketch tupleSk1 = this.tupleBldr.build();
        UpdatableTupleSketch tupleSk2 = this.tupleBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk1.update((long)i, (Object)1.0);
            tupleSk2.update((long)(i + 3), (Object)1.0);
        }
        TupleUnion union = new TupleUnion((SummarySetOperations)this.dsso2);
        CompactTupleSketch ucsk = union.union((TupleSketch)tupleSk1, (TupleSketch)tupleSk2);
        int entries = ucsk.getRetainedEntries();
        TupleExamples2Test.println("TupleUnion: " + entries);
        TupleSketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = (int)((DoubleSummary)uiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)this.dsso2);
        CompactTupleSketch icsk = inter.intersect((TupleSketch)tupleSk1, (TupleSketch)tupleSk2);
        entries = icsk.getRetainedEntries();
        TupleExamples2Test.println("TupleIntersection: " + entries);
        TupleSketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = (int)((DoubleSummary)iiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void example3() {
        UpdatableTupleSketch tupleSk = this.tupleBldr.build();
        UpdatableThetaSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1.0);
            thetaSk.update((long)(i + 3));
        }
        TupleUnion union = new TupleUnion((SummarySetOperations)this.dsso2);
        CompactTupleSketch ucsk = union.union((TupleSketch)tupleSk, (ThetaSketch)thetaSk, (Summary)this.ufactory.newSummary().update(Double.valueOf(1.0)));
        int entries = ucsk.getRetainedEntries();
        TupleExamples2Test.println("TupleUnion: " + entries);
        TupleSketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = (int)((DoubleSummary)uiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)this.dsso2);
        CompactTupleSketch icsk = inter.intersect((TupleSketch)tupleSk, (ThetaSketch)thetaSk, (Summary)this.ufactory.newSummary().update(Double.valueOf(1.0)));
        entries = icsk.getRetainedEntries();
        TupleExamples2Test.println("TupleIntersection: " + entries);
        TupleSketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = (int)((DoubleSummary)iiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void example4() {
        UpdatableTupleSketch tupleSk = this.tupleBldr.build();
        UpdatableThetaSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1.0);
            thetaSk.update((long)(i + 3));
        }
        TupleUnion union = new TupleUnion((SummarySetOperations)this.dsso0);
        union.union((TupleSketch)tupleSk);
        union.union((ThetaSketch)thetaSk, (Summary)this.ufactory.newSummary().update(Double.valueOf(1.0)));
        CompactTupleSketch ucsk = union.getResult();
        int entries = ucsk.getRetainedEntries();
        TupleExamples2Test.println("TupleUnion Stateful: tuple, theta: " + entries);
        TupleSketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = (int)((DoubleSummary)uiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)this.dsso0);
        inter.intersect((TupleSketch)tupleSk);
        inter.intersect((ThetaSketch)thetaSk, (Summary)this.ifactory.newSummary().update(Double.valueOf(1.0)));
        CompactTupleSketch icsk = inter.getResult();
        entries = icsk.getRetainedEntries();
        TupleExamples2Test.println("TupleIntersection Stateful: tuple, theta: " + entries);
        TupleSketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = (int)((DoubleSummary)iiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)2);
        }
    }

    @Test
    public void example5() {
        UpdatableTupleSketch tupleSk = this.tupleBldr.build();
        UpdatableThetaSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1.0);
            thetaSk.update((long)(i + 3));
        }
        TupleUnion union = new TupleUnion((SummarySetOperations)this.dsso1);
        union.union((TupleSketch)tupleSk);
        union.union((ThetaSketch)thetaSk, (Summary)this.ufactory.newSummary().update(Double.valueOf(1.0)));
        CompactTupleSketch ucsk = union.getResult();
        int entries = ucsk.getRetainedEntries();
        TupleExamples2Test.println("TupleUnion Stateful: tuple, theta: " + entries);
        TupleSketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = (int)((DoubleSummary)uiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)this.dsso1);
        inter.intersect((TupleSketch)tupleSk);
        inter.intersect((ThetaSketch)thetaSk, (Summary)this.ifactory.newSummary().update(Double.valueOf(1.0)));
        CompactTupleSketch icsk = inter.getResult();
        entries = icsk.getRetainedEntries();
        TupleExamples2Test.println("TupleIntersection Stateful: tuple, theta: " + entries);
        TupleSketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = (int)((DoubleSummary)iiter.getSummary()).getValue();
            TupleExamples2Test.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)2);
        }
    }

    @Test
    public void printlnTest() {
        TupleExamples2Test.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

