/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.matchers;

import java.util.Locale;
import org.apache.rat.analysis.IHeaders;
import org.apache.rat.analysis.matchers.SimpleTextMatcher;

public class FullTextMatcher
extends SimpleTextMatcher {
    private final String prunedText;

    public FullTextMatcher(String simpleText) {
        this(null, simpleText);
    }

    public FullTextMatcher(String id, String simpleText) {
        super(id, simpleText);
        this.prunedText = FullTextMatcher.prune(simpleText).toLowerCase(Locale.ENGLISH);
    }

    public static String prune(String text) {
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            char at = text.charAt(i2);
            if (!Character.isLetterOrDigit(at)) continue;
            buffer.append(at);
        }
        return buffer.toString();
    }

    @Override
    public boolean matches(IHeaders headers) {
        if (headers.pruned().length() >= this.prunedText.length()) {
            return headers.pruned().contains(this.prunedText);
        }
        return false;
    }
}

