/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.io.Serializable;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.ValidScope;
import org.apache.velocity.tools.generic.ImportSupport;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;

@DefaultKey(value="import")
@ValidScope(value={"request"})
public class ImportTool
extends SafeConfig
implements Serializable {
    private static final long serialVersionUID = -6707904279566187527L;
    protected transient ImportSupport importSupport = null;

    protected synchronized void initializeImportSupport(ValueParser config) {
        if (this.importSupport == null) {
            this.importSupport = new ImportSupport();
            this.importSupport.configure(config);
        }
    }

    @Override
    protected void configure(ValueParser values) {
        this.initializeImportSupport(values);
    }

    public String read(String resource) {
        if (resource == null || resource.length() == 0) {
            return null;
        }
        try {
            if (this.importSupport == null) {
                this.initializeImportSupport(new ValueParser());
            }
            return this.importSupport.getResourceString(resource);
        }
        catch (Exception ex) {
            this.getLog().error("Exception while getting '{}'", (Object)resource, (Object)ex);
            return null;
        }
    }

    public String fetch(String url) {
        if (url == null || url.length() == 0) {
            return null;
        }
        try {
            if (this.importSupport == null) {
                this.initializeImportSupport(new ValueParser());
            }
            return this.importSupport.acquireString(url);
        }
        catch (Exception ex) {
            this.getLog().error("Exception while acquiring '{}'", (Object)url, (Object)ex);
            return null;
        }
    }
}

