/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ArgumentUtils;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;
import org.apache.commons.statistics.distribution.TriangularDistribution;
import org.apache.commons.statistics.distribution.UniformContinuousDistribution;

public abstract class TrapezoidalDistribution
extends AbstractContinuousDistribution {
    protected final double a;
    protected final double b;
    protected final double c;
    protected final double d;

    TrapezoidalDistribution(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public static TrapezoidalDistribution of(double a, double b, double c, double d) {
        if (a >= d) {
            throw new DistributionException("Lower bound %s >= upper bound %s", a, d);
        }
        if (b < a) {
            throw new DistributionException("%s < %s", b, a);
        }
        if (c < b) {
            throw new DistributionException("%s < %s", c, b);
        }
        if (c > d) {
            throw new DistributionException("%s > %s", c, d);
        }
        if (b == c) {
            return new TriangularTrapezoidalDistribution(a, b, d);
        }
        if (d - a == c - b) {
            return new UniformTrapezoidalDistribution(a, d);
        }
        return new RegularTrapezoidalDistribution(a, b, c, d);
    }

    @Override
    public abstract double getMean();

    @Override
    public abstract double getVariance();

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    @Override
    public double getSupportLowerBound() {
        return this.a;
    }

    @Override
    public double getSupportUpperBound() {
        return this.d;
    }

    private static class RegularTrapezoidalDistribution
    extends TrapezoidalDistribution {
        private final double divisor;
        private final double bma;
        private final double dmc;
        private final double cdfB;
        private final double cdfC;
        private final double sfB;
        private final double sfC;

        RegularTrapezoidalDistribution(double a, double b, double c, double d) {
            super(a, b, c, d);
            this.divisor = d - a + (c - b);
            this.bma = b - a;
            this.dmc = d - c;
            this.cdfB = this.bma / this.divisor;
            this.sfB = 1.0 - this.cdfB;
            this.sfC = this.dmc / this.divisor;
            this.cdfC = 1.0 - this.sfC;
        }

        @Override
        public double density(double x) {
            if (x < this.a) {
                return 0.0;
            }
            if (x < this.b) {
                double divident = (x - this.a) / this.bma;
                return 2.0 * (divident / this.divisor);
            }
            if (x < this.c) {
                return 2.0 / this.divisor;
            }
            if (x < this.d) {
                double divident = (this.d - x) / this.dmc;
                return 2.0 * (divident / this.divisor);
            }
            return 0.0;
        }

        @Override
        public double cumulativeProbability(double x) {
            if (x <= this.a) {
                return 0.0;
            }
            if (x < this.b) {
                double divident = (x - this.a) * (x - this.a) / this.bma;
                return divident / this.divisor;
            }
            if (x < this.c) {
                double divident = 2.0 * x - this.b - this.a;
                return divident / this.divisor;
            }
            if (x < this.d) {
                double divident = (this.d - x) * (this.d - x) / this.dmc;
                return 1.0 - divident / this.divisor;
            }
            return 1.0;
        }

        @Override
        public double survivalProbability(double x) {
            if (x <= this.a) {
                return 1.0;
            }
            if (x < this.b) {
                double divident = (x - this.a) * (x - this.a) / this.bma;
                return 1.0 - divident / this.divisor;
            }
            if (x < this.c) {
                double divident = 2.0 * x - this.b - this.a;
                return 1.0 - divident / this.divisor;
            }
            if (x < this.d) {
                double divident = (this.d - x) * (this.d - x) / this.dmc;
                return divident / this.divisor;
            }
            return 0.0;
        }

        @Override
        public double inverseCumulativeProbability(double p) {
            ArgumentUtils.checkProbability(p);
            if (p == 0.0) {
                return this.a;
            }
            if (p == 1.0) {
                return this.d;
            }
            if (p < this.cdfB) {
                return this.a + Math.sqrt(p * this.divisor * this.bma);
            }
            if (p < this.cdfC) {
                return 0.5 * (p * this.divisor + this.a + this.b);
            }
            return this.d - Math.sqrt((1.0 - p) * this.divisor * this.dmc);
        }

        @Override
        public double inverseSurvivalProbability(double p) {
            ArgumentUtils.checkProbability(p);
            if (p == 1.0) {
                return this.a;
            }
            if (p == 0.0) {
                return this.d;
            }
            if (p > this.sfB) {
                return this.a + Math.sqrt((1.0 - p) * this.divisor * this.bma);
            }
            if (p > this.sfC) {
                return 0.5 * ((1.0 - p) * this.divisor + this.a + this.b);
            }
            return this.d - Math.sqrt(p * this.divisor * this.dmc);
        }

        @Override
        public double getMean() {
            double scale = this.d - this.a;
            double bp = this.bma / scale;
            double cp = (this.c - this.a) / scale;
            return RegularTrapezoidalDistribution.nonCentralMoment(1, bp, cp) * scale + this.a;
        }

        @Override
        public double getVariance() {
            double scale = this.d - this.a;
            double bp = this.bma / scale;
            double cp = (this.c - this.a) / scale;
            double mu = RegularTrapezoidalDistribution.nonCentralMoment(1, bp, cp);
            return (RegularTrapezoidalDistribution.nonCentralMoment(2, bp, cp) - mu * mu) * scale * scale;
        }

        private static double nonCentralMoment(int k, double b, double c) {
            double term1 = c == 1.0 ? (double)(k + 2) : Math.expm1((double)(k + 2) * Math.log(c)) / (c - 1.0);
            double term2 = Math.pow(b, k + 1);
            return 2.0 * ((term1 - term2) / (c - b + 1.0) / (double)((k + 1) * (k + 2)));
        }
    }

    private static class UniformTrapezoidalDistribution
    extends DelegatedTrapezoidalDistribution {
        UniformTrapezoidalDistribution(double a, double d) {
            super(a, a, d, d, UniformContinuousDistribution.of(a, d));
        }
    }

    private static class TriangularTrapezoidalDistribution
    extends DelegatedTrapezoidalDistribution {
        TriangularTrapezoidalDistribution(double a, double b, double d) {
            super(a, b, b, d, TriangularDistribution.of(a, b, d));
        }
    }

    private static class DelegatedTrapezoidalDistribution
    extends TrapezoidalDistribution {
        private final ContinuousDistribution delegate;

        DelegatedTrapezoidalDistribution(double a, double b, double c, double d, ContinuousDistribution delegate) {
            super(a, b, c, d);
            this.delegate = delegate;
        }

        @Override
        public double density(double x) {
            return this.delegate.density(x);
        }

        @Override
        public double probability(double x0, double x1) {
            return this.delegate.probability(x0, x1);
        }

        @Override
        public double logDensity(double x) {
            return this.delegate.logDensity(x);
        }

        @Override
        public double cumulativeProbability(double x) {
            return this.delegate.cumulativeProbability(x);
        }

        @Override
        public double inverseCumulativeProbability(double p) {
            return this.delegate.inverseCumulativeProbability(p);
        }

        @Override
        public double survivalProbability(double x) {
            return this.delegate.survivalProbability(x);
        }

        @Override
        public double inverseSurvivalProbability(double p) {
            return this.delegate.inverseSurvivalProbability(p);
        }

        @Override
        public double getMean() {
            return this.delegate.getMean();
        }

        @Override
        public double getVariance() {
            return this.delegate.getVariance();
        }

        @Override
        public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
            return this.delegate.createSampler(rng);
        }
    }
}

