/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.matcher;

import org.apache.commons.text.matcher.AbstractStringMatcher;
import org.apache.commons.text.matcher.StringMatcher;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringMatcherTest {
    private static final char[] BUFFER1 = "0,1\t2 3\n\r\f\u0000'\"".toCharArray();
    private static final char[] BUFFER2 = "abcdef".toCharArray();

    @Test
    public void testCommaMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.commaMatcher();
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.commaMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 0, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 1, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 2, 0, BUFFER1.length)).isEqualTo(0);
    }

    @Test
    public void testTabMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.tabMatcher();
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.tabMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 2, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 3, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 4, 0, BUFFER1.length)).isEqualTo(0);
    }

    @Test
    public void testSpaceMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.spaceMatcher();
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.spaceMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 4, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 5, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 6, 0, BUFFER1.length)).isEqualTo(0);
    }

    @Test
    public void testSplitMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.splitMatcher();
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.splitMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 2, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 3, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 4, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 5, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 6, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 7, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 8, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 9, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 10, 0, BUFFER1.length)).isEqualTo(0);
    }

    @Test
    public void testTrimMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.trimMatcher();
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.trimMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 2, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 3, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 4, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 5, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 6, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 7, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 8, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 9, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 10, 0, BUFFER1.length)).isEqualTo(1);
    }

    @Test
    public void testSingleQuoteMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.singleQuoteMatcher();
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.singleQuoteMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 10, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 11, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 12, 0, BUFFER1.length)).isEqualTo(0);
    }

    @Test
    public void testDoubleQuoteMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.doubleQuoteMatcher();
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.doubleQuoteMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 11, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 12, 0, BUFFER1.length)).isEqualTo(1);
    }

    @Test
    public void testQuoteMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.quoteMatcher();
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.quoteMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 10, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 11, 0, BUFFER1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 12, 0, BUFFER1.length)).isEqualTo(1);
    }

    @Test
    public void testNoneMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.noneMatcher();
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.noneMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 0, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 1, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 2, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 3, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 4, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 5, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 6, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 7, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 8, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 9, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 10, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 11, 0, BUFFER1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER1, 12, 0, BUFFER1.length)).isEqualTo(0);
    }

    @Test
    public void testCharMatcher_char() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.charMatcher('c');
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 0, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 2, 0, BUFFER2.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 3, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 4, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 5, 0, BUFFER2.length)).isEqualTo(0);
    }

    @Test
    public void testCharSetMatcher_String() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.charSetMatcher("ace");
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 0, 0, BUFFER2.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 2, 0, BUFFER2.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 3, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 4, 0, BUFFER2.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 5, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.charSetMatcher("")).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.charSetMatcher((String)null)).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertThat((boolean)(StringMatcherFactory.INSTANCE.charSetMatcher("a") instanceof AbstractStringMatcher.CharMatcher)).isTrue();
    }

    @Test
    public void testCharSetMatcher_charArray() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.charSetMatcher("ace".toCharArray());
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 0, 0, BUFFER2.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 2, 0, BUFFER2.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 3, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 4, 0, BUFFER2.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 5, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.charSetMatcher(new char[0])).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.charSetMatcher((char[])null)).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertThat((boolean)(StringMatcherFactory.INSTANCE.charSetMatcher("a".toCharArray()) instanceof AbstractStringMatcher.CharMatcher)).isTrue();
    }

    @Test
    public void testStringMatcher_String() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.stringMatcher("bc");
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 0, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1, 0, BUFFER2.length)).isEqualTo(2);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 2, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 3, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 4, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 5, 0, BUFFER2.length)).isEqualTo(0);
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.stringMatcher("")).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.stringMatcher((String)null)).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
    }

    @Test
    public void testMatcherIndices() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.stringMatcher("bc");
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1, 1, BUFFER2.length)).isEqualTo(2);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1, 0, 3)).isEqualTo(2);
        Assertions.assertThat((int)matcher.isMatch(BUFFER2, 1, 0, 2)).isEqualTo(0);
    }
}

