/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClassLoaderUtilTest {
    private static final String TEST_CASE_CLASS_NAME = "org.apache.commons.jxpath.util.ClassLoaderUtilTest";
    private static final String EXAMPLE_CLASS_NAME = "org.apache.commons.jxpath.util.ClassLoadingExampleClass";
    private ClassLoader orginalContextClassLoader;

    public static void callExampleMessageMethodAndAssertClassNotFoundJXPathException() {
        JXPathContext context = JXPathContext.newContext((Object)new Object());
        Assertions.assertThrows(JXPathException.class, () -> context.selectSingleNode("org.apache.commons.jxpath.util.ClassLoadingExampleClass.getMessage()"), (String)"We should not be able to load org.apache.commons.jxpath.util.ClassLoadingExampleClass.");
    }

    public static void callExampleMessageMethodAndAssertSuccess() {
        JXPathContext context = JXPathContext.newContext((Object)new Object());
        Assertions.assertEquals((Object)"an example class", (Object)context.selectSingleNode("org.apache.commons.jxpath.util.ClassLoadingExampleClass.getMessage()"));
    }

    private void executeTestMethodUnderClassLoader(ClassLoader cl, String methodName) throws ReflectiveOperationException {
        block2: {
            Class<?> testClass = cl.loadClass(TEST_CASE_CLASS_NAME);
            Method testMethod = testClass.getMethod(methodName, ArrayUtils.EMPTY_CLASS_ARRAY);
            try {
                testMethod.invoke(null, (Object[])null);
            }
            catch (InvocationTargetException e) {
                if (!(e.getCause() instanceof RuntimeException)) break block2;
                throw (RuntimeException)e.getCause();
            }
        }
    }

    @BeforeEach
    public void setUp() {
        this.orginalContextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @AfterEach
    public void tearDown() {
        Thread.currentThread().setContextClassLoader(this.orginalContextClassLoader);
    }

    @Test
    public void testClassLoadFailWithoutContextClassLoader() throws ReflectiveOperationException {
        Thread.currentThread().setContextClassLoader(null);
        TestClassLoader cl = new TestClassLoader(this.getClass().getClassLoader());
        this.executeTestMethodUnderClassLoader(cl, "callExampleMessageMethodAndAssertClassNotFoundJXPathException");
    }

    @Test
    public void testClassLoadSuccessWithContextClassLoader() throws ReflectiveOperationException {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        TestClassLoader cl = new TestClassLoader(this.getClass().getClassLoader());
        this.executeTestMethodUnderClassLoader(cl, "callExampleMessageMethodAndAssertSuccess");
    }

    @Test
    public void testClassLoadSuccessWithoutContextClassLoader() {
        Thread.currentThread().setContextClassLoader(null);
        ClassLoaderUtilTest.callExampleMessageMethodAndAssertSuccess();
    }

    @Test
    public void testCurrentClassLoaderFallback() {
        TestClassLoader cl = new TestClassLoader(this.getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(cl);
        ClassLoaderUtilTest.callExampleMessageMethodAndAssertSuccess();
    }

    private static final class TestClassLoader
    extends ClassLoader {
        private Class<?> testCaseClass = null;

        public TestClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        public synchronized Class<?> loadClass(String name, boolean resolved) throws ClassNotFoundException {
            if (ClassLoaderUtilTest.EXAMPLE_CLASS_NAME.equals(name)) {
                throw new ClassNotFoundException();
            }
            if (ClassLoaderUtilTest.TEST_CASE_CLASS_NAME.equals(name)) {
                if (this.testCaseClass == null) {
                    byte[] clazzBytes;
                    URL classUrl = this.getParent().getResource("org/apache/commons/jxpath/util/ClassLoaderUtilTest.class");
                    try {
                        clazzBytes = IOUtils.toByteArray((URL)classUrl);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(classUrl.toString(), e);
                    }
                    this.testCaseClass = this.defineClass(ClassLoaderUtilTest.TEST_CASE_CLASS_NAME, clazzBytes, 0, clazzBytes.length);
                }
                return this.testCaseClass;
            }
            return this.getParent().loadClass(name);
        }
    }
}

