/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.xml.DocumentContainer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLPreserveSpaceTest
extends AbstractJXPathTest {
    protected JXPathContext context;

    protected JXPathContext createContext(String model) {
        JXPathContext context = JXPathContext.newContext((Object)this.createDocumentContainer(model));
        return context;
    }

    protected DocumentContainer createDocumentContainer(String model) {
        return new DocumentContainer(AbstractJXPathTest.class.getResource("XmlPreserveSpace.xml"), model);
    }

    protected void doTest(String id, String model, String expectedValue) {
        JXPathContext context = JXPathContext.newContext((Object)this.createDocumentContainer(model));
        Assertions.assertEquals((Object)expectedValue, (Object)context.getValue("test/text[@id='" + id + "']"));
    }

    @Test
    public void testDefaultDOM() {
        this.doTest("default", "DOM", "foo");
    }

    @Test
    public void testDefaultJDOM() {
        this.doTest("default", "JDOM", "foo");
    }

    @Test
    public void testNestedDOM() {
        this.doTest("nested", "DOM", " foo ;bar; baz ");
    }

    @Test
    public void testNestedJDOM() {
        this.doTest("nested", "JDOM", " foo ;bar; baz ");
    }

    @Test
    public void testNestedWithCommentsDOM() {
        this.doTest("nested-with-comments", "DOM", " foo ;bar; baz ");
    }

    @Test
    public void testNestedWithCommentsJDOM() {
        this.doTest("nested-with-comments", "JDOM", " foo ;bar; baz ");
    }

    @Test
    public void testPreserveDOM() {
        this.doTest("preserve", "DOM", " foo ");
    }

    @Test
    public void testPreserveJDOM() {
        this.doTest("preserve", "JDOM", " foo ");
    }

    @Test
    public void testUnspecifiedDOM() {
        this.doTest("unspecified", "DOM", " foo ");
    }

    @Test
    public void testUnspecifiedJDOM() {
        this.doTest("unspecified", "JDOM", " foo ");
    }
}

