// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
package com.cloud.hypervisor.dao;

import java.util.List;

import com.cloud.hypervisor.Hypervisor.HypervisorType;
import com.cloud.hypervisor.HypervisorCapabilitiesVO;
import com.cloud.utils.db.GenericDao;

public interface HypervisorCapabilitiesDao extends GenericDao<HypervisorCapabilitiesVO, Long> {

    List<HypervisorCapabilitiesVO> listAllByHypervisorType(HypervisorType hypervisorType);

    HypervisorCapabilitiesVO findByHypervisorTypeAndVersion(HypervisorType hypervisorType, String hypervisorVersion);

    Long getMaxGuestsLimit(HypervisorType hypervisorType, String hypervisorVersion);

    Integer getMaxDataVolumesLimit(HypervisorType hypervisorType, String hypervisorVersion);

    Integer getMaxHostsPerCluster(HypervisorType hypervisorType, String hypervisorVersion);

    Boolean isVmSnapshotEnabled(HypervisorType hypervisorType, String hypervisorVersion);

    List<HypervisorType> getHypervisorsWithDefaultEntries();

    boolean isStorageMotionSupported(HypervisorType hypervisorType, String hypervisorVersion);
}
