/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.builders;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.dataflow.data.nontagged.serde.SerializerDeserializerUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.storage.common.arraylist.IntArrayList;

public abstract class AbstractListBuilder
implements IAsterixListBuilder {
    protected final ATypeTag listType;
    protected final GrowableArray outputStorage = new GrowableArray();
    protected final IntArrayList offsets;
    private final DataOutputStream outputStream = (DataOutputStream)this.outputStorage.getDataOutput();
    private int metadataInfoSize = 0;
    private byte[] offsetArray = null;
    private int offsetPosition = 0;
    private int headerSize;
    private ATypeTag itemTypeTag;
    protected boolean fixedSize = false;
    protected int numberOfItems;

    public AbstractListBuilder(ATypeTag listType) {
        this.offsets = new IntArrayList(10, 10);
        this.listType = listType;
    }

    @Override
    public void reset(AbstractCollectionType listType) {
        this.outputStorage.reset();
        this.offsets.clear();
        this.offsetPosition = 0;
        this.numberOfItems = 0;
        if (listType == null || listType.getItemType() == null) {
            this.itemTypeTag = ATypeTag.ANY;
            this.fixedSize = false;
        } else {
            this.itemTypeTag = listType.getItemType().getTypeTag();
            this.fixedSize = NonTaggedFormatUtil.isFixedSizedCollection(listType.getItemType());
        }
        this.headerSize = 2;
        this.metadataInfoSize = 8;
    }

    @Override
    public void addItem(IValueReference item) throws HyracksDataException {
        try {
            byte[] data = item.getByteArray();
            int start = item.getStartOffset();
            int len = item.getLength();
            byte serializedTypeTag = data[start];
            if (!this.fixedSize && (serializedTypeTag != ATypeTag.SERIALIZED_NULL_TYPE_TAG && serializedTypeTag != ATypeTag.SERIALIZED_MISSING_TYPE_TAG || this.itemTypeTag == ATypeTag.ANY)) {
                this.offsets.add(this.outputStorage.getLength());
            }
            if (this.toWriteTag(serializedTypeTag)) {
                ++this.numberOfItems;
                this.outputStream.write(serializedTypeTag);
                this.outputStream.write(data, start + 1, len - 1);
            } else if (serializedTypeTag != ATypeTag.SERIALIZED_NULL_TYPE_TAG && serializedTypeTag != ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                ++this.numberOfItems;
                this.outputStream.write(data, start + 1, len - 1);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private boolean toWriteTag(byte serializedTypeTag) {
        boolean toWriteTag = this.itemTypeTag == ATypeTag.ANY;
        toWriteTag = toWriteTag || this.itemTypeTag == ATypeTag.NULL && serializedTypeTag == ATypeTag.SERIALIZED_NULL_TYPE_TAG;
        return toWriteTag || this.itemTypeTag == ATypeTag.MISSING && serializedTypeTag == ATypeTag.SERIALIZED_MISSING_TYPE_TAG;
    }

    @Override
    public void write(DataOutput out, boolean writeTypeTag) throws HyracksDataException {
        try {
            if (!this.fixedSize) {
                this.metadataInfoSize += this.offsets.size() * 4;
            }
            if (this.offsetArray == null || this.offsetArray.length < this.metadataInfoSize) {
                this.offsetArray = new byte[this.metadataInfoSize];
            }
            SerializerDeserializerUtil.writeIntToByteArray(this.offsetArray, this.headerSize + this.metadataInfoSize + this.outputStorage.getLength(), this.offsetPosition);
            SerializerDeserializerUtil.writeIntToByteArray(this.offsetArray, this.numberOfItems, this.offsetPosition + 4);
            if (!this.fixedSize) {
                this.offsetPosition += 8;
                for (int i = 0; i < this.offsets.size(); ++i) {
                    SerializerDeserializerUtil.writeIntToByteArray(this.offsetArray, this.offsets.get(i) + this.metadataInfoSize + this.headerSize, this.offsetPosition);
                    this.offsetPosition += 4;
                }
            }
            if (writeTypeTag) {
                out.writeByte(this.listType.serialize());
            }
            out.writeByte(this.itemTypeTag.serialize());
            out.write(this.offsetArray, 0, this.metadataInfoSize);
            out.write(this.outputStorage.getByteArray(), 0, this.outputStorage.getLength());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

