/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestProducerFactoryHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RestProducerFactoryHelper.class);

    private RestProducerFactoryHelper() {
    }

    public static void setupComponentFor(String url, CamelContext camelContext, Map<String, Object> componentProperties) throws Exception {
        String scheme = StringHelper.before(url, ":");
        RestProducerFactoryHelper.setupComponent(scheme, camelContext, componentProperties);
    }

    public static Component setupComponent(String componentName, CamelContext camelContext, Map<String, Object> componentProperties) throws Exception {
        if (componentProperties == null || componentProperties.isEmpty()) {
            return camelContext.getComponent(componentName);
        }
        Component existing = camelContext.getComponent(componentName, false, false);
        if (existing != null) {
            if (!componentProperties.isEmpty()) {
                LOG.warn("Found existing `{}` component already present in the Camel context. Not setting component properties on the existing component. You can either prevent the component creation or set the given properties on the component. Component properties given: {}", (Object)componentName, componentProperties);
            }
            return existing;
        }
        Component newlyCreated = camelContext.getComponent(componentName, true, false);
        HashMap<String, Object> copyOfComponentProperties = new HashMap<String, Object>(componentProperties);
        IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), newlyCreated, copyOfComponentProperties);
        ServiceHelper.startService(newlyCreated);
        return newlyCreated;
    }
}

