/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: InitialisationAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2004/06/07 15:17:35 $
 *****************************************************************************/
package org.ten60.netkernel.cocoon;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.*;

import org.apache.cocoon.*;
import org.apache.cocoon.transformation.*;
import org.apache.cocoon.environment.*;
import org.apache.cocoon.components.*;
import org.apache.avalon.framework.parameters.*;
import org.apache.avalon.framework.configuration.*;
import org.apache.avalon.framework.service.*;
import org.apache.avalon.framework.logger.*;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.excalibur.component.*;

import java.util.*;
import java.util.logging.*;

import java.net.*;
/**
 *
 * @author  tab
 */
public class InitialisationAccessor extends XAccessor
{
	private static org.apache.avalon.framework.logger.Logger sLogger;
	private static ServiceManager sServiceManager;
	private static Configuration sConfiguration;
	private static Map sObjectModel;
	
	static
	{	java.util.logging.Logger jdkLogger = java.util.logging.Logger.getLogger("com.ten60.netkernel.util.SysLogger");
		sLogger = new Jdk14Logger(jdkLogger);
		sObjectModel = new EmptyObjectModel();
	}
	
	/** Creates a new instance of TransformerAdapter */
	public InitialisationAccessor() throws Exception
	{	declareArgument(XAccessor.OPERAND, true, false);
	}
	
	protected IURRepresentation source(XAHelper aHelper) throws Throwable
	{	
		// roles
		Class c2 = getClass().forName("org.xml.sax.ContentHandler");
		System.out.println("class="+c2.toString());
		SAXConfigurationHandler b = new SAXConfigurationHandler();
		IAspectSAX c = (IAspectSAX)aHelper.getResource(URI.create("ffcpl:/org/apache/cocoon/cocoon.roles"), IAspectSAX.class).getAspect(IAspectSAX.class);
		c.handleContent(b,null,null);
		Configuration roleConfig = b.getConfiguration();
		DefaultRoleManager drm = new DefaultRoleManager();
		drm.enableLogging(sLogger);
		ContainerUtil.configure(drm, roleConfig);

		// user configuration file
		URI configuration = aHelper.getURI(aHelper.OPERAND);
		c = (IAspectSAX)aHelper.getResource(configuration, IAspectSAX.class).getAspect(IAspectSAX.class);
		c.handleContent(b,null,null);
		roleConfig = b.getConfiguration();
		DefaultRoleManager urm = new DefaultRoleManager(drm);
		urm.enableLogging(sLogger);
		ContainerUtil.configure(urm, roleConfig);

		CocoonComponentManager ccm = new CocoonComponentManager(getModule().getClassLoader());
		ccm.setRoleManager(urm);
		ccm.checkEnvironment(sLogger);
		ccm.enableLogging(sLogger);
		ContainerUtil.configure(ccm, roleConfig);
		ComponentContext ctx = new ComponentContext(new HashMap());
		ContainerUtil.contextualize(ccm,ctx);
		//ContainerUtil.initialize(ccm);

		sServiceManager = new WrapperServiceManager(ccm); //new DefaultServiceManager();
			
		if (sConfiguration==null)
		{	// keep it empty
			sConfiguration = new DefaultConfiguration("Mmm");
		}
		
		IURMeta meta = aHelper.getDependencyMeta("application/void", 256);
		return new MonoRepresentationImpl(meta,new org.ten60.netkernel.layer1.representation.VoidAspect());
	}
	
	public static ServiceManager getServiceManager()
	{	return sServiceManager;
	}
	
	public static Configuration getConfiguration()
	{	return sConfiguration;
	}
	
	public static org.apache.avalon.framework.logger.Logger getLogger()
	{	return sLogger;
	}
	
	public static Map getObjectModel()
	{	return sObjectModel;
	}
}