/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: GeneratorSAXAspect.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2004/06/07 15:17:35 $
 *****************************************************************************/
package org.ten60.netkernel.cocoon;

import org.ten60.netkernel.xml.representation.IAspectSAX;
import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import com.ten60.netkernel.util.NetKernelException;

import org.apache.cocoon.*;
import org.apache.cocoon.xml.*;
import org.apache.cocoon.generation.*;
import org.apache.cocoon.environment.*;
import org.apache.cocoon.components.*;
import org.apache.avalon.framework.parameters.*;
import org.apache.avalon.framework.configuration.*;
import org.apache.avalon.framework.service.*;
import org.apache.avalon.framework.logger.*;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.excalibur.component.*;

import java.util.*;
import java.net.URISyntaxException;
import java.util.logging.*;
import java.net.URI;
//import java.net.*;


import org.xml.sax.*;
import org.xml.sax.ext.*;
/**
 *
 * @author  tab
 */
public class GeneratorSAXAspect implements IAspectSAX
{
	private AbstractGenerator mGenerator;
	private XAHelper mHelper;
	private Map mObjectModel;
	private String mSrc;
	private Parameters mParameters;
	
	/** Creates a new instance of GeneratorSAXAspect */
	public GeneratorSAXAspect(AbstractGenerator aGenerator, XAHelper aHelper) throws URISyntaxException, NetKernelException, XPathLocationException
	{	mGenerator = aGenerator;
		mHelper = aHelper;
		mObjectModel = Collections.EMPTY_MAP;
		URI src = aHelper.getURI("src");
		if (src!=null)
		{	mSrc = src.toString();
		}
		mParameters = new Parameters();
		if (aHelper.getURI(XAHelper.PARAMETER)!=null)
		{
			IXDAReadOnlyIterator i = aHelper.getParameter().getXDA().readOnlyIterator("//map:parameter");
			while (i.hasNext())
			{	i.next();
				String name=i.getText("@name", false);
				String value=i.getText("@value",false);
				mParameters.setParameter(name, value);
			}
		}
	}
	
	public synchronized void handleContent(ContentHandler aContentHandler, LexicalHandler aLexicalHandler, List aUsageDependencies) throws java.io.IOException, SAXException
	{	try
		{
			// initialise transformer
			org.apache.avalon.framework.logger.Logger logger = InitialisationAccessor.getLogger();
			mGenerator.enableLogging(logger);
			if (mGenerator instanceof Serviceable)
			{	Serviceable serviceable= (Serviceable)mGenerator;
				ServiceManager manager = InitialisationAccessor.getServiceManager();
				serviceable.service(manager);
			}
			if (mGenerator instanceof Configurable)
			{	Configurable configurable= (Configurable)mGenerator;
				Configuration configuration = InitialisationAccessor.getConfiguration();
				configurable.configure(configuration);
			}
			XASourceResolver resolver = new XASourceResolver(mHelper,aUsageDependencies);
			mGenerator.setup(resolver,mObjectModel,mSrc,mParameters);
		
			// link pipeline and generate
			XMLConsumer consumer = new ContentHandlerWrapper(aContentHandler,aLexicalHandler);
			mGenerator.setConsumer(consumer);
			mGenerator.generate();
		}
		catch (org.apache.avalon.framework.CascadingException e)
		{	SAXException ex = new SAXException("Failure to processing generator: "+e.getClass().getName(),e);
			ex.initCause(e);
			throw ex;
		}
		finally
		{
			// reset generator
			mGenerator.recycle();
		}
	}	
}