/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: GeneratorAdapter.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2004/06/07 15:17:35 $
 *****************************************************************************/
package org.ten60.netkernel.cocoon;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.DependencyMeta;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.*;

import org.apache.cocoon.*;
import org.apache.cocoon.generation.*;
import org.apache.cocoon.environment.*;
import org.apache.cocoon.components.*;
import org.apache.avalon.framework.parameters.*;
import org.apache.avalon.framework.configuration.*;
import org.apache.avalon.framework.service.*;
import org.apache.avalon.framework.logger.*;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.excalibur.component.*;

import java.util.*;
import java.util.logging.*;

import java.net.*;
/**
 *
 * @author  tab
 */
public class GeneratorAdapter extends XAccessor
{
	private static Map sTypeToClassMap = new HashMap();
	static
	{	// core ones
		sTypeToClassMap.put("FileGenerator","org.apache.cocoon.generation.FileGenerator");
		sTypeToClassMap.put("ServerPagesGenerator","org.apache.cocoon.generation.ServerPagesGenerator");
		sTypeToClassMap.put("DirectoryGenerator","org.apache.cocoon.generation.DirectoryGenerator");
		sTypeToClassMap.put("XPathDirectoryGenerator","org.apache.cocoon.generation.XPathDirectoryGenerator");
		sTypeToClassMap.put("ImageDirectoryGenerator","org.apache.cocoon.generation.ImageDirectoryGenerator");
		sTypeToClassMap.put("MP3DirectoryGenerator","org.apache.cocoon.generation.MP3DirectoryGenerator");
		sTypeToClassMap.put("RequestGenerator","org.apache.cocoon.generation.RequestGenerator");
		sTypeToClassMap.put("StreamGenerator","org.apache.cocoon.generation.StreamGenerator");
		sTypeToClassMap.put("StatusGenerator","org.apache.cocoon.generation.StatusGenerator");
		sTypeToClassMap.put("JXTemplateGenerator","org.apache.cocoon.generation.JXTemplateGenerator");
		sTypeToClassMap.put("NotifyingGenerator","org.apache.cocoon.generation.NotifyingGenerator");
		sTypeToClassMap.put("ConfigurationGenerator","org.apache.cocoon.webapps.authentication.generation.ConfigurationGenerator");
		sTypeToClassMap.put("FragmentExtractorGenerator","org.apache.cocoon.generation.FragmentExtractorGenerator");
		sTypeToClassMap.put("ScriptGenerator","org.apache.cocoon.generation.ScriptGenerator");
		sTypeToClassMap.put("TextGenerator","org.apache.cocoon.generation.TextGenerator");
		sTypeToClassMap.put("HTMLGenerator","org.apache.cocoon.generation.HTMLGenerator");
		sTypeToClassMap.put("JSPGenerator","org.apache.cocoon.generation.JSPGenerator");
		sTypeToClassMap.put("JXFormsGenerator","org.apache.cocoon.generation.JXFormsGenerator");
		sTypeToClassMap.put("SearchGenerator","org.apache.cocoon.generation.SearchGenerator");
		sTypeToClassMap.put("XMidiGenerator","org.apache.cocoon.generation.XMidiGenerator");
		sTypeToClassMap.put("PhpGenerator","org.apache.cocoon.generation.PhpGenerator");
		sTypeToClassMap.put("PortalGenerator","org.apache.cocoon.generation.PortalGenerator");
		sTypeToClassMap.put("ConfigurationGenerator","org.apache.cocoon.generation.ConfigurationGenerator");
		sTypeToClassMap.put("HttpProxyGenerator","org.apache.cocoon.generation.HttpProxyGenerator");
		sTypeToClassMap.put("WebServiceProxyGenerator","org.apache.cocoon.generation.WebServiceProxyGenerator");
		sTypeToClassMap.put("SlopGenerator","org.apache.cocoon.slop.generation.SlopGenerator");
		sTypeToClassMap.put("VelocityGenerator","org.apache.cocoon.generation.VelocityGenerator");
	}
	
	/** Creates a new instance of TransformerAdapter */
	public GeneratorAdapter() throws Exception
	{	declareArgument("src", false, false);
		declareArgument(XAccessor.PARAMETER, false, false);
	}
	
	protected IURRepresentation source(XAHelper aHelper) throws Throwable
	{	String type=aHelper.getType();
		String className=null;
		if (!type.startsWith("cocoon.generator.") || (className=(String)sTypeToClassMap.get(type.substring(17)))==null)
		{	throw new NetKernelException("Unsupported Generator","The generator ["+type+"] is unsupported",type);
		}
		Class generatorClass = Class.forName(className);
		AbstractGenerator generator = (AbstractGenerator)generatorClass.newInstance();
		IURMeta meta = aHelper.getDependencyMeta("text/xml", 4);
		IAspectSAX resultAspect = new GeneratorSAXAspect(generator,aHelper);
		IURRepresentation result = new MonoRepresentationImpl(meta,resultAspect);
		return result;
	}
}