/* $Id: bitwise.h,v 1.1 2005/10/21 21:54:55 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Interface to "bitwise" types
 */
#ifndef PyPg_type_bitwise_H
#define PyPg_type_bitwise_H 0
#ifdef __cplusplus
extern "C" {
#endif

IF_PGTYPE_BOOL(extern PyPgTypeObject PyPg_bool_Type;)
IF_PGTYPE_BIT(extern PyPgTypeObject PyPg_bit_Type;)
IF_PGTYPE_VARBIT(extern PyPgTypeObject PyPg_varbit_Type;)
IF_PGTYPE_BYTEA(extern PyPgTypeObject PyPg_bytea_Type;)

#define PyPg_bool_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_bool_Type))
#define PyPg_bool_CheckExact(SELF) ((SELF)->ob_type == &PyPg_bool_Type)

#define PyPg_bit_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_bit_Type))
#define PyPg_bit_CheckExact(SELF) ((SELF)->ob_type == &PyPg_bit_Type)

#define PyPg_varbit_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_varbit_Type))
#define PyPg_varbit_CheckExact(SELF) ((SELF)->ob_type == &PyPg_varbit_Type)

#ifdef PGTYPE_BYTEA
#define PyPgBytea_BODY \
	unsigned long position;

#define PyPgBytea_HEAD \
	PyPgObject_HEAD \
	PyPgBytea_BODY

typedef struct PyPg_bytea {
	PyPgBytea_HEAD
} * PyPg_bytea;

#define PyPg_bytea_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_bytea_Type))
#define PyPg_bytea_CheckExact(SELF) ((SELF)->ob_type == &PyPg_bytea_Type)
#endif /* BYTEA */

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_type_bitwise_H */
/*
 * vim: ts=3:sw=3:noet:
 */
