<?xml version="1.0" encoding="utf-8" ?>
<!-- Copyright (c) 2009-2010, NIPPON TELEGRAPH AND TELEPHONE CORPORATION -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >

<xsl:template match="/"> 
  <html>
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
      <title>List of Databases</title>
      <link rel="stylesheet" type="text/css" href="../css/style.css" />
    </head>
    <body>
      <h1>List of Databases</h1>
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>Host</th>
            <th>Port</th>
            <th>Database</th>
          </tr>
        </thead>
        <tbody>
          <xsl:apply-templates select="dbnames/*" />
          <tr>
            <td><a href="files">(files)</a></td>
            <td align="center">-</td>
            <td align="center">-</td>
            <td align="center">-</td>
          </tr>
        </tbody>
      </table>

      <p>TIPS: You can edit '{HTTPD_DIR}/.dbnames' to add databases in this list.</p>
    </body>
  </html>
</xsl:template>

<xsl:template match="dbname">
  <tr>
    <td><a href="{id}/"><xsl:value-of select="id" /></a></td>
    <td><xsl:value-of select="host" /></td>
    <td align="right"><xsl:value-of select="port" /></td>
    <td><xsl:value-of select="database" /></td>
  </tr>
</xsl:template>

</xsl:stylesheet>
