/* Module:          SQLSetConnectOption.c
 *
 * Description:     Has been replaced by SQLSetConnectAttr. 
 *
 * Classes:         
 *
 * API functions:   SQLSetConnectOption
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

RETCODE set_statement_option(ConnectionClass *conn, 
							 StatementClass *stmt, 
							 UWORD   fOption,
							 UDWORD  vParam);

SQLRETURN SQL_API SQLSetConnectOption(
        SQLHDBC    hDrvDbc,
        SQLUSMALLINT   nOption,
        SQLUINTEGER  vParam)
{
	static char *func="SQLSetConnectOption";
	ConnectionClass *conn = (ConnectionClass *) hDrvDbc;
	char changed = FALSE;
	SQLRETURN retval;
	int i;

	mylog("%s: entering...\n", func);

	if ( ! conn)
	{
		CC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}


	switch (nOption) 
	{

		/* Statement Options
		(apply to all stmts on the connection and become defaults for new stmts)
		*/
		case SQL_ASYNC_ENABLE:
		case SQL_BIND_TYPE:
		case SQL_CONCURRENCY:
		case SQL_CURSOR_TYPE:
		case SQL_KEYSET_SIZE:
		case SQL_MAX_LENGTH:
		case SQL_MAX_ROWS:
		case SQL_NOSCAN:
		case SQL_QUERY_TIMEOUT:
		case SQL_RETRIEVE_DATA:
		case SQL_ROWSET_SIZE:
		case SQL_SIMULATE_CURSOR:
		case SQL_USE_BOOKMARKS:

		/*	Affect all current Statements */
		for (i = 0; i < conn->num_stmts; i++)
		{
			if ( conn->stmts[i])
			{
				set_statement_option(NULL, conn->stmts[i], nOption, vParam);
			}
		}

		/*	Become the default for all future statements on this connection */
		retval = set_statement_option(conn, NULL, nOption, vParam);

		if (retval == SQL_SUCCESS_WITH_INFO)
		{
			changed = TRUE;
		}
		else if (retval == SQL_ERROR)
		{
			return SQL_ERROR;
		}

		break;

	/**********************************/
	/*****	Connection Options  *******/	
	/**********************************/
		case SQL_ACCESS_MODE: /* ignored */
			break;

		case SQL_AUTOCOMMIT:
			if (CC_is_in_trans(conn))
			{
			conn->errormsg = "Cannot switch commit mode while a transaction is in progress";
			conn->errornumber = CONN_TRANSACT_IN_PROGRES;
			CC_log_error(func, "", conn);
			return SQL_ERROR;
			}
			
			mylog("SQLSetConnectOption: AUTOCOMMIT: transact_status=%d, vparam=%d\n", conn->transact_status, vParam);

		switch(vParam)
		{
			case SQL_AUTOCOMMIT_OFF:
				CC_set_autocommit_off(conn);
				break;

			case SQL_AUTOCOMMIT_ON:
				CC_set_autocommit_on(conn);
				break;

			default:
				conn->errormsg = "Illegal parameter value for SQL_AUTOCOMMIT";
				conn->errornumber = CONN_INVALID_ARGUMENT_NO;
				CC_log_error(func, "", conn);
				return SQL_ERROR;
		}
			break;

		case SQL_CURRENT_QUALIFIER: /* ignored */
			break;

		case SQL_LOGIN_TIMEOUT: /* ignored */
			break;

		case SQL_PACKET_SIZE:	/* ignored */
			break;

		case SQL_QUIET_MODE:	/* ignored */
			break;

		case SQL_TXN_ISOLATION: /* ignored */
			break;

		/*	These options should be handled by driver manager */
		case SQL_ODBC_CURSORS:
		case SQL_OPT_TRACE:
		case SQL_OPT_TRACEFILE:
		case SQL_TRANSLATE_DLL:
		case SQL_TRANSLATE_OPTION:
			CC_log_error(func, "This connect option (Set) is only used by the Driver Manager", conn);
			break;

		default:
			{
				char option[64];
				conn->errormsg = "Unknown connect option (Set)";
				conn->errornumber = CONN_UNSUPPORTED_OPTION;
				sprintf(option, "nOption=%d, vParam=%ld", nOption, vParam);
				CC_log_error(func, option, conn);
				return SQL_ERROR;
			}

	}    

	if (changed) 
	{
		conn->errornumber = CONN_OPTION_VALUE_CHANGED;
		conn->errormsg = "Requested value changed.";
		return SQL_SUCCESS_WITH_INFO;
	}
	else
	{
		return SQL_SUCCESS;
	}
}

