/* Module:          SQLGetStmtOption.c
 *
 * Description:     Has been replaced by SQLGetStmtAttr. 
 *
 * Classes:         
 *
 * API functions:   SQLGetStmtOption
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLGetStmtOption(
        SQLHSTMT   hDrvStmt,
        SQLUSMALLINT   fOption,
        SQLPOINTER     pvParam)
{
static char *func="SQLGetStmtOption";
StatementClass *stmt = (StatementClass *) hDrvStmt;
QResultClass *res;

	mylog("%s: entering...\n", func);

	/* thought we could fake Access out by just returning SQL_SUCCESS */
	/* all the time, but it tries to set a huge value for SQL_MAX_LENGTH */
	/* and expects the driver to reduce it to the real value */

	if( ! stmt) {
		SC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	switch(fOption) {
	case SQL_GET_BOOKMARK:
	case SQL_ROW_NUMBER:

		res = stmt->result;

		if ( stmt->manual_result || ! globals.use_declarefetch) {
			/* make sure we're positioned on a valid row */
			if((stmt->currTuple < 0) ||
			   (stmt->currTuple >= QR_get_num_tuples(res))) {
				stmt->errormsg = "Not positioned on a valid row.";
				stmt->errornumber = STMT_INVALID_CURSOR_STATE_ERROR;
				SC_log_error(func, "", stmt);
				return SQL_ERROR;
			}
		}
		else {
			if (stmt->currTuple == -1 || ! res || ! res->tupleField) {
				stmt->errormsg = "Not positioned on a valid row.";
				stmt->errornumber = STMT_INVALID_CURSOR_STATE_ERROR;
				SC_log_error(func, "", stmt);
				return SQL_ERROR;
			}
		}

		if (fOption == SQL_GET_BOOKMARK && stmt->options.use_bookmarks == SQL_UB_OFF) {
			stmt->errormsg = "Operation invalid because use bookmarks not enabled.";
			stmt->errornumber = STMT_OPERATION_INVALID;
			SC_log_error(func, "", stmt);
			return SQL_ERROR;
		}

		*((UDWORD *) pvParam) = SC_get_bookmark(stmt);
		
		break;

	case SQL_ASYNC_ENABLE:	/* NOT SUPPORTED */
		*((SDWORD *) pvParam) = SQL_ASYNC_ENABLE_OFF;
		break;

	case SQL_BIND_TYPE:
		*((SDWORD *) pvParam) = stmt->options.bind_size;
		break;

	case SQL_CONCURRENCY: /* NOT REALLY SUPPORTED */
		mylog("GetStmtOption(): SQL_CONCURRENCY\n");
		*((SDWORD *)pvParam) = stmt->options.scroll_concurrency;
		break;

	case SQL_CURSOR_TYPE: /* PARTIAL SUPPORT */
		mylog("GetStmtOption(): SQL_CURSOR_TYPE\n");
		*((SDWORD *)pvParam) = stmt->options.cursor_type;
		break;

	case SQL_KEYSET_SIZE: /* NOT SUPPORTED, but saved */
		mylog("GetStmtOption(): SQL_KEYSET_SIZE\n");
		*((SDWORD *)pvParam) = stmt->options.keyset_size;
		break;

	case SQL_MAX_LENGTH: /* NOT SUPPORTED, but saved */
		*((SDWORD *)pvParam) = stmt->options.maxLength;
		break;

	case SQL_MAX_ROWS: /* NOT SUPPORTED, but saved */
		*((SDWORD *)pvParam) = stmt->options.maxRows;
		mylog("GetSmtOption: MAX_ROWS, returning %d\n", stmt->options.maxRows);
		break;

	case SQL_NOSCAN:/* NOT SUPPORTED */
		*((SDWORD *) pvParam) = SQL_NOSCAN_ON;
		break;

	case SQL_QUERY_TIMEOUT: /* NOT SUPPORTED */
		*((SDWORD *) pvParam) = 0;
		break;

	case SQL_RETRIEVE_DATA: /* NOT SUPPORTED, but saved */
		*((SDWORD *) pvParam) = stmt->options.retrieve_data;
		break;

	case SQL_ROWSET_SIZE:
		*((SDWORD *) pvParam) = stmt->options.rowset_size;
		break;

	case SQL_SIMULATE_CURSOR:/* NOT SUPPORTED */
		*((SDWORD *) pvParam) = SQL_SC_NON_UNIQUE;
		break;

	case SQL_USE_BOOKMARKS:
		*((SDWORD *) pvParam) = stmt->options.use_bookmarks;
		break;

	default:
		{
		char option[64];
		stmt->errornumber = STMT_NOT_IMPLEMENTED_ERROR;
		stmt->errormsg = "Unknown statement option (Get)";
		sprintf(option, "fOption=%d", fOption);
		SC_log_error(func, option, stmt);
		return SQL_ERROR;
		}
	}

	return SQL_SUCCESS;
}

