/* Module:          SQLConnect.c
 *
 * Description:     Establishes connections to a driver and a data source. 
 *
 * Classes:         
 *
 * API functions:   SQLConnect
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLConnect(
							 SQLHDBC			hDrvDbc,
							 SQLCHAR			*szDataSource,
							 SQLSMALLINT		nDataSourceLength,
							 SQLCHAR			*szUID,
							 SQLSMALLINT		nUIDLength,
							 SQLCHAR			*szPWD,
							 SQLSMALLINT		nPWDLength)
{
	ConnectionClass *conn = (ConnectionClass *) hDrvDbc;
	ConnInfo *ci;
	static char *func = "SQLConnect";

	mylog( "%s: entering...\n", func);

	if ( ! conn)
	{
		CC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	ci = &conn->connInfo;

	make_string(szDataSource, nDataSourceLength, ci->dsn);

	/*	get the values for the DSN from the registry */
	getDSNinfo(ci, CONN_OVERWRITE);
	/*	initialize pg_version from connInfo.protocol	*/
	CC_initialize_pg_version(conn); 
	
	/*	override values from DSN info with UID and authStr(pwd) 
		This only occurs if the values are actually there.
	*/
	make_string(szUID, nUIDLength, ci->username);
	make_string(szPWD, nPWDLength, ci->password);

	/* fill in any defaults */
	getDSNdefaults(ci);

	qlog("conn = %u, %s(DSN='%s', UID='%s', PWD='%s')\n", conn, func, ci->dsn, ci->username, ci->password);

	if ( CC_connect(conn, FALSE) <= 0)
	{
		/*	Error messages are filled in */
		CC_log_error(func, "Error on CC_connect", conn);
		return SQL_ERROR;
	}

	mylog( "%s: returning...\n", func);

	return SQL_SUCCESS;
}
