/* Written by Morgoth DBMA, morgothdbma@o2.pl
 This is part of PgXexplorer software, Open Source
 on BSD licence, Libraries(interaces) used:
 GNU GCC, AS (all stuff needed to compile C source into executable binary)
 LibPQ-FE from PostgreSQL, GTK (GIMP Toolkit)
 written in VIM editor, ctags used, CVS used
 Currently only one author: MOrgoth DBMA
 ! THIS FILE IS BASED ON GTK EXAMPLE FROM INTERNET !
 ! MANY GTK UI FUNCTIONS ARE BASED ON SOMEBODY'S EXAMLE CODE !
 ! BUT I DON'T KNOW THEIR PERSONALITY SO SORRY !
 ! I CANNOT ADD THEM TO AUTORS, BUT THANKS FOR SUPPORT ME !
 FILE: main.c */
#include "common.h"
#include "main.h"
#include "pgxexplorer.h"

PGconn* connection;	/* variables here */
char* currentbase;
char tmpstr[STDSTRING];
GtkWidget* main_wnd;
GtkWidget* main_vbox;
GtkWidget* query_exec;
int connected=0;
int timeout=10;
int want_all_elems=0;
int max_tabs=32;
int cont=1;
struct main_components components;
extern struct mem_list* mlist;

void disconnect()
{
 debug("%s:%d",__FILE__,__LINE__);
 if (connected) disconnect_db(&connection);
 connected=0;
 connection=0;
 destroy_all_components();
}


void __dummy( GtkWidget *w,gpointer data)
{
 debug("%s:%d",__FILE__,__LINE__);
 error("Not yet implemented.\n");
}


void close_results( GtkWidget *w,gpointer data)
{
 debug("%s:%d",__FILE__,__LINE__);
 gtk_main_quit();
 if (!data) return;
 gtk_widget_destroy((GtkWidget*)(data));
}


void qexec_quit( GtkWidget *w,gpointer data)
{
 debug("%s:%d",__FILE__,__LINE__);
 gtk_main_quit();
 gtk_widget_destroy(query_exec);
 query_exec = NULL;
}


int menu_quit(GtkWidget *w, gpointer data)
{
 debug("%s:%d",__FILE__,__LINE__);
  if (gtk_dialog_yes_no("Are you sure?"))
   {
    disconnect();
    if (currentbase) free(currentbase);
    currentbase=NULL;
    gtk_main_quit();
    if (query_exec)
       {
	qexec_quit(query_exec, NULL);
	exit(0);
       }
    return FALSE;
   }
 return TRUE;
}


void select_child_main_tree(GtkWidget* w, gpointer data)	/* s, d, c */
{
 debug("%s:%d",__FILE__,__LINE__);
 debug("select_child_main_tree\n");
 /*components.seltype = 0;
 strcpy(components.selected,"");*/
}

void select_tree(GtkWidget* w, gpointer data)		/* ts,td,te,tc,vs,vd,ve,vc,rs,rd,re,rc */
{							/* re - trigger expand, ts table select etc. */
 char* str;
 debug("%s:%d",__FILE__,__LINE__);
 debug("select_tree %s\n", (char*)data);
 str = (char*)data;
 switch (str[0])
 {
  case 't': components.seltype= 'T'; break;
  case 'v': components.seltype= 'V'; break;
  case 'r': components.seltype= 'R'; break;
 }
}


void select_child_tree(GtkWidget* w, gpointer data)	/* ts,td,vs,vd,rs,rd */
{
 debug("%s:%d",__FILE__,__LINE__);
 debug("select_child_tree %s\n",(char*)data);
}


int dispatch_cmenu(GtkWidget* w, GdkEvent* event)
{
 GdkEventButton* evb;
 /*debug("%s:%d", __FILE__,__LINE__);*/
 if (event->type == GDK_2BUTTON_PRESS || event->type == GDK_3BUTTON_PRESS)
 {
  evb = (GdkEventButton*)event;
  gtk_menu_popup(GTK_MENU(w), NULL,NULL,NULL,NULL, evb->button, evb->time);
  return TRUE;
 }
 return FALSE;
}


void select_final(GtkWidget* w, gpointer data)		/* ts,td,vs,vd,rs,rd */
{
 char* str;
 GtkItem* item;
 GtkWidget* label;
 GtkTreeItem* ti;
 char* name;
 debug("%s:%d",__FILE__,__LINE__);
 if (!data) { error("no data passed to select_final %s:%d", __FILE__,__LINE__); return ; }
 debug("select_final %s\n",(char*)data);	/*WHAT WAS HAPPEN IN STR[1] */
 str = (char*)data;
 ti = (GtkTreeItem*)(w);
 item = &(ti->item);
 label = GTK_WIDGET(GTK_BIN(item)->child);
 gtk_label_get(GTK_LABEL(label), &name);
 components.last_selected = w;
 switch (str[0])
 {
  case 't': components.seltype=str[0]; strcpy(components.selected, name); break;
  case 'v': components.seltype=str[0]; strcpy(components.selected, name); break;
  case 'r': components.seltype=str[0]; strcpy(components.selected, name); break;
 }
}


void construct_components()
{
 debug("%s:%d",__FILE__,__LINE__);
 components.table = NULL;
 components.scrolled_win = NULL;
 components.tree_item_tables = NULL;
 components.subtree_tables = NULL;
 components.tree_item_views = NULL;
 components.subtree_views = NULL;
 components.tree_item_triggers = NULL;
 components.subtree_triggers = NULL;
 components.tree = NULL;
 components.cmenu_tables=NULL;
 components.cmenu_table=NULL;
 components.cmenu_views=NULL;
 components.cmenu_view=NULL;
 components.cmenu_triggers=NULL;
 components.cmenu_trigger=NULL;
 components.table_view=NULL;
 components.ntables=components.nviews=components.ntriggers=0;
 strcpy(components.selected, "");
 components.seltype=0;
 components.rows = components.cols = -1;
 components.table_view = NULL;
 components.scroller_view = NULL;
 components.button_save = NULL;
 components.button_destroy = NULL;
 components.table_entry = NULL;
 components.data = NULL;
 components.last_selected = NULL;
 shred_memlist();
}


gpointer mkptr(char* str)
{
 debug("%s:%d",__FILE__,__LINE__);
 return (gpointer)(str);
}


void subtree_DB_triggers()
{
 char ***ptr;
 int row,col,i;
 char errstr[MAX_QUERY_LENGTH];
 GtkWidget* subtmp;
 debug("%s:%d",__FILE__,__LINE__);
 if (!want_all_elems)
 execute_printf(connection, &ptr, &row, &col, errstr, 0,
		 "SELECT tgname from pg_trigger WHERE tgname NOT LIKE 'pg_%%' ORDER BY tgname");
 else
 execute_printf(connection, &ptr, &row, &col, errstr, 0,
		 "SELECT tgname from pg_trigger ORDER BY tgname");
 if (ptr==0 || row<0 || col<0)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
 for (i=0;i<row;i++)
  {
   subtmp = gtk_tree_item_new_with_label(ptr[i][0]);
   gtk_signal_connect_object(GTK_OBJECT(subtmp), "event",      GTK_SIGNAL_FUNC(dispatch_cmenu), GTK_OBJECT(components.cmenu_trigger));
   gtk_signal_connect(GTK_OBJECT(subtmp), "select",     GTK_SIGNAL_FUNC(select_final), mkptr("rs"));
   gtk_signal_connect(GTK_OBJECT(subtmp), "deselect",   GTK_SIGNAL_FUNC(select_final), mkptr("rd"));
   gtk_tree_append(GTK_TREE(components.subtree_triggers), subtmp);
   gtk_widget_show(subtmp);
  }
 components.ntriggers=row;
 free_p3c(&ptr, row, col);
}


void subtree_DB_views()
{
 char ***ptr;
 int row,col,i;
 char errstr[MAX_QUERY_LENGTH];
 GtkWidget* subtmp;
 debug("%s:%d",__FILE__,__LINE__);
 if (!want_all_elems)
 execute_printf(connection, &ptr, &row, &col, errstr, 0,
		 "SELECT viewname from pg_views WHERE viewname NOT LIKE 'pg_%%' ORDER BY viewname");
 else
 execute_printf(connection, &ptr, &row, &col, errstr, 0,
		 "SELECT viewname from pg_views ORDER BY viewname");
 if (ptr==0 || row<0 || col<0)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
 for (i=0;i<row;i++)
  {
   subtmp = gtk_tree_item_new_with_label(ptr[i][0]);
   gtk_signal_connect_object(GTK_OBJECT(subtmp), "event",      GTK_SIGNAL_FUNC(dispatch_cmenu), GTK_OBJECT(components.cmenu_view));
   gtk_signal_connect(GTK_OBJECT(subtmp), "select",     GTK_SIGNAL_FUNC(select_final), mkptr("vs"));
   gtk_signal_connect(GTK_OBJECT(subtmp), "deselect",   GTK_SIGNAL_FUNC(select_final), mkptr("vd"));
   gtk_tree_append(GTK_TREE(components.subtree_views), subtmp);
   gtk_widget_show(subtmp);
  }
 components.nviews=row;
 free_p3c(&ptr, row, col);
}


void subtree_DB_tables()
{
 char ***ptr;
 int row,col,i;
 char errstr[MAX_QUERY_LENGTH];
 GtkWidget* subtmp;
 debug("%s:%d",__FILE__,__LINE__);
 if (!want_all_elems)
 execute_printf(connection, &ptr, &row, &col, errstr, 0,
		 "SELECT tablename from pg_tables WHERE tablename NOT LIKE 'pg_%%' AND tablename NOT LIKE 'sql_%%' ORDER BY tablename");
 else
 execute_printf(connection, &ptr, &row, &col, errstr, 0,
		 "SELECT tablename from pg_tables ORDER BY tablename");
 if (ptr==0 || row<0 || col<0)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
 for (i=0;i<row;i++)
  {
   subtmp = gtk_tree_item_new_with_label(ptr[i][0]);
   gtk_signal_connect_object(GTK_OBJECT(subtmp), "event",      GTK_SIGNAL_FUNC(dispatch_cmenu), GTK_OBJECT(components.cmenu_table));
   gtk_signal_connect(GTK_OBJECT(subtmp), "select",     GTK_SIGNAL_FUNC(select_final), mkptr("ts"));
   gtk_signal_connect(GTK_OBJECT(subtmp), "deselect",   GTK_SIGNAL_FUNC(select_final), mkptr("td"));
   gtk_tree_append(GTK_TREE(components.subtree_tables), subtmp);
   gtk_widget_show(subtmp);
  }
 components.ntables=row;
 free_p3c(&ptr, row, col);
}


void refresh_all()
{
 char basen[STDSTRING];
 char errstr[MAX_QUERY_LENGTH+100];
 char winname[STDSTRING];
 strcpy(basen, currentbase);
 disconnect();
 shred_memlist();
 if (currentbase) free(currentbase);
 currentbase=NULL;
 connection = gtk_connect_db(basen, errstr);
 if (!connection)
     {
      fatal_nodb(basen,errstr,0);
      return ;
     }
 else
     {
      connected=1;
      currentbase = (char*)malloc(strlen(basen)+2);
      strcpy(currentbase, basen);
      sprintf(winname, "PgXexplorer: %s", currentbase);
      gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
      setup_components();
     }
}


void cmenu_response(GtkWidget* w, gpointer data)
{
 debug("%s:%d",__FILE__,__LINE__);	/* ON SELTYPE t one of tables, T All tables (node in tree) */
 					/* analogically v,V,r,R <view,views,trigger,triggers> */
 debug("CMENU: %c %s\n", components.seltype, components.selected);
}


void destruct_tab_view(GtkWidget* w, gpointer data)
{
 int i,rows,cols,j;
 debug("%s:%d",__FILE__,__LINE__);
 if (components.button_save) gtk_widget_destroy(components.button_save);
 components.button_save = NULL;
 if (components.button_destroy) gtk_widget_destroy(components.button_destroy);
 components.button_destroy = NULL;
 rows = components.rows;
 cols = components.cols;
 components.last_selected = NULL;
 if (components.table_view) gtk_widget_destroy(components.table_view);
 components.table_view = NULL;
 if (components.rows && components.cols)
    {
     mfree_p3c(&components.data, components.rows, components.cols);
     components.data = NULL;
     for (i=0;i<rows;i++) for (j=0;j<cols;j++)
       {
	if (components.table_entry[i][j]) gtk_widget_destroy(components.table_entry[i][j]);
	components.table_entry[i][j] = NULL;
       }
     for (i=0;i<rows;i++) if (components.table_entry[i]) { free(components.table_entry[i]); components.table_entry[i] = NULL; }
     if (components.table_entry) { free(components.table_entry); components.table_entry = NULL; }
    }
 components.data = NULL;
 components.table_entry = NULL;
 components.rows = -1;
 components.cols = -1;
 if (components.scroller_view) gtk_widget_destroy(components.scroller_view);
 components.scroller_view = NULL;
 shred_memlist();
}


void drop_table(char* tabname)
{
 char*** ptr;
 int row,col;
 char errstr[MAX_QUERY_LENGTH+100];
 debug("%s:%d",__FILE__,__LINE__);
 execute_printf(connection, &ptr, &row, &col, errstr, 1, "DROP TABLE %s", tabname);
 if (row<0 || col<0)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
 /*gtk_tree_remove_item(components.tree_item_tables, components.last_selected);*/
 refresh_all();						/* FIXME hardcore!!! */
 gtk_dialog_printf("Table %s dropped", tabname);
}


void browse_table(char* tabname)
{
 char*** ptr;
 int row,col;
 char errstr[MAX_QUERY_LENGTH+100];
 struct result_cache res_cache;
 int i,j;
 debug("%s:%d",__FILE__,__LINE__);
 if (!connection) error("no_connection %s:%d", __FILE__,__LINE__);
 mexecute_printf(connection, &ptr, &row, &col, errstr, 1, "SELECT * FROM %s", tabname);
 if (row<0 || col<0)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
 res_cache.cols = col;
 res_cache.rows = row;
 components.table_entry = (GtkWidget***)malloc(row*sizeof(GtkWidget**));
 for (i=0;i<row;i++) components.table_entry[i] = (GtkWidget**)malloc(col*sizeof(GtkWidget*));
 components.cols = col;
 components.rows = row;
 components.data = ptr;
 if (col>32 || row>512)
   {
    gtk_dialog_printf("Result is too big, rows=%d, columns=%d\nwill be truncated!", row, col);
    if (row>512) col = (col>12 )?11 :col;
    else if (row>256)  col = (col>24 )?24 :col;
    else if (row>128)  col = (col>48 )?48 :col;
    else             col = (col>64)?64:col;
    row = (row>512)?512:row;
    col = (col>512)?512:col;
   }
 debug("row=%d, col=%d\n",row,col);
 components.table_view = gtk_table_new(row, col, FALSE);
 res_cache.data = components.data;
 for (i=0;i<row;i++)
 for (j=0;j<col;j++) components.table_entry[i][j] = NULL;
 create_pbar("Wait while filling table...");
 for (i=0;i<row;i++)
 for (j=0;j<col;j++)
   {
    components.table_entry[i][j] = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(components.table_entry[i][j]), ptr[i][j]);
    gtk_entry_set_editable(GTK_ENTRY(components.table_entry[i][j]), FALSE);
    gtk_table_attach (GTK_TABLE (components.table_view), components.table_entry[i][j], j, j+1, i, i+1,GTK_FILL,GTK_FILL, 0, 0);
    gtk_widget_show(components.table_entry[i][j]);
    if (!cont) { gtk_dialog_printf("Interrupted!"); goto out_loop; }
   }
 out_loop:
 gtk_widget_show (components.table_view);
 destroy_pbar();
 components.scroller_view = gtk_scrolled_window_new(NULL,NULL);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(components.scroller_view), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(components.scroller_view), components.table_view);
 gtk_container_set_border_width(GTK_CONTAINER(components.scroller_view), 2);
 /*gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(close_results), (gpointer)(window));*/
 gtk_widget_show(components.scroller_view);
 gtk_table_attach(GTK_TABLE(components.table), components.scroller_view, 20, 80, 0, 77, 	/* CAN BE CHANGED */
		 GTK_FILL|GTK_EXPAND,GTK_FILL|GTK_EXPAND, 0, 0);
 components.button_destroy = gtk_button_new_with_label("Destroy");
 gtk_signal_connect(GTK_OBJECT(components.button_destroy),"clicked", GTK_SIGNAL_FUNC(destruct_tab_view), NULL);
 gtk_table_attach (GTK_TABLE(components.table), components.button_destroy, 20, 50, 78, 80,GTK_FILL|GTK_SHRINK,GTK_FILL|GTK_SHRINK, 0, 0);
 gtk_widget_show(components.button_destroy);
 components.button_save = gtk_button_new_with_label("Save");
 gtk_signal_connect(GTK_OBJECT(components.button_save),"clicked", GTK_SIGNAL_FUNC(save_results_mainwnd),  NULL);
 gtk_table_attach (GTK_TABLE (components.table), components.button_save, 50, 80, 78, 80,GTK_FILL|GTK_SHRINK,GTK_FILL|GTK_SHRINK, 0, 0);
 gtk_widget_show(components.button_save);
}


void cmenu_browse(GtkWidget* w, gpointer data)
{
 debug("%s:%d",__FILE__,__LINE__);	/* ON SELTYPE t one of tables, T All tables (node in tree) */
 					/* analogically v,V,r,R <view,views,trigger,triggers> */
 if (components.seltype=='t')
 {
  destruct_tab_view(NULL,NULL);
  browse_table(components.selected);
 }
 else gtk_dialog_printf("Not yet implemented!");
}


void cmenu_drop(GtkWidget* w, gpointer data)
{
 debug("%s:%d",__FILE__,__LINE__);
 if (components.seltype=='t')
 {
  destruct_tab_view(NULL,NULL);
  drop_table(components.selected);
 }
 else gtk_dialog_printf("Not yet implemented!");
}


void create_context_menus()
{
 GtkWidget* menu_item;
 debug("%s:%d",__FILE__,__LINE__);
 /* TABLE */
 components.cmenu_table = gtk_menu_new();
 menu_item = gtk_menu_item_new_with_label("Browse table");
 gtk_menu_append(GTK_MENU(components.cmenu_table), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_browse), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("Drop this table");
 gtk_menu_append(GTK_MENU(components.cmenu_table), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_drop), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("Browse Entire DB");
 gtk_menu_append(GTK_MENU(components.cmenu_table), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_browse_all), NULL);
 gtk_widget_show(menu_item);
 /* TABLE ENDS */
 /* TABLES */
 components.cmenu_tables = gtk_menu_new();
 menu_item = gtk_menu_item_new_with_label("Browse entire DB");
 gtk_menu_append(GTK_MENU(components.cmenu_tables), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_browse_all), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("Drop all tables");
 gtk_menu_append(GTK_MENU(components.cmenu_tables), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_drop), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("For tables");
 gtk_menu_append(GTK_MENU(components.cmenu_tables), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_response), NULL);
 gtk_widget_show(menu_item);
 /* TABLE ENDS */
 /* VIEW */
 components.cmenu_view = gtk_menu_new();
 menu_item = gtk_menu_item_new_with_label("Browse View");
 gtk_menu_append(GTK_MENU(components.cmenu_view), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_browse), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("Drop this view");
 gtk_menu_append(GTK_MENU(components.cmenu_view), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_drop), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("Browse Entire DB");
 gtk_menu_append(GTK_MENU(components.cmenu_view), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_browse_all), mkptr("bla"));
 gtk_widget_show(menu_item);
 /* VIEW ENDS */
 /* VIEWS */
 components.cmenu_views = gtk_menu_new();
 menu_item = gtk_menu_item_new_with_label("Testing Context menu");
 gtk_menu_append(GTK_MENU(components.cmenu_views), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_response), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("Drop all views");
 gtk_menu_append(GTK_MENU(components.cmenu_views), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_drop), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("Browse Entire DB");
 gtk_menu_append(GTK_MENU(components.cmenu_views), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_browse_all), mkptr("bla"));
 gtk_widget_show(menu_item);
 /* VIEWS ENDS */
 /* TRIGGER */
 components.cmenu_trigger = gtk_menu_new();
 menu_item = gtk_menu_item_new_with_label("Browse trigger");
 gtk_menu_append(GTK_MENU(components.cmenu_trigger), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_browse), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("Delete this trigger");
 gtk_menu_append(GTK_MENU(components.cmenu_trigger), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_drop), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("Browse Entire DB");
 gtk_menu_append(GTK_MENU(components.cmenu_trigger), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_browse_all), mkptr("bla"));
 gtk_widget_show(menu_item);
 /* TRIGGER ENDS */
 /* TRIGGERSS */
 components.cmenu_triggers = gtk_menu_new();
 menu_item = gtk_menu_item_new_with_label("Testing Context menu");
 gtk_menu_append(GTK_MENU(components.cmenu_triggers), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_response), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("Delete all trigers");
 gtk_menu_append(GTK_MENU(components.cmenu_triggers), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_drop), NULL);
 gtk_widget_show(menu_item);
 menu_item = gtk_menu_item_new_with_label("Browse Entire DB");
 gtk_menu_append(GTK_MENU(components.cmenu_triggers), menu_item);
 gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(cmenu_browse_all), mkptr("bla"));
 gtk_widget_show(menu_item);
 /* TRIGGERS ENDS */
}


void destroy_all_components()		/* FIXME SOMEWHERE GTKWIDGET IS ALREADY FREED?? */
{
 debug("%s:%d",__FILE__,__LINE__);
 destruct_tab_view(NULL,NULL);
 components.seltype=0;
 strcpy(components.selected,"");
 if (components.scrolled_win) gtk_widget_destroy(components.scrolled_win);
 components.scrolled_win = NULL;
 if (components.table) gtk_widget_destroy(components.table);
 components.table = NULL;
 if (components.table_view) gtk_widget_destroy(components.table_view);
 components.table_view = NULL;
 if (components.tree) gtk_widget_destroy(components.tree);
 components.tree = NULL;
 if (components.subtree_tables) gtk_widget_destroy(components.subtree_tables);
 components.subtree_tables = NULL;
 if (components.tree_item_tables) gtk_widget_destroy(components.tree_item_tables);
 components.tree_item_tables = NULL;
 if (components.subtree_views) gtk_widget_destroy(components.subtree_views);
 components.subtree_views = NULL;
 if (components.tree_item_views) gtk_widget_destroy(components.tree_item_views);
 components.tree_item_views = NULL;
 if (components.subtree_triggers) gtk_widget_destroy(components.subtree_triggers);
 components.subtree_triggers = NULL;
 if (components.tree_item_triggers) gtk_widget_destroy(components.tree_item_triggers);
 components.tree_item_triggers = NULL;
 if (components.cmenu_table) gtk_widget_destroy(components.cmenu_table);
 components.cmenu_table = NULL;
 if (components.cmenu_tables) gtk_widget_destroy(components.cmenu_tables);
 components.cmenu_tables = NULL;
 if (components.cmenu_view) gtk_widget_destroy(components.cmenu_view);
 components.cmenu_view = NULL;
 if (components.cmenu_views) gtk_widget_destroy(components.cmenu_views);
 components.cmenu_views = NULL;
 if (components.cmenu_trigger) gtk_widget_destroy(components.cmenu_trigger);
 components.cmenu_trigger = NULL;
 if (components.cmenu_triggers) gtk_widget_destroy(components.cmenu_triggers);
 components.cmenu_triggers = NULL;
 components.button_save = components.button_destroy = NULL;
}


void setup_components()
{
 debug("%s:%d",__FILE__,__LINE__);
 if (!connection) return;
 destroy_all_components();
 components.table = gtk_table_new(80,80,FALSE);
 components.scrolled_win = gtk_scrolled_window_new(NULL,NULL);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(components.scrolled_win),
		 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 gtk_widget_set_usize(components.scrolled_win, 160,540);
 create_context_menus();
 components.tree = gtk_tree_new();
 gtk_signal_connect(GTK_OBJECT(components.tree), "select_child",           GTK_SIGNAL_FUNC(select_child_main_tree), mkptr("s"));
 gtk_signal_connect(GTK_OBJECT(components.tree), "unselect_child",         GTK_SIGNAL_FUNC(select_child_main_tree), mkptr("d"));
 gtk_signal_connect(GTK_OBJECT(components.tree), "selection_changed",      GTK_SIGNAL_FUNC(select_child_main_tree), mkptr("c"));
 gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(components.scrolled_win), components.tree);
 gtk_tree_set_selection_mode(GTK_TREE(components.tree), GTK_SELECTION_SINGLE);
 gtk_widget_show(components.tree);
 /* TABLES */
 components.tree_item_tables = gtk_tree_item_new_with_label("Tables");
 gtk_signal_connect_object(GTK_OBJECT(components.tree_item_tables), "event",GTK_SIGNAL_FUNC(dispatch_cmenu), GTK_OBJECT(components.cmenu_tables));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_tables), "select",   GTK_SIGNAL_FUNC(select_tree), mkptr("ts"));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_tables), "deselect", GTK_SIGNAL_FUNC(select_tree), mkptr("td"));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_tables), "expand",   GTK_SIGNAL_FUNC(select_tree), mkptr("te"));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_tables), "collapse", GTK_SIGNAL_FUNC(select_tree), mkptr("tc"));
 gtk_tree_append(GTK_TREE(components.tree), components.tree_item_tables);
 gtk_widget_show(components.tree_item_tables);
 components.subtree_tables = gtk_tree_new();
 gtk_signal_connect(GTK_OBJECT(components.subtree_tables), "select_child",   GTK_SIGNAL_FUNC(select_child_tree), mkptr("ts"));
 gtk_signal_connect(GTK_OBJECT(components.subtree_tables), "unselect_child", GTK_SIGNAL_FUNC(select_child_tree), mkptr("td"));
 gtk_tree_set_selection_mode(GTK_TREE(components.subtree_tables), GTK_SELECTION_SINGLE);
 gtk_tree_set_view_mode(GTK_TREE(components.subtree_tables), GTK_TREE_VIEW_ITEM);
 /*gtk_tree_item_collapse(GTK_TREE_ITEM(components.tree_item_tables));*/
 subtree_DB_tables();
 gtk_tree_item_set_subtree(GTK_TREE_ITEM(components.tree_item_tables), components.subtree_tables);
 gtk_widget_show(components.subtree_tables);
 /* TABLES ENDS */
 /* VIEWS */
 components.tree_item_views = gtk_tree_item_new_with_label("Views");
 gtk_signal_connect_object(GTK_OBJECT(components.tree_item_views), "event",GTK_SIGNAL_FUNC(dispatch_cmenu), GTK_OBJECT(components.cmenu_views));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_views), "select",   GTK_SIGNAL_FUNC(select_tree), mkptr("vs"));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_views), "deselect", GTK_SIGNAL_FUNC(select_tree), mkptr("vd"));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_views), "expand",   GTK_SIGNAL_FUNC(select_tree), mkptr("ve"));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_views), "collapse", GTK_SIGNAL_FUNC(select_tree), mkptr("vc"));
 gtk_tree_append(GTK_TREE(components.tree), components.tree_item_views);
 gtk_widget_show(components.tree_item_views);
 components.subtree_views = gtk_tree_new();
 gtk_signal_connect(GTK_OBJECT(components.subtree_views), "select_child",   GTK_SIGNAL_FUNC(select_child_tree), mkptr("vs"));
 gtk_signal_connect(GTK_OBJECT(components.subtree_views), "unselect_child", GTK_SIGNAL_FUNC(select_child_tree), mkptr("vd"));
 gtk_tree_set_selection_mode(GTK_TREE(components.subtree_views), GTK_SELECTION_SINGLE);
 gtk_tree_set_view_mode(GTK_TREE(components.subtree_views), GTK_TREE_VIEW_ITEM);
 subtree_DB_views();
 gtk_tree_item_set_subtree(GTK_TREE_ITEM(components.tree_item_views), components.subtree_views);
 gtk_widget_show(components.subtree_views);
 /* VIEWS ENDS */
 /* TRIGGERS */
 components.tree_item_triggers = gtk_tree_item_new_with_label("Triggers");
 gtk_signal_connect_object(GTK_OBJECT(components.tree_item_triggers), "event",GTK_SIGNAL_FUNC(dispatch_cmenu), GTK_OBJECT(components.cmenu_triggers));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_triggers), "select",   GTK_SIGNAL_FUNC(select_tree), mkptr("rs"));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_triggers), "deselect", GTK_SIGNAL_FUNC(select_tree), mkptr("rd"));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_triggers), "expand",   GTK_SIGNAL_FUNC(select_tree), mkptr("re"));
 gtk_signal_connect(GTK_OBJECT(components.tree_item_triggers), "collapse", GTK_SIGNAL_FUNC(select_tree), mkptr("rc"));
 gtk_tree_append(GTK_TREE(components.tree), components.tree_item_triggers);
 gtk_widget_show(components.tree_item_triggers);
 components.subtree_triggers = gtk_tree_new();
 gtk_signal_connect(GTK_OBJECT(components.subtree_triggers), "select_child",   GTK_SIGNAL_FUNC(select_child_tree), mkptr("rs"));
 gtk_signal_connect(GTK_OBJECT(components.subtree_triggers), "unselect_child", GTK_SIGNAL_FUNC(select_child_tree), mkptr("rd"));
 gtk_tree_set_selection_mode(GTK_TREE(components.subtree_triggers), GTK_SELECTION_SINGLE);
 gtk_tree_set_view_mode(GTK_TREE(components.subtree_triggers), GTK_TREE_VIEW_ITEM);
 subtree_DB_triggers();
 gtk_tree_item_set_subtree(GTK_TREE_ITEM(components.tree_item_triggers), components.subtree_triggers);
 gtk_widget_show(components.subtree_triggers);
 /* TRIGGERS ENDS */
 gtk_table_attach(GTK_TABLE(components.table), components.scrolled_win, 0, 20, 0, 80, 	/* CAN BE CHANGED */
		 GTK_FILL,GTK_FILL|GTK_EXPAND, 0, 0);
 gtk_widget_show(components.scrolled_win);
 gtk_box_pack_start (GTK_BOX (main_vbox), components.table, TRUE, TRUE, 0);
 gtk_widget_show(components.table);
}


void about_box( GtkWidget *w,gpointer   data)
{
 debug("%s:%d",__FILE__,__LINE__);
 about_window_new();
}


void copy_database(GtkWidget* w, gpointer data)
{
 int emerg;
 char *dbname, dbs[MAXPATH];
 char errstr[MAX_QUERY_LENGTH];
 char db2[MAXPATH];
 char winname[STDSTRING];
 char*** ptr;
 int row,col;
 debug("%s:%d",__FILE__,__LINE__);
 emerg = !connected;
 if (!connected && !dummy_connect(1,TEMPLATE))
    {
     gtk_dialog_printf("Cannot connect to template DB\nCannot get DB list.");
     return ;
    }
 dbname = gtk_dialog_getdbs(connection, "Which DB copy?");
 if (emerg) { dummy_connect(0,TEMPLATE); connected=0; }
 strcpy(dbs, dbname);
 dbname = gtk_dialog_gettext_printf("Copy %s to:", dbs);
 strcpy(db2, dbname);
 if (!strcmp(db2,""))
      {
	gtk_dialog_printf("Cannot save %s to empty name.\n", dbs);
        return;
      }
 emerg = !connected;
 if (!connected && !dummy_connect(1,TEMPLATE))
   {
    gtk_dialog_printf("Cannot connect to template DB\nResult: Cannot create new DB");
    return ;
   }
 execute_printf(connection, &ptr, &row, &col, errstr, 0, "CREATE DATABASE %s", db2);
 if (emerg) { dummy_connect(0,TEMPLATE); connected = 0; }
 if (row<0 || col<0)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
 free_p3c(&ptr, row, col);
 system_printf("pg_dump -i %s | psql %s", dbs,db2);
 if (!emerg) return;
 connection = gtk_connect_db(db2, errstr);
 if (!connection)
     {
      fatal_nodb(db2,errstr,0);
      return ;
     }
 else
     {
      connected=1;
      currentbase = (char*)malloc(strlen(db2)+2);
      strcpy(currentbase, db2);
      sprintf(winname, "PgXexplorer: %s", currentbase);
      gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
      setup_components();
     }
}


void create_DB_from_file(GtkWidget* w, gpointer data)
{
 char *filen,*dbn;
 char errstr[MAX_QUERY_LENGTH];
 char dbname[MAXPATH];
 FILE* f;
 char*** ptr;
 int l,row,col,emerg;
 char winname[STDSTRING];
 debug("%s:%d",__FILE__,__LINE__);
 dbn = gtk_dialog_gettext_printf("Need DB name to fill from a SQL file:");
 if (!strcmp(dbn,""))
    {
     gtk_dialog_printf("Will not create empty name DB\nTry once again.");
     return;
    }
 strcpy(dbname,dbn);
 /*if (!strcmp(dbname,""))
   {
    gtk_dialog_printf("Cannot save DB to non-SQL file\n");
    return;
   }*/
 filen = gtk_dialog_getfile(".SQL", "Select SQL dump file (*.SQL)");
 if (!strcmp(filen,""))
   {
    gtk_dialog_printf("Cannot load DB from non-SQL file\n");
    return;
   }
 f = fopen(filen, "r");
 if (!f)
   {
    gtk_dialog_printf("Cannot read from\n%s", filen);
    return ;
   }
 fclose(f);
 emerg = !connected;
 if (!connected && !dummy_connect(1,TEMPLATE))
   {
    gtk_dialog_printf("Cannot connect to template DB\nResult: Cannot create new DB");
    return ;
   }
 execute_printf(connection, &ptr, &row, &col, errstr, 0, "CREATE DATABASE %s", dbname);
 if (emerg) { dummy_connect(0,TEMPLATE); connected = 0; }
 if (row<0 || col<0)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
 free_p3c(&ptr, row, col);
 system_printf("psql %s -f %s", dbname, filen);
 if (!connected) l = 1;
 else l = gtk_dialog_yes_no_printf("Switch from database\n%s to %s now?", currentbase, dbname);
 if (l)
  {
   if (!emerg)
     {
      disconnect();
      if (currentbase) free(currentbase);
      currentbase=NULL;
      sprintf(winname, "PgXexplorer: (no database opened currently)");
      gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
     }
   connection = gtk_connect_db(dbname, errstr);
   if (!connection)
     {
      fatal_nodb(dbname,errstr,0);
      return ;
     }
   else
     {
      connected=1;
      currentbase = (char*)malloc(strlen(dbname)+2);
      strcpy(currentbase, dbname);
      sprintf(winname, "PgXexplorer: %s", currentbase);
      gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
      setup_components();
     }
  }
}


void save_database(GtkWidget* w, gpointer data)
{
 int a;
 char* filename;
 char* dbname;
 char dbs[STDSTRING];
 int emerg;
 debug("%s:%d",__FILE__,__LINE__);
 if (!connected) a=0;
 else
 a = gtk_dialog_with_2_buttons("Do You want to save Current database or Other database?", "Current", "Other");
 if (a)
   {
    /*filename = gtk_dialog_gettext_printf("Enter filename, %s will be saved to:\n(extension .SQL will be added automatically)", currentbase);*/
    filename = gtk_dialog_getfile_printf(".SQL", "Enter filename, %s will be saved to", currentbase);
    if (!strcmp(filename,""))
      {
	gtk_dialog_printf("Cannot save %s to non-SQL file", currentbase);
        return;
      }
    system_printf("pg_dump -i '%s' > '%s'", currentbase, filename);
   }
 else
 {
  emerg = !connected;
  if (!connected && !dummy_connect(1,TEMPLATE))
    {
     gtk_dialog_printf("Cannot connect to template DB\nCannot get DB list.");
     return ;
    }
  dbname = gtk_dialog_getdbs(connection, "Which DB save?");
  if (emerg) { dummy_connect(0,TEMPLATE); connected=0; }
  strcpy(dbs, dbname);  /* HEADERS WILL USE OLD POINTER IN DIALOGS, SO MUST COPY IT */
  			/* NOW VARIABLE dbs IS A COPY, AND dbname CAN (NOT MUST) */
  			/* BE CHANGED BY DIALOGS */
  filename = gtk_dialog_getfile_printf(".SQL", "Enter filename, %s will be saved to",dbs);
  if (!strcmp(filename,""))
      {
	gtk_dialog_printf("Cannot save %s to non-SQL file\n", dbs);
        return;
      }
  system_printf("pg_dump -i '%s' > '%s'", dbs, filename);
 }
}

char* get_env(char*);

char *dbenv()
{
 debug("%s:%d",__FILE__,__LINE__);
 sprintf(tmpstr,"PGDATA=\"%s\"\nPGPORT=\"%s\"\nPGHOST=\"%s\"", get_env("PGDATA"), get_env("PGPORT"), get_env("PGHOST"));
 return tmpstr;
}


void fatal_nodb(char* dbname, char* errstr, int killed)
{
 debug("%s:%d",__FILE__,__LINE__);
 if (killed)
 gtk_dialog_printf_big_with_title("PgXexplorer Fatal Error",
 	"Cannot connect to DB: %s\nDBMS returned: \n%s\nSystem will now exit.\nENV=\n%s",
  	dbname,errstr,dbenv());
 else
 gtk_dialog_printf_big_with_title("PgXexplorer Error",
 	"Cannot connect to DB: %s\nDBMS returned: \n%s\nENV=\n%s",
  	dbname,errstr,dbenv());
 if(killed) exit(1);
}


void reload_bases(char* db, int ask)
{
 int a;
 char errstr[MAX_QUERY_LENGTH];
 char winname[STDSTRING];
 char dbname[STDSTRING];
 debug("%s:%d",__FILE__,__LINE__);
 strcpy(dbname,db);
 if (!strcmp(dbname,""))
   {
    gtk_dialog_printf("Cannot switch to an empty DB");
    return ;
   }
 if (ask) a = gtk_dialog_yes_no_printf("Switch to database \"%s\" now?", db);
 else a=1;
 /**/
 if (!a) return;
 disconnect();
 if (currentbase) free(currentbase);
 currentbase=NULL;
 /*while (!strcmp(dbname,""))
   {
    gtk_dialog_printf("Cannot switch to an empty DB");
    strcpy(dbname, gtk_dialog_gettext("Null DB name cannot be accepted\nEnter database name: "));
   }*/
 sprintf(winname, "PgXexplorer: (no database opened currently)");
 gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
 connection = gtk_connect_db(dbname, errstr);
 if (!connection)
   {
    fatal_nodb(dbname,errstr,0);
    return ;
   }
 else
   {
    connected=1;
    currentbase = (char*)malloc(strlen(dbname)+2);
    strcpy(currentbase, dbname);
    sprintf(winname, "PgXexplorer: %s", currentbase);
    gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
    setup_components();
   }
}


void load_database(GtkWidget* w, gpointer data)
{
 char* dbname;
 char winname[STDSTRING];
 char errstr[MAX_QUERY_LENGTH];
 int emerg;
 debug("%s:%d",__FILE__,__LINE__);
 emerg = !connected;
 if (!connected && !dummy_connect(1,TEMPLATE))
   {
    gtk_dialog_printf("Cannot connect to template DB\nServer is dead?");
    return;
   }
 dbname = gtk_dialog_getdbs(connection, "Which DB load?");
 if (emerg) { dummy_connect(0,TEMPLATE); connected = 0; }
 if (!strcmp(dbname,""))
    {
     gtk_dialog_printf("Will not load empty DB name");
     return;
    }
 if (!emerg && connected && !strcmp(dbname,currentbase))
    {
     gtk_dialog_printf("This DB: %s, You are currently using", currentbase);
     return ;
    }
 if (!emerg)
   {
    disconnect();
    if (currentbase) free(currentbase);
    currentbase=NULL;
    sprintf(winname, "PgXexplorer: (no database opened currently)");
    gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
   }
 connection = gtk_connect_db(dbname, errstr);
 if (!connection)
     {
      fatal_nodb(dbname,errstr,0);
      return ;
     }
   else
     {
      connected=1;
      currentbase = (char*)malloc(strlen(dbname)+2);
      strcpy(currentbase, dbname);
      sprintf(winname, "PgXexplorer: %s", currentbase);
      gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
      setup_components();
     }
}


void drop_database(GtkWidget* w, gpointer data)
{
 char* dbname;
 char errstr[MAX_QUERY_LENGTH];
 PGresult *result;
 int emerg;
 debug("%s:%d",__FILE__,__LINE__);
 emerg = !connection;
 if (!connected && !dummy_connect(1,TEMPLATE))
   {
     gtk_dialog_printf("Cannot connect to template DB\nCannot get DB list");
     return;
   }
 dbname = gtk_dialog_getdbs(connection, "Which DB drop?");
 if (!strcmp(dbname,""))
    {
     gtk_dialog_printf("Will not drop empty DB name\nTry once again.");
     if (emerg) { dummy_connect(0,TEMPLATE); connected = 0; }
     return;
    }
 if (!emerg && connected && !strcmp(dbname,currentbase))
    {
     gtk_dialog_printf("Cannot drop DB: %s, currently used!", currentbase);
     return ;
    }
 if (strstr(dbname, "template"))
   {
    if (emerg)
      {
       dummy_connect(0,TEMPLATE);
       connected = 0;
       gtk_dialog_printf("Cannot drop template\nwhile it is beeing used\nas emergency DB!");
       return ;
      }
    if (!gtk_dialog_yes_no_printf(
    "Are You sure want to drop\ntemplate DB: %s\nThis can prevent PgXexplorer working properly",dbname))
	    return ;
   }
 execute_printf_query(connection, &result, errstr,  "DROP DATABASE %s", dbname);
 if (emerg) { dummy_connect(0,TEMPLATE); connected = 0; }
 if (!result)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
}


void create_database(GtkWidget* w, gpointer data)
{
 char* dbname;
 char errstr[MAX_QUERY_LENGTH];
 char winname[STDSTRING];
 int a;
 int emerg;
 PGresult *result;
 debug("%s:%d",__FILE__,__LINE__);
 emerg=!connected;
 dbname = gtk_dialog_gettext("Enter database name: ");
 if (!strcmp(dbname,""))
    {
     gtk_dialog_printf("Will not create empty name DB\nTry once again.");
     return;
    }
 result = NULL;
 if (!connected && !dummy_connect(1,TEMPLATE))
   {
    gtk_dialog_printf("Cannot connect to template DB\nResult: Cannot create new DB");
    return ;
   }
 execute_printf_query(connection, &result, errstr,  "CREATE DATABASE %s", dbname);
 if (emerg) { dummy_connect(0,TEMPLATE); connected = 0; }
 if (!result)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
 if (!connected) a = 1;
 else a = gtk_dialog_yes_no_printf("Switch from database\n%s to %s now?", currentbase, dbname);
 if (a)
  {
   if (!emerg)
     {
      disconnect();
      if (currentbase) free(currentbase);
      currentbase=NULL;
      sprintf(winname, "PgXexplorer: (no database opened currently)");
      gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
     }
   connection = gtk_connect_db(dbname, errstr);
   if (!connection)
     {
      fatal_nodb(dbname,errstr,0);
      return ;
     }
   else
     {
      connected=1;
      currentbase = (char*)malloc(strlen(dbname)+2);
      strcpy(currentbase, dbname);
      sprintf(winname, "PgXexplorer: %s", currentbase);
      gtk_window_set_title (GTK_WINDOW(main_wnd), winname);
      setup_components();
     }
  }
}


void exec_test_prog(GtkWidget* w, gpointer data)
{
 debug("%s:%d",__FILE__,__LINE__);
 system("./pgxtest");
}


void save_results_mainwnd(GtkWidget* w, gpointer d)
{
 char ***data, *filen;
 int a,i,j,rows,cols;
 FILE* f;
 int want_meta;
 int start;
 debug("%s:%d",__FILE__,__LINE__);
 data = components.data;
 rows = components.rows;
 cols = components.cols;
 filen = gtk_dialog_getfile(".HTML", "Save Results to: (*.HTML)");
 if (!strcmp(filen,""))
   {
    gtk_dialog_printf("Cannot save results to non-HTML file\n");
    return;
   }
 f = fopen(filen,"r");
 if (f)
   {
    fclose(f);
    a = gtk_dialog_yes_no_printf("Already exists:\n%s\nOverwrite?", filen);
    if (!a) return;
   }
 f = fopen(filen,"w");
 if (!f)
   {
    gtk_dialog_printf("Cannot write to %s", filen);
    return;
   }
 start=0;
 want_meta = gtk_dialog_yes_no_printf("Do You want to save table names?");
 if (!want_meta) start=1;
 fprintf(f,"<HTML>\n");
 fprintf(f,"<TITLE>\n");
 fprintf(f,"Results\n");
 fprintf(f,"</TITLE>\n");
 fprintf(f,"<HEAD>\n");
 fprintf(f,"</HEAD>\n");
 fprintf(f,"<BODY>\n");
 fprintf(f,"<TABLE BORDER=\"3\">\n");
 for (i=start;i<rows;i++)
   {
    fprintf(f,"<TR>\n");
    for (j=0;j<cols;j++) fprintf(f,"<TD>%s</TD>\n", data[i][j]);
   }
 fprintf(f,"</BODY>\n");
 fprintf(f,"</HTML>\n");
 fclose(f);
}


void save_results(GtkWidget* w, gpointer resd)
{
 char ***data, *filen;
 struct result_cache* resc;
 int rows,cols,a,i,j;
 FILE* f;
 debug("%s:%d",__FILE__,__LINE__);
 if (!resd) { error("resd points NULL %s:%d",__FILE__,__LINE__); return; }
 resc = resd;
 data = resc->data;
 rows = resc->rows;
 cols = resc->cols;
 filen = gtk_dialog_getfile(".HTML", "Save Results to: (*.HTML)");
 if (!strcmp(filen,""))
   {
    gtk_dialog_printf("Cannot save results to non-HTML file\n");
    return;
   }
 f = fopen(filen,"r");
 if (f)
   {
    fclose(f);
    a = gtk_dialog_yes_no_printf("Already exists:\n%s\nOverwrite?", filen);
    if (!a) return;
   }
 f = fopen(filen,"w");
 if (!f)
   {
    gtk_dialog_printf("Cannot write to %s", filen);
    return;
   }
 fprintf(f,"<HTML>\n");
 fprintf(f,"<TITLE>\n");
 fprintf(f,"Results\n");
 fprintf(f,"</TITLE>\n");
 fprintf(f,"<HEAD>\n");
 fprintf(f,"</HEAD>\n");
 fprintf(f,"<BODY>\n");
 fprintf(f,"<TABLE BORDER=\"3\">\n");
 for (i=0;i<rows;i++)
   {
    fprintf(f,"<TR>\n");
    for (j=0;j<cols;j++) fprintf(f,"<TD>%s</TD>\n", data[i][j]);
   }
 fprintf(f,"</BODY>\n");
 fprintf(f,"</HTML>\n");
 fclose(f);
}


void gtk_table_out(char* title, char*** str_data, int a, int b)
{
 GtkWidget* window, *table, *button, *scrolled_window, *btn_sav;
 GtkWidget*** entry;
 struct result_cache res_cache;
 int i,j;
 debug("%s:%d",__FILE__,__LINE__);
 if (!str_data) { gtk_dialog_printf("Error, table of results to display is equal NULL"); return; }
 res_cache.data = str_data;
 res_cache.rows = a;
 res_cache.cols = b;
 if (b>32 || a>512)
   {
    gtk_dialog_printf("Result is too big, rows=%d, columns=%d\nwill be truncated!", a, b);
    if (a>512) b = (b>12 )?12 :b;
    else if (a>256)  b = (b>24 )?24 :b;
    else if (a>128)  b = (b>48 )?48 :b;
    else             b = (b>64 )?64:b;
    a = (a>512)?512:a;
   }
 entry = (GtkWidget***)malloc(a*sizeof(GtkWidget**));
 for (i=0;i<a;i++) entry[i] = (GtkWidget**)malloc(b*sizeof(GtkWidget*));
 window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_window_set_modal(GTK_WINDOW(window), TRUE);
 gtk_widget_set_usize (GTK_WIDGET(window), 600, 600);
 debug("a=%d, b=%d\n",a,b);
 table = gtk_table_new (a+2, b, FALSE);
 for (i=0;i<a;i++)
 for (j=0;j<b;j++)
   {
    entry[i][j] = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(entry[i][j]), str_data[i][j]);
    gtk_entry_set_editable(GTK_ENTRY(entry[i][j]), FALSE);
    gtk_table_attach (GTK_TABLE (table), entry[i][j], j, j+1, i+2, i+3,GTK_FILL,GTK_FILL, 0, 0);
    gtk_widget_show(entry[i][j]);
   }
 button = gtk_button_new_with_label("Close this window");
 gtk_table_attach (GTK_TABLE (table), button, 0, (b>3)?4:(b+1), 0, 1,GTK_FILL,GTK_FILL, 0, 0);
 gtk_widget_show(button);
 btn_sav = gtk_button_new_with_label("Save results");
 gtk_table_attach (GTK_TABLE (table), btn_sav, 0, (b>3)?4:(b+1), 1, 2,GTK_FILL,GTK_FILL, 0, 0);
 gtk_widget_show(btn_sav);
 gtk_widget_show (table);
 scrolled_window = gtk_scrolled_window_new(NULL,NULL);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window), table);
 gtk_container_set_border_width(GTK_CONTAINER(window), 2);
 gtk_container_set_border_width(GTK_CONTAINER(scrolled_window), 2);
 gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
 gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(close_results), (gpointer)(window));
 gtk_signal_connect(GTK_OBJECT(btn_sav),"clicked", GTK_SIGNAL_FUNC(save_results),  (gpointer)(&res_cache));
 gtk_widget_show(scrolled_window);
 gtk_container_add (GTK_CONTAINER(window), scrolled_window);
 gtk_window_set_title(GTK_WINDOW(window), title);
 gtk_widget_show(window);
 gtk_main();
 for (i=0;i<a;i++) free(entry[i]);
 free(entry);
}

/*                    TEST QUERY EXEC FUNC

void test_queries()
{
 char*** ptr;
 char errstr[MAX_QUERY_LENGTH];
 int a,b;
 ptr=p3c_execute_printf(connection,&a,&b,errstr, "SELECT * FROM %s", "ocena");
 if (a<0 || b<0)
 {
  gtk_dialog_printf("%s", errstr);
  return ;
 }
 free_p3c(&ptr,a,b);
}

*/

void clear_txt_ctrl(GtkWidget* w)
{
 int l;
 debug("%s:%d",__FILE__,__LINE__);
 l = gtk_text_get_length(GTK_TEXT(w));
 gtk_text_set_point(GTK_TEXT(w), 0);
 gtk_text_forward_delete(GTK_TEXT(w), l);
}


void load_proc(GtkWidget* w, gpointer txt)
{
 char* filen;
 FILE* f;
 int l,max;
 char* str;
 debug("%s:%d",__FILE__,__LINE__);
 if (!connected)
   {
    gtk_dialog_printf("Connect to DB firest!");
    return;
   }
 filen = gtk_dialog_getfile(".QUE", "Select query file (*.QUE)");
 if (!strcmp(filen,""))
   {
    gtk_dialog_printf("Cannot load query from non-QUE file\n");
    return;
   }
 f = fopen(filen,"r");
 if (!f)
   {
    gtk_dialog_printf("Cannot read from: %s\n", filen);
    return ;
   }
 clear_txt_ctrl(txt);
 fseek(f,0,SEEK_END);
 l=ftell(f);
 fseek(f,0,SEEK_SET);
 if (l>=MAX_QUERY_LENGTH-100)
   {
    gtk_dialog_printf("File is too long!\nTruncating...");
    l = MAX_QUERY_LENGTH-100;
   }
 str = malloc(l+2);
 max=l;
 l=0;
 while (l<=max && (str[l++]=fgetc(f))!=EOF) ;
 str[--l]=0;
 gtk_text_insert(GTK_TEXT(txt), NULL,NULL,NULL,str,l);
 fclose(f);
 free(str);
}


void save_proc(GtkWidget* w, gpointer txt)
{
 char *t,*filen;
 char filename[MAXPATH];
 FILE* f;
 int l,i;
 debug("%s:%d",__FILE__,__LINE__);
 l = gtk_text_get_length(GTK_TEXT(txt));
 if (l<3)
    {
     gtk_dialog_printf("Will not save empty query.");
     return;
    }
 t = malloc(l+2);
 for (i=0;i<l;i++) t[i] = GTK_TEXT_INDEX(GTK_TEXT(txt), i);
 t[i] = 0;
 filen = gtk_dialog_getfile(".QUE", "Enter filename to save query");
 if (!strcmp(filen,""))
   {
    gtk_dialog_printf("Cannot save query to non-QUE file\n");
    free(t);
    return;
   }
 strcpy(filename,filen);
 f = fopen(filename,"r");
 if (f)
   {
    fclose(f);
    if (!gtk_dialog_yes_no_printf("Overwite file: %s?", filename))
      {
       free(t);
       return ;
      }
   }
 f = fopen(filename,"w");
 if (!f)
   {
    gtk_dialog_printf("Cannot write to: %s\n", filename);
    free(t);
    return ;
   }
 fprintf(f,"%s", t);
 free(t);
 fclose(f);
 gtk_dialog_printf("Saved to %s\n", filename);
}


int create_query_from_fname(char* fname, GtkWidget* txt)
{
 FILE* f;
 int l,max;
 char* str;
 debug("%s:%d",__FILE__,__LINE__);
 f = fopen_printf("r", "%s.que", fname); if (f) goto file_got;
 f = fopen_printf("r", "%s.Que", fname); if (f) goto file_got;
 f = fopen_printf("r", "%s.qUe", fname); if (f) goto file_got;
 f = fopen_printf("r", "%s.quE", fname); if (f) goto file_got;
 f = fopen_printf("r", "%s.QUe", fname); if (f) goto file_got;
 f = fopen_printf("r", "%s.QuE", fname); if (f) goto file_got;
 f = fopen_printf("r", "%s.qUE", fname); if (f) goto file_got;
 f = fopen_printf("r", "%s.QUE", fname); if (f) goto file_got;
 else return 0;
 file_got:
 fseek(f,0,SEEK_END);
 l=ftell(f);
 fseek(f,0,SEEK_SET);
 if (l>=MAX_QUERY_LENGTH-100)
   {
    gtk_dialog_printf("File is too long!\nTruncating...");
    l = MAX_QUERY_LENGTH-100;
   }
 str = malloc(l+2);
 max=l;
 l=0;
 while (l<=max && (str[l++]=fgetc(f))!=EOF);
 str[--l]=0;
 gtk_text_insert(GTK_TEXT(txt), NULL,NULL,NULL,str,l);
 fclose(f);
 free(str);
 return 1;
}


void execute_fast_one(GtkWidget* w, gpointer opt)
{
 execute_fast(NULL,(gpointer)(1));
}


void execute_fast_two(GtkWidget* w, gpointer opt)
{
 execute_fast(NULL,(gpointer)(2));
}


void execute_fast_thr(GtkWidget* w, gpointer opt)
{
 execute_fast(NULL,(gpointer)(3));
}


void execute_fast(GtkWidget* w, gpointer opt)
{
 GtkWidget* text;
 char* filen;
 debug("%s:%d",__FILE__,__LINE__);
 debug("Execute fast! %d\n",(int)(opt));
 if (!connected) { gtk_dialog_printf("Connect to DB first!"); return; }
 text = gtk_text_new (NULL, NULL);
 switch ((int)(opt))
 {
  case 1:
    load_proc(NULL, (gpointer)(text));
    execute_proc(NULL, (gpointer)(text));
    break;
  case 2:	/*WriteFname*/
    filen = gtk_dialog_gettext("Enter filename (without extension): ");
    if (!strcmp(filen,"")) { gtk_dialog_printf("Empty filename"); return; }
    if (!create_query_from_fname(filen, text)) { gtk_dialog_printf("Cannot load query from file\n%s\nTried with various masks", filen); return; }
    execute_proc(NULL, (gpointer)(text));
    break;
  case 3:	/*SQL cmd*/
    filen = gtk_dialog_gettext_big("Enter short SQL Query:");
    if (!strcmp(filen,"")) { gtk_dialog_printf("Will not execute empty query!"); return; }
    gtk_text_insert(GTK_TEXT(text), NULL,NULL,NULL,filen,strlen(filen));
    execute_proc(NULL, (gpointer)(text));
    break;
  default: error("bad opt value, %s:%d",__FILE__,__LINE__); return;
 }
}


void execute_proc(GtkWidget* w, gpointer txt)
{
 char* t;
 int l,i,a,b;
 PGresult *result;
 char errstr[MAX_QUERY_LENGTH+0x100];
 char*** out;
 debug("%s:%d",__FILE__,__LINE__);
 if (!connected)
   {
    gtk_dialog_printf("Connect to DB first!");
    return;
   }
 l = gtk_text_get_length(GTK_TEXT(txt));
 if (l>=MAX_QUERY_LENGTH-100)
   {
    gtk_dialog_printf("Query too long!\n");
    return ;
   }
 if (l<3)
    {
     gtk_dialog_printf("Will not execute empty query\nTry once again.");
     return;
    }
 t = malloc(l+2);
 for (i=0;i<l;i++) t[i] = GTK_TEXT_INDEX(GTK_TEXT(txt), i);
 t[i] = 0;
 result = NULL;
 execute_printf_query(connection, &result, errstr, t);
 free(t);
 if (!result)
   {
    gtk_dialog_printf_big("Error executing query:\nReturn from DBMS: %s\n", errstr);
    return;
   }
 out = mpgres2pc3(result, &a, &b, 1);
 clear_result(&result);
 if (a>0 && b>0) gtk_table_out("Results of Query:", out, a, b);
 else gtk_dialog_printf("Query was OK, but didn't returned any result\nThis probably was INSERT OR CREATE...");
 mfree_p3c(&out, a, b);
 refresh_all(); 		/* FIXME HARDCORE !!! */
}


void update_entry(GtkWidget* w, gpointer d)
{
 debug("%s:%d",__FILE__,__LINE__);
 strcpy((char*)d,gtk_entry_get_text(GTK_ENTRY(w)));
}


void apply_proc(GtkWidget* w, gpointer d)
{
 char** ptr;
 debug("%s:%d",__FILE__,__LINE__);
 ptr = (char**)d;
 if (setenv("PGPORT",ptr[0],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGPORT");
 if (setenv("PGDATA",ptr[1],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGDATA");
 if (setenv("PGHOST",ptr[2],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGHOST");
 reload_bases(ptr[3], 1);
}


int connect_proc(GtkWidget* w, gpointer d)
{
 char** ptr;
 debug("%s:%d",__FILE__,__LINE__);
 ptr = (char**)d;
 if (setenv("PGPORT",ptr[0],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGPORT");
 if (setenv("PGDATA",ptr[1],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGDATA");
 if (setenv("PGHOST",ptr[2],1)==-1) gtk_dialog_printf("Cannot set environment variable: PGHOST");
 reload_bases(ptr[3], 0);
 gtk_main_quit();
 return TRUE;
}


int delete_proc(GtkWidget* w, gpointer d)
{
 debug("%s:%d",__FILE__,__LINE__);
 gtk_main_quit();
 /*gtk_widget_destroy((GtkWidget*)d);*/
 return TRUE;
}


char* get_env(char* str)
{
 char* ret;
 debug("%s:%d",__FILE__,__LINE__);
 ret = getenv(str);
 if (ret) return ret;
 else return "";
}


void env_dialog(GtkWidget* www, gpointer d)
{
 GtkWidget* dialog, *label[4], *button[3], *entry[4], *table;
 char **t_entry;
 int i;
 debug("%s:%d",__FILE__,__LINE__);
 t_entry = (char**)malloc(4<<2);
 for (i=0;i<4;i++) t_entry[i] = (char*)malloc(STDSTRING+1);
 for (i=0;i<4;i++)strcpy(t_entry[i], "");
 dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 if (!d) gtk_window_set_title(GTK_WINDOW(dialog), "Environment settings");
 else gtk_window_set_title(GTK_WINDOW(dialog), "Write at least database name, empty fields means default");
 gtk_widget_set_usize(dialog, 500, 160);
 gtk_window_set_modal(GTK_WINDOW(dialog), 1);
 label[0] = gtk_label_new("Port:");
 label[1] = gtk_label_new("DataDir:");
 label[2] = gtk_label_new("Host:");
 label[3] = gtk_label_new("DataBase:");
 for (i=0;i<4;i++)
  {
   entry[i] = gtk_entry_new();
   gtk_entry_set_max_length(GTK_ENTRY(entry[i]), STDSTRING-1);
   gtk_entry_set_editable(GTK_ENTRY(entry[0]), TRUE);
   gtk_signal_connect(GTK_OBJECT(entry[i]), "activate", GTK_SIGNAL_FUNC(update_entry), (gpointer)t_entry[i]);
   gtk_signal_connect(GTK_OBJECT(entry[i]), "changed",  GTK_SIGNAL_FUNC(update_entry), (gpointer)t_entry[i]);
  }
 table = gtk_table_new (5, 3, TRUE);
 gtk_entry_set_text(GTK_ENTRY(entry[0]), get_env("PGPORT"));
 gtk_entry_set_text(GTK_ENTRY(entry[1]), get_env("PGDATA"));
 gtk_entry_set_text(GTK_ENTRY(entry[2]), get_env("PGHOST"));
 gtk_entry_set_text(GTK_ENTRY(entry[3]), currentbase?currentbase:"");
 for (i=0;i<4;i++)
   {
    gtk_table_attach (GTK_TABLE (table),label[i], 0, 1, i, i+1,GTK_FILL,GTK_FILL, 0, 0);
    gtk_table_attach (GTK_TABLE (table),entry[i], 1, 3, i, i+1,GTK_FILL|GTK_EXPAND,GTK_FILL, 0, 0);
    gtk_widget_show(entry[i]);
    gtk_widget_show(label[i]);
   }
 if (!d)
  {
   button[0] = gtk_button_new_with_label("Apply");
   button[1] = gtk_button_new_with_label("Close");
   gtk_signal_connect(GTK_OBJECT(button[0]), "clicked", GTK_SIGNAL_FUNC(apply_proc), (gpointer)(t_entry));
   gtk_signal_connect(GTK_OBJECT(button[1]), "clicked", GTK_SIGNAL_FUNC(delete_proc), (gpointer)dialog);
  }
 button[2] = gtk_button_new_with_label("Connect");
 gtk_signal_connect(GTK_OBJECT(button[2]), "clicked", GTK_SIGNAL_FUNC(connect_proc),(gpointer)(t_entry));
 if (!d)
   {
    gtk_table_attach (GTK_TABLE (table), button[0], 1, 2, 4, 5,GTK_FILL,GTK_FILL|GTK_EXPAND, 0, 0);
    gtk_table_attach (GTK_TABLE (table), button[1], 2, 3, 4, 5,GTK_FILL,GTK_FILL|GTK_EXPAND, 0, 0);
    gtk_table_attach (GTK_TABLE (table), button[2], 0, 1, 4, 5,GTK_FILL,GTK_FILL|GTK_EXPAND, 0, 0);
    gtk_widget_show(button[0]);
    gtk_widget_show(button[1]);
   }
 else gtk_table_attach (GTK_TABLE (table), button[2], 0, 3, 4, 5,GTK_FILL,GTK_FILL|GTK_EXPAND, 0, 0);
 gtk_widget_show(button[2]);
 gtk_widget_grab_focus(entry[0]);
 gtk_container_add(GTK_CONTAINER(GTK_WINDOW(dialog)), table);
 gtk_widget_show(table);
 gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(delete_proc), (gpointer)dialog);
 gtk_widget_show(dialog);
 gtk_main();
 for (i=0;i<4;i++) free(t_entry[i]);
 free(t_entry);
 gtk_widget_destroy(dialog);
}


void check_exec_proc(GtkWidget* txt, gpointer dlg)
{
 int l;
 debug("%s:%d",__FILE__,__LINE__);
 l = gtk_text_get_length(GTK_TEXT(txt));
 if (GTK_TEXT_INDEX(GTK_TEXT(txt), l-1)==';')
 {
  gtk_text_set_point(GTK_TEXT(txt), l);
  gtk_text_backward_delete(GTK_TEXT(txt), 1);
  execute_proc(dlg,(GtkWidget*)txt);
 }
}

void post_start(GtkWidget* w, gpointer data)
{
 debug("%s:%d",__FILE__,__LINE__);
 setenv("PGHOST", "localhost", 1);
 setenv("PGPORT", "5432", 1);
 system("pg_ctl start");
}

void global_free_mem(GtkWidget* w, gpointer data)
{
 debug("%s:%d",__FILE__,__LINE__);
 destruct_tab_view(NULL,NULL);
 shred_memlist();
}

void query_executor(GtkWidget* w, gpointer data)
{
 GtkWidget* window, *table, *text, *hscrollbar, *vscrollbar, *button[3];
 debug("%s:%d",__FILE__,__LINE__);
 if (!connected)
   {
    gtk_dialog_printf("Connect to DB first!");
    return;
   }
 if (query_exec)
   {
    gtk_dialog_printf("Another instance of QueryExecutor is running.");
    return;
   }
 window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET(window), 400, 300);
 gtk_container_set_border_width(GTK_CONTAINER(window), 10);
 table = gtk_table_new (3, 4, FALSE);
 text = gtk_text_new (NULL, NULL);
 gtk_table_attach (GTK_TABLE (table), text, 0, 3, 1, 2,
		      GTK_FILL | GTK_EXPAND,
		      GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);
 gtk_text_set_editable(GTK_TEXT(text), TRUE);
 gtk_text_set_word_wrap(GTK_TEXT(text), TRUE);
 gtk_text_set_line_wrap(GTK_TEXT(text), TRUE);
 gtk_widget_show (text);
 hscrollbar = gtk_hscrollbar_new (GTK_TEXT (text)->hadj);
 gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 3, 2, 3,
		      GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);
 gtk_widget_show (hscrollbar);
 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 3, 4, 1, 2,
		      GTK_FILL, GTK_EXPAND | GTK_FILL | GTK_SHRINK, 0, 0);
 gtk_widget_show (vscrollbar);
 button[0] = gtk_button_new_with_label("Run");
 button[1] = gtk_button_new_with_label("Save");
 button[2] = gtk_button_new_with_label("Load");
 gtk_table_attach (GTK_TABLE (table), button[0], 0, 1, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
 gtk_table_attach (GTK_TABLE (table), button[1], 1, 2, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
 gtk_table_attach (GTK_TABLE (table), button[2], 2, 3, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
 gtk_widget_show(button[0]);
 gtk_widget_show(button[1]);
 gtk_widget_show(button[2]);
 gtk_container_add (GTK_CONTAINER(window), table);
 gtk_widget_show (table);
 gtk_widget_grab_focus(text);
 gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(qexec_quit), NULL);
 gtk_signal_connect(GTK_OBJECT(text),   "changed", GTK_SIGNAL_FUNC(check_exec_proc), (gpointer)(window));
 gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(qexec_quit), NULL);
 gtk_signal_connect(GTK_OBJECT(button[0]), "clicked", GTK_SIGNAL_FUNC(execute_proc), (gpointer)(text));
 gtk_signal_connect(GTK_OBJECT(button[1]), "clicked", GTK_SIGNAL_FUNC(save_proc), (gpointer)(text));
 gtk_signal_connect(GTK_OBJECT(button[2]), "clicked", GTK_SIGNAL_FUNC(load_proc), (gpointer)(text));
 gtk_window_set_title(GTK_WINDOW(window), "SQL Query Editor, type `;' to execute query");
 gtk_widget_show(window);
 query_exec = window;
 gtk_main();
}

static GtkItemFactoryEntry menu_items[] = {
  { "/_File",         		NULL,         NULL, 0, "<Branch>" },
  { "/File/_New DB",     	"<control>N", create_database, 0, NULL },	/* DONE */
  { "/File/_Open DB",    	"<control>O", load_database, 0, NULL },		/* DONE */
  { "/File/_Create DB from File","<control>C", create_DB_from_file, 0, NULL },  /* DONE */
  { "/File/_Save DB to File",	"<control>S", save_database, 0, NULL },		/* DONE */
  { "/File/_Drop DB",	"<control>D", drop_database, 0, NULL },			/* DONE */
  { "/File/_Copy DB",	"<control>P", copy_database, 0, NULL },			/* DONE */
  { "/File/_Execute SQL Query",	"<control>E", query_executor, 0, NULL },	/* DONE */
  { "/File/sep1",     NULL,         NULL, 0, "<Separator>" },
  { "/File/Quit",     "<control>Q", (void (*)(GtkWidget*,gpointer))menu_quit, 0, NULL }, /* DONE */
  { "/_Options",      NULL,         NULL, 0, "<Branch>" },			/* DONE */
  { "/Options/Test",  "<control>T",         exec_test_prog, 0, NULL },		/* DONE */
  { "/Options/Start _Postmaster",  "<control>P",post_start, 0, NULL },		/* DONE */
  { "/Options/Global FreeMem",  NULL,        global_free_mem, 0, NULL },	/* DONE */
  { "/Options/Environment",     NULL,       env_dialog, 0, NULL },		/* DONE */
  { "/_Execute",      NULL,         NULL, 0, "<Branch>" },
  { "/Execute/_SQL Query Editor",  NULL        ,   query_executor, 0, NULL },
  { "/Execute/_Fast Exec OpenDlg",     NULL,       execute_fast_one, 0, NULL },
  { "/Execute/_Fast Exec WriteFileName",     NULL, execute_fast_two, 0, NULL },
  { "/Execute/_Fast Exec Query",     NULL,         execute_fast_thr, 0, NULL},
  { "/_Help",         NULL,         NULL, 0, "<LastBranch>" },
  { "/_Help/About",   NULL,         about_box, 0, NULL },			/* DONE */
};

void get_main_menu(GtkWidget *window, GtkWidget **menubar)
{
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
 debug("%s:%d",__FILE__,__LINE__);
  accel_group = gtk_accel_group_new ();
  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",accel_group);
  gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);
  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
  if (menubar) *menubar = gtk_item_factory_get_widget (item_factory, "<main>");
}


int dummy_connect(int cn, char* templ)
{
 char errstr[MAX_ENTRY_LENGTH];
 debug("%s:%d",__FILE__,__LINE__);
 if (cn==1)
  {
   connection = gtk_connect_db(templ, errstr);
   if (!connection)
     {
      gtk_dialog_printf("Connect to template DB: %s failed\nDBMS returned:\n%s", templ,errstr);
      return 0;
     }
   connected=1;
   return 1;
  }
 disconnect();
 return 0;
}


int parse_cmdline(int lb, char** par, GtkWidget* w)
{
 char* dbname;
 char errstr[MAX_ENTRY_LENGTH];
 int gotdb,ch;
 int tmp;
 debug("%s:%d",__FILE__,__LINE__);
 gotdb=0;
 dbname = NULL;
 while ((ch = getopt(lb,par,"d:s:p:b:t:m:hev")) != -1)
   {
    switch (ch)
      {
       case 's': setenv("PGHOST", optarg, 1); break;
       case 'p': setenv("PGPORT", optarg, 1); break;
       case 'b': setenv("PGDATA", optarg, 1); break;
       case 't': tmp=atoi(optarg); if (tmp<=0) fatal("timeout value: %d too small", tmp); timeout=tmp; break;
       case 'd': gotdb=1; dbname = malloc(strlen(optarg)+1); strcpy(dbname, optarg); break;
       case 'e': gotdb=1; env_dialog(w,(gpointer)1); return 0;
       case 'v': want_all_elems=1; break;
       case 'm': max_tabs = atoi(optarg); if (max_tabs<=0) fatal("max tabs cannot be less or equal 0");  break;
       case 'h':
		 gtk_dialog_printf_big("Options are:\n-d [database_name]\n"
				 "-e (use advanced environment)\n"
				 "-h this help\n"
				 "-s server name\n"
				 "-p port\n"
				 "-b base dir\n"
				 "-t timeout connection\n"
				 "-m max_tables in EntireDB\n"
				 "-v verbose, display all TABLES/VIEWS etc\n"
				 ); return 1;
       default:
		gtk_dialog_printf("Unrecognized command line option, try:\n"
				   "-h help"); return 1;
      }
   }
 if (!gotdb)
    {
     if (dummy_connect(1,TEMPLATE))
       {
	dbname = gtk_dialog_getdbs(connection, "Connect to database: ");
        dummy_connect(0,TEMPLATE);
       }
     else dbname = gtk_dialog_gettext("Type DB name manually:");
    }
 if (!strcmp(dbname,""))
    {
     gtk_dialog_printf("Empty Database name, cannot be opened.\nSystem will now exit.");
     return 1;
    }
 connection = gtk_connect_db(dbname, errstr);
 if (!connection)
   {
    fatal_nodb(dbname,errstr,1);
    if (gotdb) free(dbname);
    return 1;
   }
 else
   {
    connected=1;
    currentbase = (char*)malloc(strlen(dbname)+2);
    strcpy(currentbase, dbname);
    if (gotdb) free(dbname);
    setup_components();
    return 0;
   }
}

void todo()
{
 printf("TRUNCATED ROWS - CONROL TO SELECT A WINDOW, WITH <--*------>\n");
 printf("select Number from <a,b> control, z suwakiem!\n");
}


int main(int lb, char **par)
{
  GtkWidget *window;
  GtkWidget *menubar;
  GtkWidget* toolbar;
  char winname[MAX_ENTRY_LENGTH];
  int err;
  debug("%s:%d",__FILE__,__LINE__);
  todo();
  gtk_init (&lb, &par);
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  /*gtk_signal_connect (GTK_OBJECT (window), "destroy", GTK_SIGNAL_FUNC (gtk_main_quit), "WM destroy");*/
  gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(menu_quit), NULL);
  gtk_widget_set_usize (GTK_WIDGET(window), 800, 600);
  main_vbox = gtk_vbox_new (FALSE, 1);
  gtk_container_border_width (GTK_CONTAINER (main_vbox), 1);
  gtk_container_add (GTK_CONTAINER (window), main_vbox);
  gtk_widget_show (main_vbox);
  get_main_menu (window, &menubar);
  get_toolbar(window, &toolbar);
  gtk_box_pack_start (GTK_BOX (main_vbox), menubar, FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (main_vbox), toolbar, FALSE, TRUE, 0);
  gtk_widget_show (toolbar);
  gtk_widget_show (menubar);
  gtk_widget_show (window);
  main_wnd = window;
  setup_signals();
  construct_components();
  err = parse_cmdline(lb,par,window);
  if (err) return 1;
  else
    {
     if (currentbase) sprintf(winname, "PgXexplorer: %s", currentbase);
     else sprintf(winname, "PgXexplorer: NULL");
     gtk_window_set_title (GTK_WINDOW(window), winname);
    }
  gtk_main();
  return(0);
}

