#include "Shells.h"
#include <Helper/HostWindow.h>
#include <Helper/HostedUI.h>
#include <windows.h>

YSL_BEGIN

YSL_BEGIN_NAMESPACE(Host)

NativeWindowHandle
InitWindow(const Drawing::Size& s, const wchar_t* title, ::DWORD wstyle)
{
	::RECT rect{0, 0, s.Width, s.Height};

	::AdjustWindowRect(&rect, wstyle, FALSE);
	return ::CreateWindowW(WindowClassName, title, wstyle, CW_USEDEFAULT,
		CW_USEDEFAULT, rect.right - rect.left, rect.bottom - rect.top,
		HWND_DESKTOP, NULL, ::GetModuleHandleW(NULL), NULL);
}


void
Show(UI::Widget& wgt, ::DWORD wstyle, const wchar_t* title)
{
	WrapRenderer(wgt, InitWindow, GetSizeOf(wgt), title, wstyle);
}


void
PrintFPS(FPSCounter& f, Window& wnd)
{
	const auto t(f.Refresh());

	if(t != 0)
	{
		char buf[16];

		std::snprintf(buf, arrlen(buf),
			"FPS: %u.%03u\n", t / 1000, t % 1000);
		::SetWindowTextA(wnd.GetNativeHandle(), buf);
	}
}

YSL_END_NAMESPACE(Host)


YSL_BEGIN_NAMESPACE(Shells)


YSL_END_NAMESPACE(Shells)

YSL_END

