//
// AbstractConfigurationTest.h
//
// $Id: //poco/1.4/Util/testsuite/src/AbstractConfigurationTest.h#1 $
//
// Definition of the AbstractConfigurationTest class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef AbstractConfigurationTest_INCLUDED
#define AbstractConfigurationTest_INCLUDED


#include "Poco/Util/Util.h"
#include "CppUnit/TestCase.h"
#include "Poco/AutoPtr.h"
#include "Poco/Util/AbstractConfiguration.h"


class AbstractConfigurationTest: public CppUnit::TestCase
{
public:
	AbstractConfigurationTest(const std::string& name);
	virtual ~AbstractConfigurationTest();

	void testHasProperty();
	void testGetString();
	void testGetInt();
	void testGetDouble();
	void testGetBool();
	void testExpand();
	void testSetString();
	void testSetInt();
	void testSetDouble();
	void testSetBool();
	void testKeys();
	void testRemove();
	void testChangeEvents();
	void testRemoveEvents();
	
	void setUp();
	void tearDown();
	
	void onPropertyChanging(const void*, Poco::Util::AbstractConfiguration::KeyValue& kv);
	void onPropertyChanged(const void*, const Poco::Util::AbstractConfiguration::KeyValue& kv);
	void onPropertyRemoving(const void*, const std::string& key);
	void onPropertyRemoved(const void*, const std::string& key);

protected:
	virtual Poco::Util::AbstractConfiguration* allocConfiguration() const = 0;
	virtual Poco::AutoPtr<Poco::Util::AbstractConfiguration> createConfiguration() const;

	std::string _changingKey;
	std::string _changingValue;
	std::string _changedKey;
	std::string _changedValue;
	std::string _removingKey;
	std::string _removedKey;
};


#define AbstractConfigurationTest_addTests(suite, cls) \
	do { \
		CppUnit_addTest(suite, cls, testHasProperty); \
		CppUnit_addTest(suite, cls, testGetString); \
		CppUnit_addTest(suite, cls, testGetInt); \
		CppUnit_addTest(suite, cls, testGetDouble); \
		CppUnit_addTest(suite, cls, testGetBool); \
		CppUnit_addTest(suite, cls, testExpand); \
		CppUnit_addTest(suite, cls, testSetString); \
		CppUnit_addTest(suite, cls, testSetInt); \
		CppUnit_addTest(suite, cls, testSetDouble); \
		CppUnit_addTest(suite, cls, testSetBool); \
		CppUnit_addTest(suite, cls, testKeys); \
		CppUnit_addTest(suite, cls, testRemove); \
		CppUnit_addTest(suite, cls, testChangeEvents); \
		CppUnit_addTest(suite, cls, testRemoveEvents); \
	} while(0)


#endif // AbstractConfigurationTest_INCLUDED
