/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    long jniRef;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int HOT = 32;
    static final int MOVED = 64;
    static final int RESIZED = 128;
    static final int EXPANDING = 256;
    static final int IGNORE_WHEEL = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int THEME_BACKGROUND = 2048;
    static final int LAYOUT_NEEDED = 4096;
    static final int LAYOUT_CHANGED = 8192;
    static final int LAYOUT_CHILD = 16384;
    static final int RELEASED = 32768;
    static final int DISPOSE_SENT = 65536;
    static final int FOREIGN_HANDLE = 131072;
    static final int DRAG_DETECT = 262144;
    static final int RESIZING = 524288;
    static final int WEBKIT_EVENTS_FIX = 0x100000;
    static final String WEBKIT_EVENTS_FIX_KEY = "org.eclipse.swt.internal.webKitEventsFix";
    static final String GLCONTEXT_KEY = "org.eclipse.swt.internal.cocoa.glcontext";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.isActive";
    static final int SKIN_NEEDED = 0x200000;
    static final int HAS_AUTO_DIRECTION = 0;
    static final int AUTO_TEXT_DIRECTION = 0x6000000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;

    Widget() {
    }

    public Widget(Widget widget, int n) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n;
        this.display = widget.display;
        this.reskinWidget();
    }

    long accessibleHandle() {
        return 0L;
    }

    long accessibilityActionDescription(long l, long l2, long l3) {
        return this.callSuperObject(l, l2, l3);
    }

    long accessibilityActionNames(long l, long l2) {
        return this.callSuperObject(l, l2);
    }

    long accessibilityAttributeNames(long l, long l2) {
        return this.callSuperObject(l, l2);
    }

    long accessibilityAttributeValue(long l, long l2, long l3) {
        return this.callSuperObject(l, l2, l3);
    }

    long accessibilityAttributeValue_forParameter(long l, long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, l3, l4);
    }

    long accessibilityFocusedUIElement(long l, long l2) {
        return this.callSuperObject(l, l2);
    }

    long accessibilityHitTest(long l, long l2, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, nSPoint);
    }

    boolean accessibilityIsAttributeSettable(long l, long l2, long l3) {
        return this.callSuperBoolean(l, l2, l3);
    }

    boolean accessibilityIsIgnored(long l, long l2) {
        return this.callSuperBoolean(l, l2);
    }

    long accessibilityParameterizedAttributeNames(long l, long l2) {
        return this.callSuperObject(l, l2);
    }

    void accessibilityPerformAction(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void accessibilitySetValue_forAttribute(long l, long l2, long l3, long l4) {
        this.callSuper(l, l2, l3, l4);
    }

    String getClipboardText() {
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return "";
        }
        NSString nSString = nSPasteboard.stringForType(OS.NSStringPboardType);
        return nSString != null ? nSString.getString() : null;
    }

    void setClipRegion(NSView nSView) {
    }

    long attributedSubstringFromRange(long l, long l2, long l3) {
        return 0L;
    }

    void callSuper(long l, long l2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2);
    }

    void callSuper(long l, long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, l3);
    }

    void callSuper(long l, long l2, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, nSRect);
    }

    void callSuper(long l, long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, l3, l4);
    }

    void callSuper(long l, long l2, NSRect nSRect, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, nSRect, l3);
    }

    long callSuper(long l, long l2, long l3, NSRect nSRect, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, l3, nSRect, l4);
    }

    boolean callSuperBoolean(long l, long l2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2) != 0L;
    }

    boolean canBecomeKeyWindow(long l, long l2) {
        return this.callSuperBoolean(l, l2);
    }

    boolean needsPanelToBecomeKey(long l, long l2) {
        return this.callSuperBoolean(l, l2);
    }

    void cancelOperation(long l, long l2, long l3) {
    }

    NSSize cellSize(long l, long l2) {
        NSSize nSSize = new NSSize();
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper_stret(nSSize, objc_super2, l2);
        return nSSize;
    }

    NSSize cellSizeForBounds(long l, long l2, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, objc_super2, l2, nSRect);
        return nSSize;
    }

    boolean callSuperBoolean(long l, long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, l3) != 0L;
    }

    boolean callSuperBoolean(long l, long l2, NSRange nSRange, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper_bool(objc_super2, l2, nSRange, l3);
    }

    long callSuperObject(long l, long l2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2);
    }

    long callSuperObject(long l, long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, l3);
    }

    long callSuperObject(long l, long l2, long l3, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, l3, l4);
    }

    NSRect callSuperRect(long l, long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        NSRect nSRect = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect, objc_super2, l2, l3);
        return nSRect;
    }

    NSRect callSuperRect(long l, long l2, NSRect nSRect, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        NSRect nSRect2 = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect2, objc_super2, l2, nSRect, l3);
        return nSRect2;
    }

    boolean canDragRowsWithIndexes_atPoint(long l, long l2, long l3, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper_bool(objc_super2, l2, l3, nSPoint);
    }

    long characterIndexForPoint(long l, long l2, long l3) {
        return Integer.MAX_VALUE;
    }

    long columnAtPoint(long l, long l2, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, nSPoint);
    }

    boolean acceptsFirstMouse(long l, long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, l3) != 0L;
    }

    boolean acceptsFirstResponder(long l, long l2) {
        return this.callSuperBoolean(l, l2);
    }

    boolean becomeFirstResponder(long l, long l2) {
        return this.callSuperBoolean(l, l2);
    }

    void becomeKeyWindow(long l, long l2) {
        this.callSuper(l, l2);
    }

    public void reskin(int n) {
        this.checkWidget();
        this.reskinWidget();
        if ((n & 1) != 0) {
            this.reskinChildren(n);
        }
    }

    void reskinChildren(int n) {
    }

    void reskinWidget() {
        if ((this.state & 0x200000) != 0x200000) {
            this.state |= 0x200000;
            this.display.addSkinnableWidget(this);
        }
    }

    boolean resignFirstResponder(long l, long l2) {
        return this.callSuperBoolean(l, l2);
    }

    public void addListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(n, listener);
    }

    void _addListener(int n, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    boolean canBecomeKeyView(long l, long l2) {
        return true;
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void clearDeferFlushing(long l, long l2) {
    }

    boolean textView_clickOnLink_atIndex(long l, long l2, long l3, long l4, long l5) {
        return true;
    }

    void collapseItem_collapseChildren(long l, long l2, long l3, boolean bl) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, l3, bl);
    }

    void copyToClipboard(char[] cArray) {
        if (cArray.length == 0) {
            return;
        }
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return;
        }
        nSPasteboard.declareTypes(NSArray.arrayWithObject(OS.NSStringPboardType), null);
        nSPasteboard.setString(NSString.stringWithCharacters(cArray, cArray.length), OS.NSStringPboardType);
    }

    void createHandle() {
    }

    void createJNIRef() {
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0L) {
            this.error(2);
        }
    }

    void createWidget() {
        this.createJNIRef();
        this.createHandle();
        this.setOrientation();
        this.register();
    }

    void comboBoxSelectionDidChange(long l, long l2, long l3) {
    }

    void comboBoxWillDismiss(long l, long l2, long l3) {
    }

    void comboBoxWillPopUp(long l, long l2, long l3) {
    }

    void dealloc(long l, long l2) {
        this.callSuper(l, l2);
    }

    void deregister() {
    }

    void destroyJNIRef() {
        if (this.jniRef != 0L) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0L;
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void deselectAll(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void deselectRow(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void doCommandBySelector(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    boolean dragSelectionWithEvent(long l, long l2, long l3, long l4, long l5) {
        return false;
    }

    void drawBackground(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
    }

    void drawBackgroundInClipRect(long l, long l2, NSRect nSRect) {
        this.callSuper(l, l2, nSRect);
    }

    void drawImageWithFrameInView(long l, long l2, long l3, NSRect nSRect, long l4) {
        this.callSuper(l, l2, l3, nSRect, l4);
    }

    NSRect drawTitleWithFrameInView(long l, long l2, long l3, NSRect nSRect, long l4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        NSRect nSRect2 = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect2, objc_super2, l2, l3, nSRect, l4);
        return nSRect2;
    }

    void drawInteriorWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        this.callSuper(l, l2, nSRect, l3);
    }

    void drawLabelInRect(long l, long l2, boolean bl, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, bl, nSRect);
    }

    void drawViewBackgroundInRect(long l, long l2, NSRect nSRect) {
        this.callSuper(l, l2, nSRect);
    }

    void drawWithExpansionFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        this.callSuper(l, l2, nSRect, l3);
    }

    void drawRect(long l, long l2, NSRect nSRect) {
        if (!this.isDrawing()) {
            return;
        }
        Display display = this.display;
        NSView nSView = new NSView(l);
        display.isPainting.addObject(nSView);
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        nSGraphicsContext.saveGraphicsState();
        this.setClipRegion(nSView);
        this.drawBackground(l, nSGraphicsContext, nSRect);
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, nSRect);
        if (!this.isDisposed()) {
            this.drawWidget(l, nSGraphicsContext, nSRect);
        }
        nSGraphicsContext.restoreGraphicsState();
        display.isPainting.removeObjectIdenticalTo(nSView);
    }

    void _drawThemeProgressArea(long l, long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, l3);
    }

    void drawWidget(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
    }

    long imageView() {
        return 0L;
    }

    void redrawWidget(NSView nSView, boolean bl) {
        nSView.setNeedsDisplay(true);
    }

    void redrawWidget(NSView nSView, long l, long l2, long l3, long l4, boolean bl) {
        NSRect nSRect = new NSRect();
        nSRect.x = l;
        nSRect.y = l2;
        nSRect.width = l3;
        nSRect.height = l4;
        nSView.setNeedsDisplayInRect(nSRect);
    }

    void error(int n) {
        SWT.error(n);
    }

    void expandItem_expandChildren(long l, long l2, long l3, boolean bl) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, l3, bl);
    }

    NSRect expansionFrameWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        NSRect nSRect2 = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect2, objc_super2, l2, nSRect, l3);
        return nSRect2;
    }

    boolean filters(int n) {
        return this.display.filters(n);
    }

    NSRect firstRectForCharacterRange(long l, long l2, long l3) {
        return new NSRect();
    }

    int fixMnemonic(char[] cArray) {
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if ((cArray[n2++] = cArray[n++]) != '&' || n == cArray.length) continue;
            if (cArray[n] == '&') {
                ++n;
                continue;
            }
            --n2;
        }
        return n2;
    }

    NSRect focusRingMaskBoundsForFrame(long l, long l2, NSRect nSRect, long l3) {
        return this.callSuperRect(l, l2, nSRect, l3);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(IS_ACTIVE)) {
            return this.isActive();
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            for (int i = 1; i < objectArray.length; i += 2) {
                if (!string.equals(objectArray[i])) continue;
                return objectArray[i + 1];
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    boolean getDrawing() {
        return true;
    }

    public Listener[] getListeners(int n) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(n);
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hasMarkedText(long l, long l2) {
        return false;
    }

    NSRect headerRectOfColumn(long l, long l2, long l3) {
        return this.callSuperRect(l, l2, l3);
    }

    void helpRequested(long l, long l2, long l3) {
    }

    void highlightSelectionInClipRect(long l, long l2, long l3) {
    }

    long hitTest(long l, long l2, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, nSPoint);
    }

    long hitTestForEvent(long l, long l2, long l3, NSRect nSRect, long l4) {
        return 0L;
    }

    boolean hooks(int n) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n);
    }

    long image(long l, long l2) {
        return 0L;
    }

    NSRect imageRectForBounds(long l, long l2, NSRect nSRect) {
        return new NSRect();
    }

    boolean insertText(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
        return true;
    }

    boolean isActive() {
        return true;
    }

    public boolean isAutoDirection() {
        return false;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    boolean isDrawing() {
        return true;
    }

    boolean isFlipped(long l, long l2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2) != 0L;
    }

    public boolean isListening(int n) {
        this.checkWidget();
        return this.hooks(n);
    }

    boolean isOpaque(long l, long l2) {
        return false;
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void flagsChanged(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void keyDown(long l, long l2, long l3) {
        this.superKeyDown(l, l2, l3);
    }

    void keyUp(long l, long l2, long l3) {
        this.superKeyUp(l, l2, l3);
    }

    void mouseDown(long l, long l2, long l3) {
        this.mouseDownSuper(l, l2, l3);
    }

    boolean mouseDownCanMoveWindow(long l, long l2) {
        return this.callSuperBoolean(l, l2);
    }

    void mouseDownSuper(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void mouseUp(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void mouseMoved(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void mouseDragged(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void mouseEntered(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void mouseExited(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void cursorUpdate(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void rightMouseDown(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void rightMouseUp(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void rightMouseDragged(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void otherMouseDown(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void otherMouseUp(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void otherMouseDragged(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    boolean shouldDelayWindowOrderingForEvent(long l, long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, l3) != 0L;
    }

    boolean menuHasKeyEquivalent_forEvent_target_action(long l, long l2, long l3, long l4, long l5, long l6) {
        return true;
    }

    long menuForEvent(long l, long l2, long l3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, l2, l3);
    }

    void menuNeedsUpdate(long l, long l2, long l3) {
    }

    boolean makeFirstResponder(long l, long l2, long l3) {
        return this.callSuperBoolean(l, l2, l3);
    }

    NSRange markedRange(long l, long l2) {
        return new NSRange();
    }

    void menu_willHighlightItem(long l, long l2, long l3, long l4) {
    }

    void menuDidClose(long l, long l2, long l3) {
    }

    void menuWillOpen(long l, long l2, long l3) {
    }

    void noResponderFor(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    long numberOfRowsInTableView(long l, long l2, long l3) {
        return 0L;
    }

    long outlineView_child_ofItem(long l, long l2, long l3, long l4, long l5) {
        return 0L;
    }

    void outlineView_didClickTableColumn(long l, long l2, long l3, long l4) {
    }

    long outlineView_objectValueForTableColumn_byItem(long l, long l2, long l3, long l4, long l5) {
        return 0L;
    }

    boolean outlineView_isItemExpandable(long l, long l2, long l3, long l4) {
        return false;
    }

    long outlineView_numberOfChildrenOfItem(long l, long l2, long l3, long l4) {
        return 0L;
    }

    boolean outlineView_shouldExpandItem_item(long l, long l2, long l3, long l4) {
        return true;
    }

    boolean outlineView_shouldReorderColumn_toColumn(long l, long l2, long l3, long l4, long l5) {
        return true;
    }

    boolean outlineView_shouldEditTableColumn_row(long l, long l2, long l3, long l4, long l5) {
        return false;
    }

    boolean outlineView_shouldTrackCell_forTableColumn_item(long l, long l2, long l3, long l4, long l5, long l6) {
        return true;
    }

    void outlineView_willDisplayCell_forTableColumn_item(long l, long l2, long l3, long l4, long l5, long l6) {
    }

    void outlineViewColumnDidMove(long l, long l2, long l3) {
    }

    void outlineViewColumnDidResize(long l, long l2, long l3) {
    }

    void outlineViewSelectionDidChange(long l, long l2, long l3) {
    }

    void outlineViewSelectionIsChanging(long l, long l2, long l3) {
    }

    void outlineView_setObjectValue_forTableColumn_byItem(long l, long l2, long l3, long l4, long l5, long l6) {
    }

    boolean outlineView_writeItems_toPasteboard(long l, long l2, long l3, long l4, long l5) {
        return false;
    }

    public void notifyListeners(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n, event);
    }

    void pageDown(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void pageUp(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void postEvent(int n) {
        this.sendEvent(n, null, false);
    }

    void postEvent(int n, Event event) {
        this.sendEvent(n, event, false);
    }

    void reflectScrolledClipView(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void register() {
    }

    void release(boolean bl) {
        if ((this.state & 0x10000) == 0) {
            this.state |= 0x10000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl);
        }
        if ((this.state & 0x8000) == 0) {
            this.state |= 0x8000;
            if (bl) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean bl) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
        this.destroyJNIRef();
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        if (this.display.tooltipTarget == this) {
            this.display.tooltipTarget = null;
        }
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    protected void removeListener(int n, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, sWTEventListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    void scrollClipViewToPoint(long l, long l2, long l3, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, l3, nSPoint);
    }

    void selectRowIndexes_byExtendingSelection(long l, long l2, long l3, boolean bl) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, l3, bl);
    }

    void scrollWheel(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    NSRange selectedRange(long l, long l2) {
        return new NSRange();
    }

    long nextValidKeyView(long l, long l2) {
        return this.callSuperObject(l, l2);
    }

    long previousValidKeyView(long l, long l2) {
        return this.callSuperObject(l, l2);
    }

    void sendDoubleSelection() {
    }

    void sendEvent(Event event) {
        this.display.sendEvent(this.eventTable, event);
    }

    void sendEvent(int n) {
        this.sendEvent(n, null, true);
    }

    void sendEvent(int n, Event event) {
        this.sendEvent(n, event, true);
    }

    void sendEvent(int n, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        if ((this.state & 0x100000) != 0) {
            return true;
        }
        Event event = new Event();
        if (!this.setKeyState(event, n, nSEvent)) {
            return true;
        }
        return this.sendKeyEvent(n, event);
    }

    boolean sendKeyEvent(int n, Event event) {
        this.sendEvent(n, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendHorizontalSelection() {
    }

    void sendCancelSelection() {
    }

    void sendSearchSelection() {
    }

    void sendSelection() {
    }

    void sendSelectionEvent(int n) {
        this.sendSelectionEvent(n, null, false);
    }

    void sendSelectionEvent(int n, Event event, boolean bl) {
        NSEvent nSEvent;
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        if ((nSEvent = NSApplication.sharedApplication().currentEvent()) != null) {
            this.setInputState(event, nSEvent, 0);
        }
        this.sendEvent(n, event, bl);
    }

    void sendVerticalSelection() {
    }

    public void setData(Object object) {
        this.checkWidget();
        if (WEBKIT_EVENTS_FIX_KEY.equals(object)) {
            this.state |= 0x100000;
            return;
        }
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (GLCONTEXT_KEY.equals(string)) {
            this.setOpenGLContext(object);
            return;
        }
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            for (n = 1; n < objectArray.length && !string.equals(objectArray[n]); n += 2) {
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n] = string;
            objectArray[n + 1] = object;
        } else if ((this.state & 4) != 0 && n != objectArray.length) {
            int n2 = objectArray.length - 2;
            if (n2 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n2];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                System.arraycopy(objectArray, n + 2, objectArray3, n, n2 - n);
                this.data = objectArray3;
            }
        }
        if (string.equals("org.eclipse.swt.skin.class") || string.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    void setOpenGLContext(Object object) {
    }

    void setOrientation() {
    }

    void setFrameOrigin(long l, long l2, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, nSPoint);
    }

    void setFrameSize(long l, long l2, NSSize nSSize) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, nSSize);
    }

    void setImage(long l, long l2, long l3) {
    }

    boolean setInputState(Event event, NSEvent nSEvent, int n) {
        int n2;
        if (nSEvent == null && (nSEvent = NSApplication.sharedApplication().currentEvent()) == null) {
            return true;
        }
        long l = nSEvent.modifierFlags();
        if ((l & 0x80000L) != 0L) {
            event.stateMask |= 0x10000;
        }
        if ((l & 0x20000L) != 0L) {
            event.stateMask |= 0x20000;
        }
        if ((l & 0x40000L) != 0L) {
            event.stateMask |= 0x40000;
        }
        if ((l & 0x100000L) != 0L) {
            event.stateMask |= 0x400000;
        }
        if (((n2 = OS.GetCurrentEventButtonState()) & 1) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((n2 & 2) != 0) {
            event.stateMask |= 0x200000;
        }
        if ((n2 & 4) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((n2 & 8) != 0) {
            event.stateMask |= 0x800000;
        }
        if ((n2 & 0x10) != 0) {
            event.stateMask |= 0x2000000;
        }
        switch (n) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode == 262144) {
                    event.stateMask &= 0xFFFBFFFF;
                }
                if (event.keyCode != 0x400000) break;
                event.stateMask &= 0xFFBFFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode == 262144) {
                    event.stateMask |= 0x40000;
                }
                if (event.keyCode != 0x400000) break;
                event.stateMask |= 0x400000;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int n, NSEvent nSEvent) {
        boolean bl = false;
        short s = nSEvent.keyCode();
        event.keyCode = Display.translateKey(s);
        switch (event.keyCode) {
            case 10: {
                event.keyCode = 0x1000050;
                event.character = (char)13;
                break;
            }
            case 8: {
                event.character = (char)8;
                break;
            }
            case 13: {
                event.character = (char)13;
                break;
            }
            case 127: {
                event.character = (char)127;
                break;
            }
            case 27: {
                event.character = (char)27;
                break;
            }
            case 9: {
                event.character = (char)9;
                break;
            }
            default: {
                NSString nSString;
                if ((event.keyCode == 0 || 16777258 <= event.keyCode && event.keyCode <= 0x1000050) && (nSString = nSEvent.characters()) != null && nSString.length() > 0L) {
                    event.character = (char)nSString.characterAtIndex(0L);
                }
                if (event.keyCode != 0) break;
                long l = 0L;
                long l2 = OS.TISCopyCurrentKeyboardInputSource();
                long l3 = OS.TISGetInputSourceProperty(l2, OS.kTISPropertyUnicodeKeyLayoutData());
                if (l3 != 0L) {
                    l = OS.CFDataGetBytePtr(l3);
                    if (l != 0L && OS.CFDataGetLength(l3) > 0L) {
                        long l4 = nSEvent.CGEvent();
                        long l5 = OS.CGEventGetIntegerValueField(l4, 10);
                        int n2 = 256;
                        char[] cArray = new char[n2];
                        int[] nArray = new int[1];
                        int[] nArray2 = new int[1];
                        OS.UCKeyTranslate(l, s, (short)(event.type != 1 ? 1 : 0), 0, (int)l5, 0, nArray2, n2, nArray, cArray);
                        event.keyCode = nArray[0] < 1 ? 0 : cArray[0];
                    }
                } else {
                    NSString nSString2 = nSEvent.charactersIgnoringModifiers().lowercaseString();
                    if (nSString2.length() > 0L) {
                        event.keyCode = (char)nSString2.characterAtIndex(0L);
                    }
                }
                if (l2 == 0L) break;
                OS.CFRelease(l2);
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !bl) {
            return false;
        }
        this.setLocationMask(event, nSEvent);
        this.setInputState(event, nSEvent, n);
        return true;
    }

    void setLocationMask(Event event, NSEvent nSEvent) {
        switch (nSEvent.keyCode()) {
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                event.keyLocation = 16384;
                break;
            }
            case 54: 
            case 60: 
            case 61: 
            case 62: {
                event.keyLocation = 131072;
                break;
            }
            case 65: 
            case 67: 
            case 69: 
            case 75: 
            case 76: 
            case 78: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: {
                event.keyLocation = 2;
            }
        }
    }

    boolean setMarkedText_selectedRange(long l, long l2, long l3, long l4) {
        return true;
    }

    void setNeedsDisplay(long l, long l2, boolean bl) {
        if (bl && !this.isDrawing()) {
            return;
        }
        NSView nSView = new NSView(l);
        if (bl && this.display.isPainting.containsObject(nSView)) {
            NSMutableArray nSMutableArray = this.display.needsDisplay;
            if (nSMutableArray == null) {
                nSMutableArray = (NSMutableArray)new NSMutableArray().alloc();
                this.display.needsDisplay = nSMutableArray = nSMutableArray.initWithCapacity(12L);
            }
            nSMutableArray.addObject(nSView);
            return;
        }
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, bl);
    }

    void setNeedsDisplayInRect(long l, long l2, long l3) {
        if (!this.isDrawing()) {
            return;
        }
        NSRect nSRect = new NSRect();
        OS.memmove(nSRect, l3, (long)NSRect.sizeof);
        NSView nSView = new NSView(l);
        if (this.display.isPainting.containsObject(nSView)) {
            NSMutableArray nSMutableArray = this.display.needsDisplayInRect;
            if (nSMutableArray == null) {
                nSMutableArray = (NSMutableArray)new NSMutableArray().alloc();
                this.display.needsDisplayInRect = nSMutableArray = nSMutableArray.initWithCapacity(12L);
            }
            nSMutableArray.addObject(nSView);
            nSMutableArray.addObject(NSValue.valueWithRect(nSRect));
            return;
        }
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, l2, nSRect);
    }

    void setObjectValue(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void setShouldExpandItem(long l, long l2, boolean bl) {
    }

    void setShouldScrollClipView(long l, long l2, boolean bl) {
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        return false;
    }

    boolean shouldChangeTextInRange_replacementString(long l, long l2, long l3, long l4) {
        return true;
    }

    NSSize sizeOfLabel(long l, long l2, boolean bl) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, objc_super2, l2, bl);
        return nSSize;
    }

    void superKeyDown(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void superKeyUp(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void tableViewColumnDidMove(long l, long l2, long l3) {
    }

    void tableViewColumnDidResize(long l, long l2, long l3) {
    }

    void tableViewSelectionDidChange(long l, long l2, long l3) {
    }

    void tableViewSelectionIsChanging(long l, long l2, long l3) {
    }

    void tableView_didClickTableColumn(long l, long l2, long l3, long l4) {
    }

    long tableView_objectValueForTableColumn_row(long l, long l2, long l3, long l4, long l5) {
        return 0L;
    }

    boolean tableView_shouldSelectRow(long l, long l2, long l3, long l4) {
        return true;
    }

    void tableView_setObjectValue_forTableColumn_row(long l, long l2, long l3, long l4, long l5, long l6) {
    }

    boolean tableView_shouldReorderColumn_toColumn(long l, long l2, long l3, long l4, long l5) {
        return true;
    }

    boolean tableView_shouldEditTableColumn_row(long l, long l2, long l3, long l4, long l5) {
        return false;
    }

    boolean tableView_shouldTrackCell_forTableColumn_row(long l, long l2, long l3, long l4, long l5, long l6) {
        return true;
    }

    void tableView_willDisplayCell_forTableColumn_row(long l, long l2, long l3, long l4, long l5, long l6) {
    }

    void textViewDidChangeSelection(long l, long l2, long l3) {
    }

    void textDidChange(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void textDidEndEditing(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(long l, long l2, long l3, long l4, long l5) {
        return new NSRange();
    }

    NSRect titleRectForBounds(long l, long l2, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = l;
        objc_super2.super_class = OS.objc_msgSend(l, OS.sel_superclass);
        NSRect nSRect2 = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect2, objc_super2, l2, nSRect);
        return nSRect2;
    }

    long toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(long l, long l2, long l3, long l4, boolean bl) {
        return 0L;
    }

    long toolbarAllowedItemIdentifiers(long l, long l2, long l3) {
        return 0L;
    }

    long toolbarDefaultItemIdentifiers(long l, long l2, long l3) {
        return 0L;
    }

    long toolbarSelectableItemIdentifiers(long l, long l2, long l3) {
        return 0L;
    }

    String tooltipText() {
        return null;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }

    void touchesBeganWithEvent(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void touchesCancelledWithEvent(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void touchesEndedWithEvent(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void touchesMovedWithEvent(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void beginGestureWithEvent(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void endGestureWithEvent(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void magnifyWithEvent(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void rotateWithEvent(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void swipeWithEvent(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    void resetCursorRects(long l, long l2) {
        this.callSuper(l, l2);
    }

    void updateTrackingAreas(long l, long l2) {
        this.callSuper(l, l2);
    }

    long validAttributesForMarkedText(long l, long l2) {
        return 0L;
    }

    void tabView_didSelectTabViewItem(long l, long l2, long l3, long l4) {
    }

    void tabView_willSelectTabViewItem(long l, long l2, long l3, long l4) {
    }

    boolean tableView_writeRowsWithIndexes_toPasteboard(long l, long l2, long l3, long l4, long l5) {
        return false;
    }

    boolean validateMenuItem(long l, long l2, long l3) {
        return true;
    }

    long view_stringForToolTip_point_userData(long l, long l2, long l3, long l4, long l5, long l6) {
        return 0L;
    }

    void viewDidMoveToWindow(long l, long l2) {
    }

    void viewWillMoveToWindow(long l, long l2, long l3) {
    }

    void windowDidMove(long l, long l2, long l3) {
    }

    void windowDidResize(long l, long l2, long l3) {
    }

    void windowDidResignKey(long l, long l2, long l3) {
    }

    void windowDidBecomeKey(long l, long l2, long l3) {
    }

    void windowDidMiniturize(long l, long l2, long l3) {
    }

    void windowDidDeminiturize(long l, long l2, long l3) {
    }

    void windowSendEvent(long l, long l2, long l3) {
        this.callSuper(l, l2, l3);
    }

    boolean windowShouldClose(long l, long l2, long l3) {
        return false;
    }

    void windowWillClose(long l, long l2, long l3) {
    }

    long nextState(long l, long l2) {
        return this.callSuperObject(l, l2);
    }

    void updateOpenGLContext(long l, long l2, long l3) {
    }

    boolean shouldDrawInsertionPoint(long l, long l2) {
        return this.callSuperBoolean(l, l2);
    }

    boolean readSelectionFromPasteboard(long l, long l2, long l3) {
        return false;
    }

    long validRequestorForSendType(long l, long l2, long l3, long l4) {
        return this.callSuperObject(l, l2, l3, l4);
    }

    boolean writeSelectionToPasteboard(long l, long l2, long l3, long l4) {
        return false;
    }
}

