/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.xssf;

import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Sheet {
    private static final String NS = "http://schemas.openxmlformats.org/spreadsheetml/2006/main";
    private String sheetName;
    private Document document;
    private Element sheetElement;

    public String getSheetName() {
        return this.sheetName;
    }

    public Element create(String sheetName) throws ParserConfigurationException {
        this.sheetName = sheetName;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.getDOMImplementation().createDocument(NS, "worksheet", null);
        this.document.setXmlStandalone(true);
        Element rootElement = this.document.getDocumentElement();
        this.sheetElement = this.document.createElementNS(NS, "sheetData");
        rootElement.appendChild(this.sheetElement);
        return this.sheetElement;
    }

    public void build(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        int row = 1;
        while (rs.next()) {
            Element rowElement = this.addRow(this.sheetElement, row);
            for (int i = 1; i <= columnCount; ++i) {
                this.addColumn(rowElement, row, i, rs.getObject(i), meta.getColumnType(i));
            }
            ++row;
        }
    }

    public Element addRow(Element sheetElement, int row) {
        Element element = this.document.createElementNS(NS, "row");
        element.setAttribute("r", Integer.toString(row));
        sheetElement.appendChild(element);
        return element;
    }

    public Element addColumn(Element rowElement, int row, int col, Object value, int type) {
        if (value == null) {
            return null;
        }
        Element colElement = this.document.createElementNS(NS, "c");
        colElement.setAttribute("r", this.calcCellName(row, col));
        if (type == 2) {
            Element vElement = this.document.createElementNS(NS, "v");
            colElement.appendChild(vElement);
            Text text = this.document.createTextNode(value.toString());
            vElement.appendChild(text);
        } else {
            colElement.setAttribute("t", "inlineStr");
            Element isElement = this.document.createElementNS(NS, "is");
            colElement.appendChild(isElement);
            Element tElement = this.document.createElementNS(NS, "t");
            isElement.appendChild(tElement);
            Text text = this.document.createTextNode(value.toString());
            tElement.appendChild(text);
        }
        rowElement.appendChild(colElement);
        return colElement;
    }

    private String calcCellName(int row, int col) {
        String s = Integer.toString(col, 26);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(s.charAt(i) + 65);
        }
        sb.append(row);
        return sb.toString();
    }

    public void write(OutputStream os) throws TransformerConfigurationException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(new DOMSource(this.document), new StreamResult(os));
    }
}

