/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.xml;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.infodb.commons.xml.XmlBuilder;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Transformer {
    private SAXTransformerFactory saxFactory;
    private TransformerHandler saxHandler;
    private ContentHandler currentHandler;

    public static String exec(XmlBuilder builder) throws SAXException {
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer trans = new Transformer();
        trans.setResult(result);
        trans.beginTransform();
        trans.execute(builder);
        trans.endTransform();
        return writer.toString();
    }

    public Transformer() throws SAXException {
        this.init();
        try {
            this.saxHandler = this.saxFactory.newTransformerHandler();
            this.currentHandler = this.saxHandler;
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public Transformer(String xsltFile) throws SAXException {
        this(new StreamSource(xsltFile));
    }

    public Transformer(Document document) throws SAXException {
        this(new DOMSource(document));
    }

    public Transformer(Source source) throws SAXException {
        this.init();
        try {
            this.saxHandler = this.saxFactory.newTransformerHandler(source);
            this.currentHandler = this.saxHandler;
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    private void init() throws SAXException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        if (!transFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            throw new SAXException("Cannot create SAXTransformerFactory!!");
        }
        this.saxFactory = (SAXTransformerFactory)transFactory;
    }

    public void setResult(Result result) {
        this.saxHandler.setResult(result);
    }

    public void addFilter(XMLFilter filter) {
        filter.setContentHandler(this.currentHandler);
        this.currentHandler = (ContentHandler)((Object)filter);
    }

    public void setOutputProperty(String name, String value) {
        this.saxHandler.getTransformer().setOutputProperty(name, value);
    }

    public void setParameter(String name, Object value) {
        this.saxHandler.getTransformer().setParameter(name, value);
    }

    public void beginTransform() throws SAXException {
        this.currentHandler.startDocument();
    }

    public void execute(XmlBuilder builder) throws SAXException {
        builder.buildXml(this.currentHandler);
    }

    public void execute(InputSource xml) throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(this.currentHandler);
        try {
            reader.parse(xml);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void execute(String file) throws SAXException {
        this.execute(new InputSource(file));
    }

    public void endTransform() throws SAXException {
        this.currentHandler.endDocument();
    }

    @Deprecated
    public void transform(XmlBuilder builder) throws SAXException {
        this.currentHandler.startDocument();
        builder.buildXml(this.currentHandler);
        this.currentHandler.endDocument();
    }
}

