/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.infodb.commons.db.JDBCSupport;
import org.infodb.commons.xml.Parser;
import org.infodb.commons.xml.Transformer;
import org.infodb.commons.xml.XmlBuilder;
import org.xml.sax.SAXException;

public class CSVResultSet {
    private ResultSet rs;
    private boolean withHeader = true;
    private boolean withQuotation = false;
    private boolean withHeaderQuotation = false;
    private String separator = ",";
    private Map<String, String> mapFields;
    private Parser parser;

    public CSVResultSet(ResultSet rs, Parser parser) {
        this.rs = rs;
        this.parser = parser;
    }

    public void setWithHeader(boolean b) {
        this.withHeader = b;
    }

    public boolean getWithHeader() {
        return this.withHeader;
    }

    public boolean isWithHeaderQuotation() {
        return this.withHeaderQuotation;
    }

    public void setWithHeaderQuotation(boolean withHeaderQuotation) {
        this.withHeaderQuotation = withHeaderQuotation;
    }

    public boolean isWithQuotation() {
        return this.withQuotation;
    }

    public void setWithQuotation(boolean withQuotation) {
        this.withQuotation = withQuotation;
    }

    public void setFieldsMap(Map<String, String> map) {
        this.mapFields = map;
    }

    public Map<String, String> getFieldsMap() {
        return this.mapFields;
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void output(PrintWriter writer) throws SQLException, SAXException, IOException {
        int i;
        ResultSetMetaData meta = this.rs.getMetaData();
        int count = meta.getColumnCount();
        if (this.withHeader) {
            for (i = 1; i <= count; ++i) {
                if (i != 1) {
                    writer.print(this.separator);
                }
                String colName = meta.getColumnName(i);
                String name = null;
                if (this.mapFields != null) {
                    name = this.mapFields.get(colName);
                }
                if (name == null) {
                    name = colName;
                }
                if (this.withHeaderQuotation) {
                    writer.print('\"');
                }
                writer.print(StringEscapeUtils.escapeCsv((String)name));
                if (!this.withHeaderQuotation) continue;
                writer.print('\"');
            }
            writer.println();
        }
        while (this.rs.next()) {
            for (i = 1; i <= count; ++i) {
                int type;
                if (i != 1) {
                    writer.print(this.separator);
                }
                if ((type = meta.getColumnType(i)) == 2005) {
                    this.parser.reset();
                    Clob clob = this.rs.getClob(i);
                    if (clob == null) continue;
                    this.parser.parse(clob.getCharacterStream());
                    String value = Transformer.exec((XmlBuilder)((Object)this.parser.getRootElement()));
                    if (this.withQuotation) {
                        writer.print('\"');
                    }
                    writer.print(StringEscapeUtils.escapeCsv((String)value));
                    if (!this.withQuotation) continue;
                    writer.print('\"');
                    continue;
                }
                String value = null;
                if (type == 91) {
                    if (!JDBCSupport.isDateFormat()) {
                        value = this.rs.getString(i);
                    } else {
                        Timestamp ts = this.rs.getTimestamp(i);
                        if (ts != null) {
                            value = JDBCSupport.dateFormat(ts);
                        }
                    }
                } else {
                    value = this.rs.getString(i);
                }
                if (value == null) continue;
                value = StringEscapeUtils.unescapeXml((String)value);
                value = StringEscapeUtils.escapeCsv((String)value);
                if (this.withQuotation) {
                    writer.print('\"');
                }
                writer.print(value);
                if (!this.withQuotation) continue;
                writer.print('\"');
            }
            writer.println();
        }
    }

    public void close() throws SQLException {
        this.rs.close();
    }
}

