/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class CSVReader {
    private BufferedReader reader;
    private String[] info;

    public CSVReader() {
    }

    public CSVReader(String fileName) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
    }

    public CSVReader(InputStream is) {
        this.reader = new BufferedReader(new InputStreamReader(is));
    }

    public CSVReader(Reader r) {
        this.reader = new BufferedReader(r);
    }

    public void open(String fileName) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
    }

    public void open(InputStream is) {
        this.reader = new BufferedReader(new InputStreamReader(is));
    }

    public void open(Reader r) {
        this.reader = new BufferedReader(r);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean next() throws IOException {
        String value = this.reader.readLine();
        if (value == null) {
            this.info = null;
            return false;
        }
        this.parse(value);
        return true;
    }

    private void parse(String value) {
        this.info = value.split(",");
        for (int i = 0; i < this.info.length; ++i) {
            if (this.info[i].startsWith("\"") && this.info[i].endsWith("\"")) {
                this.info[i] = this.info[i].substring(1, this.info[i].length() - 1);
                continue;
            }
            if (!this.info[i].startsWith("'") || !this.info[i].endsWith("'")) continue;
            this.info[i] = this.info[i].substring(1, this.info[i].length() - 1);
        }
    }

    public int getColumnCount() {
        if (this.info != null) {
            return this.info.length;
        }
        return -1;
    }

    public String getString(int index) {
        if (this.info != null) {
            return this.info[index];
        }
        throw new NullPointerException("The line data was not read.");
    }

    public int getInt(int index) {
        if (this.info != null) {
            return Integer.parseInt(this.info[index]);
        }
        throw new NullPointerException("The line data was not read.");
    }
}

