/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamResult;
import org.infodb.commons.xml.NamespaceResolver;
import org.infodb.commons.xml.Parser;
import org.infodb.commons.xml.Transformer;
import org.infodb.commons.xml.XmlBuilder;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MetaDataManager {
    private static String NS = "http://infodb.org/ns/metadata";
    private static HashMap<String, HashMap<String, Integer>> mapTables = new HashMap();

    public static int findColumnType(String tableName, String column) {
        HashMap<String, Integer> map = mapTables.get(tableName.toLowerCase());
        if (map == null) {
            return 0;
        }
        Integer type = map.get(column.toLowerCase());
        if (type == null) {
            return 0;
        }
        return type;
    }

    public static void buildDictionary(Connection c, String schemaPattern) throws SQLException {
        mapTables = new HashMap();
        DatabaseMetaData meta = c.getMetaData();
        ResultSet rs = meta.getColumns(null, schemaPattern, "%", "%");
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME").toLowerCase();
            String columnName = rs.getString("COLUMN_NAME").toLowerCase();
            int type = rs.getInt("DATA_TYPE");
            HashMap<String, Integer> map = mapTables.get(tableName);
            if (map == null) {
                map = MetaDataManager.addEntity(tableName);
            }
            MetaDataManager.addProperty(map, columnName, type);
        }
    }

    public static HashMap<String, Integer> addEntity(String tableName) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        mapTables.put(tableName, map);
        return map;
    }

    public static void addProperty(HashMap<String, Integer> map, String propName, Integer value) {
        map.put(propName, value);
    }

    public static void load(String path) throws SAXException, IOException {
        try {
            Parser parser = new Parser();
            parser.setNamespaceResolver(new NamespaceResolver(){

                @Override
                public String getPackageName(String ns) {
                    return "org.infodb.commons.db.meta";
                }
            });
            parser.parse(new FileInputStream(path));
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public static void save(String path) throws SAXException {
        Transformer trans = new Transformer();
        trans.setResult(new StreamResult(path));
        trans.beginTransform();
        trans.execute(new XmlBuilder(){

            @Override
            public void buildXml(ContentHandler saxHandler) throws SAXException {
                AttributesImpl attrs = new AttributesImpl();
                saxHandler.startElement(NS, "metadata", "metadata", attrs);
                for (Map.Entry entrySet : mapTables.entrySet()) {
                    String key = (String)entrySet.getKey();
                    HashMap map = (HashMap)entrySet.getValue();
                    AttributesImpl attrsEntity = new AttributesImpl();
                    attrsEntity.addAttribute("", "name", "name", "CDATA", key);
                    saxHandler.startElement(NS, "entity", "entity", attrsEntity);
                    for (Map.Entry entryInt : map.entrySet()) {
                        String col = (String)entryInt.getKey();
                        Integer type = (Integer)entryInt.getValue();
                        AttributesImpl attrsInfo = new AttributesImpl();
                        attrsInfo.addAttribute("", "name", "name", "CDATA", col);
                        attrsInfo.addAttribute("", "value", "value", "CDATA", type.toString());
                        saxHandler.startElement(NS, "property", "property", attrsInfo);
                        saxHandler.endElement(NS, "property", "property");
                    }
                    saxHandler.endElement(NS, "entity", "entity");
                }
                saxHandler.endElement(NS, "metadata", "metadata");
            }
        });
        trans.endTransform();
    }
}

