#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <stdbool.h>
#include <limits.h>  /* PATH_MAX */

#include "paclist.h"
#include "fbcolors.h"
#include "parseinfo.h"
#include "libparsifal/parsifal.h"  /* SAX */

#define PAC_VERSION_STR_MAX 64

#define PARSING_DATA ((parsing_data*)UserData)
#define SMALLER(x,y) (x<y ? x:y)
#define BIGGER(x,y)  (x>y ? x:y)

int StartElement(void *UserData, const XMLCH *uri, const XMLCH *localName, const XMLCH *qName, LPXMLVECTOR atts);
int EndElement(void *UserData, const XMLCH *uri, const XMLCH *localName, const XMLCH *qName);
int Characters(void *UserData, const XMLCH *Chars, int cbChars);
void ErrorHandler(LPXMLPARSER parser);
int cstream(BYTE *buf, int cBytes, int *cBytesActual, void *inputData);
static void name_trim(char* dest, const char* src, int max);

typedef enum {
	Unknown,
	Name,
	Version,
	Need,
	/* Logic, */ /* not implemented */
} infoElement;

typedef struct {
	infoElement path[INFO_DEPTH_MAX];
	int depth;
	pacinfo *info;
} parsing_data;


const static char *pacdir_path;


int StartElement(void *UserData, const XMLCH *uri, const XMLCH *localName, const XMLCH *qName, LPXMLVECTOR atts)
{
	int *depth = &PARSING_DATA->depth;
	infoElement *path = PARSING_DATA->path;
	/* XMLCH (unsigned char*)  char*(signedunsignedϥƥ¸) ؤΥ㥹 */
	char *arch_qName = (char*)qName;

	if ( *depth == 1 ) {
		if ( strcmp(arch_qName, "Name" ) == 0 ) path[*depth] = Name;
		else if ( strcmp(arch_qName, "Version") == 0 ) path[*depth] = Version;
		else path[*depth] = Unknown;

	} else if ( *depth >= 2 ) {
		if ( strcmp(arch_qName, "Need") == 0 ) {
			if (atts->length) {  /* type="..."pacʳꤵƤ(notpacʤ)Unknownˤ */
				bool notpac = false;
				int i;
				LPXMLRUNTIMEATT att;
				for (i=0; i < atts->length; i++) {  /* ͥ褷breakʤ */
					att = (LPXMLRUNTIMEATT)XMLVector_Get(atts, i);
					/* cast from unsigned char* to char* */
					if ( strncmp((char*)att->qname, "type", BIGGER(strlen((char*)att->qname),strlen("type"))) != 0 )
						continue;
					/* cast from unsigned char* to char* */
					if ( strncmp((char*)att->value, "pac", BIGGER(strlen((char*)att->value),strlen("pac"))) != 0 )
						notpac = true;
					else
						notpac = false;
				}
				if (notpac)
					path[*depth] = Unknown;
				else
					path[*depth] = Need;

			} else {
			       	path[*depth] = Need;
			}

		}
		else path[*depth] = Unknown;

	}

	*depth += 1;

	return XML_OK;
}

int EndElement(void *UserData, const XMLCH *uri, const XMLCH *localName, const XMLCH *qName)
{
	int *depth = &PARSING_DATA->depth;
	*depth -= 1;
	return XML_OK;
}

int Characters(void *UserData, const XMLCH *Chars, int cbChars)
{
	int *depth = &PARSING_DATA->depth;
	infoElement *path = PARSING_DATA->path;
	infoElement parent = path[*depth-1];
	pacinfo *takeout = PARSING_DATA->info;

	switch (parent) {
	case Name:
		/* cast from unsigned char* to char* */
		name_trim(takeout->name, (char*)Chars, cbChars);
		break;

	case Version:
		{
			char buf[PAC_VERSION_STR_MAX + 1];  /* NULLߥ͡ʬ+1 */
			/* ƬζstrtodФΤǡȥߥ */
			/* CharsNULLߥ͡ȤƤʤ */
			/* cast from unsigned char* to char* */
			strncpy(buf, (char*)Chars, SMALLER(cbChars,PAC_VERSION_STR_MAX) );
			buf[ SMALLER(cbChars,PAC_VERSION_STR_MAX) ] = '\0';
			/* strtodѴǽ顼̵ - 顼version=0OK */
			takeout->version = strtod(buf, NULL);
		}
		break;

	case Need:
		takeout->needs[takeout->num_needs] = malloc(sizeof(pac_need));
		/* free()clean_info()ǹԤ */
		if( takeout->needs[takeout->num_needs]->name != NULL) {
			/* cast from unsigned char* to char* */
			name_trim(takeout->needs[takeout->num_needs]->name, (char*)Chars, cbChars);
			takeout->num_needs += 1;
		} else {
			perror("error\n");
		}
		break;

	default:
		break;
	}

	return XML_OK;
}

void ErrorHandler(LPXMLPARSER parser)
{
	printf("Parsing Error: %s\nErrorLine: %d ErrorColumn: %d\n",
			parser->ErrorString, parser->ErrorLine, parser->ErrorColumn);
}

int cstream(BYTE *buf, int cBytes, int *cBytesActual, void *inputData)
{
	*cBytesActual = fread(buf, 1, cBytes, (FILE*)inputData);
	return (*cBytesActual < cBytes);
}


static void name_trim(char* dest, const char* src, int max)
{
	int head, tail;
	for (head=0; head < max; head++) {
		if (src[head] == ' '
		  || src[head] == '\t'
		  || src[head] == '\n'
		  || src[head] == '\r') {
			continue;
		}
		break;
	}
	for (tail=head+1; tail < max; tail++) {
		if (src[tail] == ' '
		  || src[tail] == '\t'
		  || src[tail] == '\n'
		  || src[tail] == '\r') {
			break;
		}
	}
	if ( tail - head > PAC_NAME_MAX) {
		tail = head + PAC_NAME_MAX;
	}
	strncpy(dest, &src[head], tail - head);
	dest[ tail - head ] = '\0';
}




static void parse_infoxml(pac *pac)
{
	LPXMLPARSER parser;
	parsing_data parsing_data;
	char infoxml_path[PATH_MAX+1];
	FILE *infoxml;

	sprintf(infoxml_path, "%s/%s/info.xml", pacdir_path, pac->dirname);
	if ( (infoxml = fopen(infoxml_path,"r")) == NULL ) {
		fprintf(stderr, "%sCan't open %s. This pac is ignored.%s", FB_WARN, infoxml_path, FB_NORMAL);
		goto fatal;
	}

	if ( !XMLParser_Create(&parser) ) {
		fprintf(stderr, "%sCan't create parser for %s. This pac is ignored.%s", FB_WARN, infoxml_path, FB_NORMAL);
		goto fatal;
	}

	parsing_data.info = &pac->info;
	parsing_data.path[0] = Unknown;
	parsing_data.depth = 0;

	parser->errorHandler = ErrorHandler;
	parser->startElementHandler = StartElement;
	parser->endElementHandler = EndElement;
	parser->charactersHandler = Characters;
	parser->UserData = &parsing_data;

	if ( !XMLParser_Parse(parser, cstream, infoxml, 0) ) {
		fprintf(stderr, "%sXML parse error for %s. This pac is ignored.%s", FB_WARN, infoxml_path, FB_NORMAL);
		goto fatal;
	}

	XMLParser_Free(parser);

	fclose(infoxml);

	return;

fatal:
	paclist_delpac(pac);
	return;
}

void parse_pacinfo(pac* cue_last, const char *arg_pacdir_path)
{
	pthread_t *thread;
	int i=0;
	pac *parse_this;
	int num_paclist_without_last;

	pacdir_path = arg_pacdir_path;

	num_paclist_without_last = paclist_count(cue_last) - 1;
	parse_this = cue_last->next;  /* cue_last_LAST */
	thread = malloc(sizeof(pthread_t) * num_paclist_without_last);  /* 쵤malloc()Ƥޤ */
	for (i=0; i < num_paclist_without_last; i++) {
		pthread_create(&thread[i], NULL, (void*)parse_infoxml, (void*)parse_this);
		parse_this = parse_this->next;
	}
	for (i=0; i < num_paclist_without_last; i++) {
		pthread_join(thread[i], NULL);
	}
}

void clean_pacinfo(pac *cue_last)
{
	pac *current = cue_last->next;
	while (current != cue_last) {
		current = current->next;
		for (; current->info.num_needs > 0; current->info.num_needs-- ) {
			free( current->info.needs[ current->info.num_needs - 1 ] );
		}
	}
}

