#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; Lua Library
--@date   Sun,06 Sep,2015
--@date   Sun,20 Sep,2015
--@date   Wed,28 Oct,2015 - Thu,29 Oct,2015
--@date   Sun,22 Nov,2015
--@date   Sun,13 Dec,2015
--@date   Sat,19 Dec,2015
--@date   Sun,27 Dec,2015
--@date   Sun,10 Jan,2016
--@date   Mon,17 Jul,2017
--@date   Tue,15 Aug,2017
--@date   Sun,03 Sep,2017
--@date   Fri,05 Jan,2018
--@date   Sat,14 Apr,2018
--@date   Sat,12 May,2018
--@date   Sat,24 Nov,2018
--@date   Sun,25 Nov,2018
--@date   Sun,02 Dec,2018
--@date   Sun,09 Dec,2018
--@date   Sat,25 Jan,2020
--@date   Sat,18 Apr,2020
--@date   Thu,23 Apr,2020
--@date   Sun,04 Oct,2020
--@date   Sun,11 Oct,2020
--@date   Sat,17 Oct,2020
--@date   Wed,21 Oct,2020
--@date   Tue,08 Mar,2022
--@date   Fri,11 Mar,2022
--@author Copyright(C)2015-2022 G-HAL
--]]



-- Global Variables

define_const("c_ExecQueue_Type_NONE", 1);
define_const("c_ExecQueue_Type_PrepAction", 2);
define_const("c_ExecQueue_Type_PrepActionStopAndGearUp", 3);
define_const("c_ExecQueue_Type_GearUp", 4);
define_const("c_ExecQueue_Type_MoveMode", 5);
define_const("c_ExecQueue_Type_Transformation", 6);
define_const("c_ExecQueue_Type_PurgeParts", 7);
define_const("c_ExecQueue_Type_Repair", 8);
define_const("c_ExecQueue_Type_Eject", 9);

define_const("QRL_Telecommunication_TAG", "QRL_Telecommunication_");



define_global_array("g_QRL_SystemVariable");


define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Reload_Queue_Ptr", 0);
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Reload_Queue_Weapon", {});
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Reload_Queue_Ammo", {});

define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Attack_Mode_AIAttacker", false);
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Attack_Weapon", nil);
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Attack_Target", nil);
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Attack_AtOp", 0);

define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Type", c_ExecQueue_Type_NONE);
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Type_PrepAction", NAV_Stop);
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Type_MoveMode", MM_Walk);
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Type_Transformation", GS_Battroid);
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Type_PurgeParts", 0);
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Type_Repair_Target", nil);
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Type_Repair_Limit", 0);
define_global_array_index(g_QRL_SystemVariable, "ExecQueue_Type_Repair_Skill", 0);

define_global_array_index(g_QRL_SystemVariable, "ExecQueue_WaitAMinute", 0);


define_global_array_index(g_QRL_SystemVariable, "Subroutine", {});
define_global_array_index(g_QRL_SystemVariable, "SubroutinePtr", 0);
define_global_array_index(g_QRL_SystemVariable, "SubroutineStackLimit", 16);

define_global_array_index(g_QRL_SystemVariable, "TransformationListPtr", 0);
define_global_array_index(g_QRL_SystemVariable, "WeaponList", {});
define_global_array_index(g_QRL_SystemVariable, "WeaponListMax", 0);
define_global_array_index(g_QRL_SystemVariable, "WeaponListPtr", 0);
define_global_array_index(g_QRL_SystemVariable, "AmmoList", {});
define_global_array_index(g_QRL_SystemVariable, "AmmoListMax", 0);
define_global_array_index(g_QRL_SystemVariable, "AmmoListPtr", 0);
define_global_array_index(g_QRL_SystemVariable, "TargetMek", nil);
define_global_array_index(g_QRL_SystemVariable, "EnemyMekList", {});
define_global_array_index(g_QRL_SystemVariable, "EnemyMekListMax", 0);
define_global_array_index(g_QRL_SystemVariable, "EnemyMekListPtr", 0);
define_global_array_index(g_QRL_SystemVariable, "FriendMekList", {});
define_global_array_index(g_QRL_SystemVariable, "FriendMekListMax", 0);
define_global_array_index(g_QRL_SystemVariable, "FriendMekListPtr", 0);


define_const("c_Argument_TypeName_Num", "num");
define_const("c_Argument_TypeName_Var", "var");
define_const("c_Variable_Type_Num", 1);
define_const("c_Variable_Type_String", 2);
define_const("c_Variable_Type_GUID", 3);
define_const("c_Variable_Type_Mek", 4);
define_const("c_Variable_Type_Part", 5);
define_const("c_Variable_Type_Module", 6);
define_const("c_Variable_Type_Weapon", 7);
define_const("c_Variable_Type_Ammo", 8);
define_const("c_Variable_TypeName_Num", "NUM");
define_const("c_Variable_TypeName_String", "STRING");
define_const("c_Variable_TypeName_GUID", "GUID");
define_global("g_QRL_UserVariable_Type", {});
define_global("g_QRL_UserVariable_Contents", {});

-- [ End of File ]
