#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language
--@author Copyright(C)2015 G-HAL
--]]

local jit_mode = false;
if jit then
  jit_mode = true;
end;

require "LuaData/global_mod/global_mod";
require "LuaData/stamp";
require "LuaData/asvmacro";
require "LuaData/macro4qrl";
require "LuaData/lib";
require "LuaData/locale";
require "LuaData/aibrain";
define_global("A_Star", nil);
A_Star = require "LuaData/a_star";
require "LuaData/lib4qrl";

define_global("lua_bit", nil);
if package.loaded["bit"] then
  lua_bit = require 'bit';
elseif package.loaded["bit32"] then
  lua_bit = require 'bit32';
end;

define_const("Version_I18N_LuaContainer", "Heart 2022030801");



-- Debugger Function

local enable_debugger = false;
define_global("dbg");
if not jit_mode then
  dbg = require "LuaData/debugger/debugger";
  dbg.auto_where = false;
end;

function call_debugger(flag)
  if jit_mode then
  else
    if (0 == flag) then
      enable_debugger = false;
      dbg.auto_where = false;
    else
      enable_debugger = true;
      dbg.auto_where = 2;
    end;
  end;
  return;
end;



--- Chip Arrangement

