#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,10 Jan,2016
--@date   Sun,23 Jul,2017
--@date   Mon,14 Aug,2017
--@date   Fri,18 Aug,2017
--@date   Sun,03 Sep,2017
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sun,20 Jan,2019
--@date   Fri,01 Feb,2019
--@date   Sat,16 Feb,2019
--@date   Tue,28 Apr,2020
--@date   Sun,13 Sep,2020
--@date   Sun,08 Nov,2020
--@date   Sat,30 Oct,2021
--@date   Sat,19 Feb,2022
--@date   Sun,06 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@author Copyright(C)2016-2023 G-HAL
--]]

-- ##begin##
-- name : MUL
-- size : 6 , 1
-- footprint :
-- ######
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010013
-- argument : 3
-- argument_comment[1] : Result
-- argument[1] : var
-- argument_tag[1] : ##111##
-- argument_type[1] : var
-- argument_geometry[1] : x:16 , y:16 , w:123 , h:31
-- argument_comment[2] : Left Parameter
-- argument[2] : var
-- argument_tag[2] : ##121##
-- argument_tag_raw[2] : ##122##
-- argument_type[2] : var-num
-- argument_type_selected[2] : ##123##
-- argument_geometry[2] : x:161 , y:16 , w:123 , h:31
-- argument_comment[3] : Right Parameter
-- argument[3] : 1
-- argument_tag[3] : ##131##
-- argument_tag_raw[3] : ##132##
-- argument_type[3] : var-num
-- argument_type_selected[3] : ##133##
-- argument_geometry[3] : x:307 , y:16 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:MUL');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;

  local argument_2_is_num = false;
  if (c_Argument_TypeName_Num == "##123##") then
    argument_2_is_num = true;
  elseif ((c_Argument_TypeName_Var == "##123##") and (c_Variable_Type_Num == g_QRL_UserVariable_Type["##122##"])) then
    argument_2_is_num = true;
  end;
  local argument_3_is_num = false;
  if (c_Argument_TypeName_Num == "##133##") then
    argument_3_is_num = true;
  elseif ((c_Argument_TypeName_Var == "##133##") and (c_Variable_Type_Num == g_QRL_UserVariable_Type["##132##"])) then
    argument_3_is_num = true;
  end;

  if (argument_2_is_num and argument_3_is_num) then
    g_QRL_UserVariable_Type["##111##"] = c_Variable_Type_Num;
    g_QRL_UserVariable_Contents["##111##"] = ##121## * ##131##;
  else
    PrintErrorMessage(GB, Mek, '##010##:##011##:MUL:Argument(s) type mismatch.');
  end;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
