#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,04 Oct,2020
--@date   Sat,30 Oct,2021
--@date   Sun,06 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2020-2023 G-HAL
--]]

-- ##begin##
-- name : Search a Mek by Name
-- size : 6 , 1
-- footprint :
-- ######
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010013
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010013
-- argument : 2
-- argument_comment[1] : Mek
-- argument[1] : mek
-- argument_tag[1] : ##111##
-- argument_type[1] : var
-- argument_geometry[1] : x:16 , y:16 , w:123 , h:31
-- argument_comment[2] : Name
-- argument[2] : var
-- argument_tag[2] : ##121##
-- argument_type[2] : var
-- argument_geometry[2] : x:326 , y:16 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Search_a_Mek_by_Name');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  if (c_Variable_Type_String ~= g_QRL_UserVariable_Type["##121##"]) then
    PrintErrorMessage(GB, Mek, '##010##:##011##:Search_a_Mek_by_Name:No name is selected.');
    return '##021##';
  end;

  if (nil ~= g_QRL_UserVariable_Contents["##121##"]) then
    g_QRL_UserVariable_Type["##111##"] = c_Variable_Type_Mek;
    g_QRL_UserVariable_Contents["##111##"] = SeekGearByPilotName(GB_Meks(GB), g_QRL_UserVariable_Contents["##121##"]);
    return '##021##';
  end;
  g_QRL_UserVariable_Type["##111##"] = nil;
  g_QRL_UserVariable_Contents["##111##"] = nil;
  return '##031##';
end;

-- ##end##
-- [ End of File ]
