#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,20 Jan,2019
--@date   Fri,01 Feb,2019
--@date   Sat,16 Feb,2019
--@date   Tue,28 Apr,2020
--@date   Tue,15 Sep,2020
--@date   Sat,30 Oct,2021
--@date   Sat,19 Feb,2022
--@date   Sun,06 Mar,2022
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2019-2023 G-HAL
--]]

-- ##begin##
-- name : Get Friend List with Dir and Range
-- size : 5 , 3
-- footprint :
-- #####
-- #####
-- #####
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010033
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010033
-- argument : 4
-- argument_comment[1] : Direction From
-- argument[1] : -45
-- argument_tag[1] : ##111##
-- argument_tag_raw[1] : ##112##
-- argument_type[1] : var-num
-- argument_type_selected[1] : ##113##
-- argument_geometry[1] : x:85 , y:117 , w:123 , h:31
-- argument_comment[2] : Direction To
-- argument[2] : 45
-- argument_tag[2] : ##121##
-- argument_tag_raw[2] : ##122##
-- argument_type[2] : var-num
-- argument_type_selected[2] : ##123##
-- argument_geometry[2] : x:234 , y:117 , w:123 , h:31
-- argument_comment[3] : Range From
-- argument[3] : 0
-- argument_tag[3] : ##131##
-- argument_tag_raw[3] : ##132##
-- argument_type[3] : var-num
-- argument_type_selected[3] : ##133##
-- argument_geometry[3] : x:85 , y:165 , w:123 , h:31
-- argument_comment[4] : Range To
-- argument[4] : 100
-- argument_tag[4] : ##141##
-- argument_tag_raw[4] : ##142##
-- argument_type[4] : var-num
-- argument_type_selected[4] : ##143##
-- argument_geometry[4] : x:234 , y:165 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Get_Friend_List_with_Dir_and_Range');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  g_QRL_SystemVariable["FriendMekListMax"] = 0;

  local argument_1_is_num = false;
  if (c_Argument_TypeName_Num == "##113##") then
    argument_1_is_num = true;
  elseif ((c_Argument_TypeName_Var == "##113##") and (c_Variable_Type_Num == g_QRL_UserVariable_Type["##112##"])) then
    argument_1_is_num = true;
  end;
  local argument_2_is_num = false;
  if (c_Argument_TypeName_Num == "##123##") then
    argument_2_is_num = true;
  elseif ((c_Argument_TypeName_Var == "##123##") and (c_Variable_Type_Num == g_QRL_UserVariable_Type["##122##"])) then
    argument_2_is_num = true;
  end;
  local argument_3_is_num = false;
  if (c_Argument_TypeName_Num == "##133##") then
    argument_3_is_num = true;
  elseif ((c_Argument_TypeName_Var == "##133##") and (c_Variable_Type_Num == g_QRL_UserVariable_Type["##132##"])) then
    argument_3_is_num = true;
  end;
  local argument_4_is_num = false;
  if (c_Argument_TypeName_Num == "##143##") then
    argument_4_is_num = true;
  elseif ((c_Argument_TypeName_Var == "##143##") and (c_Variable_Type_Num == g_QRL_UserVariable_Type["##142##"])) then
    argument_4_is_num = true;
  end;
  if (argument_1_is_num and argument_2_is_num and argument_3_is_num and argument_4_is_num) then
  else
    PrintErrorMessage(GB, Mek, '##010##:##011##:Get_Friend_List_with_Dir_and_Range:Argument(s) type mismatch.');
    g_QRL_SystemVariable["FriendMekListPtr"] = 0;
    return '##031##';
  end;

  local TL = GB_Meks(GB);

  while (nil ~= TL) do
    if (NotDestroyed(TL) and GearActive(TL) and MekCanSeeTarget(GB, Mek, TL) and OnTheMap_Mek(TL)) then
      if not(AreEnemies_MM(GB, Mek, TL)) then

        local t_x, t_y, t_z = GearCurrentLocation(TL);
        local m_x, m_y, m_z = GearCurrentLocation(Mek);
        local x_rel = (t_x - m_x);
        local y_rel = (t_y - m_y);
        local z_rel = (t_z - m_z);
        local current_dir = Mek_NAttValue_Location(Mek, NAS_D);

        local hit = true;

        local dir = relpos2dir(x_rel, y_rel, z_rel, current_dir);
        if (##111## < ##121##) then
          if ((##111## <= dir) and (dir <= ##121##)) then
          else
            hit = false;
          end;
        else
          if ((##121## <= dir) or (dir <= ##111##)) then
          else
            hit = false;
          end;
        end;

        local rng = Range_MM(GB, Mek, TL);
        if ((##131## <= rng) and (rng <= ##141##)) then
        else
          hit = false;
        end;

        if (hit) then
          g_QRL_SystemVariable["FriendMekListMax"] = g_QRL_SystemVariable["FriendMekListMax"] + 1;
          g_QRL_SystemVariable["FriendMekList"][g_QRL_SystemVariable["FriendMekListMax"]] = TL;
        end;
      end;
    end;
    TL = Mek_Next(TL);
  end;

  g_QRL_SystemVariable["FriendMekListPtr"] = 0;
  if (0 == g_QRL_SystemVariable["FriendMekListMax"]) then
    return '##031##';
  end;

  g_QRL_SystemVariable["FriendMekListPtr"] = 1;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
