#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Fri,05 Jan,2018
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sat,16 Feb,2019
--@date   Tue,28 Apr,2020
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@author Copyright(C)2018-2022 G-HAL
--]]

-- ##begin##
-- name : Get Friend List
-- size : 3 , 1
-- footprint :
-- ###
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010013
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010013
-- argument : 0
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Get_Friend_List');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  g_QRL_SystemVariable["FriendMekListMax"] = 0;

  local TL = GB_Meks(GB);

  while (nil ~= TL) do
    if (NotDestroyed(TL) and GearActive(TL) and MekCanSeeTarget(GB, Mek, TL) and OnTheMap_Mek(TL)) then
      if not(AreEnemies_MM(GB, Mek, TL)) then
        g_QRL_SystemVariable["FriendMekListMax"] = g_QRL_SystemVariable["FriendMekListMax"] + 1;
        g_QRL_SystemVariable["FriendMekList"][g_QRL_SystemVariable["FriendMekListMax"]] = TL;
      end;
    end;
    TL = Mek_Next(TL);
  end;

  g_QRL_SystemVariable["FriendMekListPtr"] = 0;
  if (0 == g_QRL_SystemVariable["FriendMekListMax"]) then
    return '##031##';
  end;

  g_QRL_SystemVariable["FriendMekListPtr"] = 1;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
