#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sat,10 Jul,2021
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2020-2023 G-HAL
--]]

-- ##begin##
-- name : Search and Narrow Down the List of Enemy
-- size : 3 , 2
-- footprint :
-- ###
-- ###
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0020023
-- argument : 1
-- argument_comment[1] : Condition
-- argument[1] : ALL
-- argument_tag[1] : ##111##
-- argument_type[1] : list
-- argument_list[1] : ALL , Near , Far , MaxDmg , MinDmg
-- argument_geometry[1] : x:16 , y:81 , w:194 , h:46
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Search_and_Narrow_Down_the_List_of_Enemy');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;


  local switch = {};
  local new_g_QRL_SystemVariable["EnemyMekListMax"] = 0;
  local new_g_QRL_SystemVariable["EnemyMekList"] = {};


  local function SearchEnemyMeks_ZeroPass()
    new_g_QRL_SystemVariable["EnemyMekListMax"] = g_QRL_SystemVariable["EnemyMekListMax"];
    new_g_QRL_SystemVariable["EnemyMekList"] = g_QRL_SystemVariable["EnemyMekList"];
    return;
  end;


  local function SearchEnemyMeks_TwoPass()
    local i;
    local RefV = 0;
    for i = 1, g_QRL_SystemVariable["EnemyMekListMax"] do
      local Part = g_QRL_SystemVariable["EnemyMekList"][i];
      local ret, V = (switch["##111##"].func2)(Part, RefV);
      if ret then
        RefV = V;
      end;
    end;
    for i = 1, g_QRL_SystemVariable["EnemyMekListMax"] do
      local Part = g_QRL_SystemVariable["EnemyMekList"][i];
      local ret, V = (switch["##111##"].func2)(Part, RefV);
      if ret then
        new_g_QRL_SystemVariable["EnemyMekListMax"] = new_g_QRL_SystemVariable["EnemyMekListMax"] + 1;
        new_g_QRL_SystemVariable["EnemyMekList"][new_g_QRL_SystemVariable["EnemyMekListMax"]] = Part;
      end;
    end;
    return;
  end;

  local function SearchEnemyMeks_TwoPass_Near(Part, RefV)
    local V = Range_MM(GB, Mek, Part);
    if (V <= RefV) then
      return true, V;
    end;
    return false, 0;
  end;

  local function SearchEnemyMeks_TwoPass_Far(Part, RefV)
    local V = Range_MM(GB, Mek, Part);
    if (RefV <= V) then
      return true, V;
    end;
    return false, 0;
  end;

  local function SearchEnemyMeks_TwoPass_MaxDmg(Part, RefV)
    local V = PercentDamaged(Part);
    if (V <= RefV) then
      return true, V;
    end;
    return false, 0;
  end;

  local function SearchEnemyMeks_TwoPass_MinDmg(Part, RefV)
    local V = PercentDamaged(Part);
    if (RefV <= V) then
      return true, V;
    end;
    return false, 0;
  end;


  switch = {
    ["ALL"]    = { func1 = function() SearchEnemyMeks_ZeroPass(); end, func2 = function() return SearchEnemyMeks_ZeroPass(); end; },
    ["Near"]   = { func1 = function() SearchEnemyMeks_TwoPass(); end, func2 = function(Part, RefV) return SearchEnemyMeks_TwoPass_Near(Part, RefV); end; },
    ["Far"]    = { func1 = function() SearchEnemyMeks_TwoPass(); end, func2 = function(Part, RefV) return SearchEnemyMeks_TwoPass_Far(Part, RefV); end; },
    ["MaxDmg"] = { func1 = function() SearchEnemyMeks_TwoPass(); end, func2 = function(Part, RefV) return SearchEnemyMeks_TwoPass_MaxDmg(Part, RefV); end; },
    ["MinDmg"] = { func1 = function() SearchEnemyMeks_TwoPass(); end, func2 = function(Part, RefV) return SearchEnemyMeks_TwoPass_MinDmg(Part, RefV); end; },
  };
  (switch["##111##"].func1)();


  if (0 == new_g_QRL_SystemVariable["EnemyMekListMax"]) then
    return '##031##';
  end;

  g_QRL_SystemVariable["EnemyMekListMax"] = new_g_QRL_SystemVariable["EnemyMekListMax"];
  g_QRL_SystemVariable["EnemyMekList"] = new_g_QRL_SystemVariable["EnemyMekList"];
  g_QRL_SystemVariable["EnemyMekListPtr"] = 1;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
