#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,25 Oct,2020
--@date   Sat,30 Oct,2021
--@date   Sun,06 Mar,2022
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@author Copyright(C)2020-2023 G-HAL
--]]

-- ##begin##
-- name : Get Ammo List
-- size : 3 , 2
-- footprint :
-- ###
-- ###
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010023
-- argument : 1
-- argument_comment[1] : Weapon
-- argument[1] : wep
-- argument_tag[1] : ##111##
-- argument_type[1] : var
-- argument_geometry[1] : x:50 , y:81 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Get_Ammo_List');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  g_QRL_SystemVariable["AmmoListMax"] = 0;
  if (c_Variable_Type_Weapon ~= g_QRL_UserVariable_Type["##111##"]) then
    PrintErrorMessage(GB, Mek, '##010##:##011##:Get_Ammo_List:No weapon is selected.');
    return '##031##';
  end;
  if Destroyed(g_QRL_UserVariable_Contents["##111##"]) then
    return '##031##';
  end;

  local function SeekAmmo(Part)
    local Weapon = g_QRL_UserVariable_Contents["##111##"];
    while (nil ~= Part) do
      if NotDestroyed(Part) then
        if (GG_Ammo == Mek_G(Part)) and (IsInvCom(Part)) then
          if GoodAmmo(Weapon, Part) then
            g_QRL_SystemVariable["AmmoListMax"] = g_QRL_SystemVariable["AmmoListMax"] + 1;
            g_QRL_SystemVariable["AmmoList"][g_QRL_SystemVariable["AmmoListMax"]] = Part;
          end;
        end;
        SeekAmmo(Mek_SubCom(Part));
        SeekAmmo(Mek_InvCom(Part));
      end;
      Part = Mek_Next(Part);
    end;
    return;
  end;

  SeekAmmo(Mek_SubCom(Mek));
  SeekAmmo(Mek_InvCom(Mek));

  g_QRL_SystemVariable["AmmoListPtr"] = 0;
  if (0 == g_QRL_SystemVariable["AmmoListMax"]) then
    return '##031##';
  end;

  g_QRL_SystemVariable["AmmoListPtr"] = 1;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
