#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sat,16 Mar,2019
--@date   Tue,28 Apr,2020
--@date   Sun,13 Jun,2021
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2019-2023 G-HAL
--]]

-- ##begin##
-- name : Search and Narrow Down the List of Weapons
-- size : 3 , 2
-- footprint :
-- ###
-- ###
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0020023
-- argument : 1
-- argument_comment[1] : Condition
-- argument[1] : ALL
-- argument_tag[1] : ##111##
-- argument_type[1] : list
-- argument_list[1] : ALL , Melee , EMelee , Ballistic , BeamGun , Missile , Grenade , Arm , Leg , Tail , MaxRange , MinRange , MaxDC , MinDC , MaxAmmo , MinAmmo
-- argument_geometry[1] : x:16 , y:81 , w:194 , h:46
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Search_and_Narrow_Down_the_List_of_Weapons');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;


  local switch = {};
  local new_g_QRL_SystemVariable["WeaponListMax"] = 0;
  local new_g_QRL_SystemVariable["WeaponList"] = {};


  local function SearchWeapons_ZeroPass()
    new_g_QRL_SystemVariable["WeaponListMax"] = g_QRL_SystemVariable["WeaponListMax"];
    new_g_QRL_SystemVariable["WeaponList"] = g_QRL_SystemVariable["WeaponList"];
    return;
  end;


  local function SearchWeapons_OnePass()
    local i;
    for i = 1, g_QRL_SystemVariable["WeaponListMax"] do
      local Part = g_QRL_SystemVariable["WeaponList"][i];
      if ((switch["##111##"].func2)(Part)) then
        new_g_QRL_SystemVariable["WeaponListMax"] = new_g_QRL_SystemVariable["WeaponListMax"] + 1;
        new_g_QRL_SystemVariable["WeaponList"][new_g_QRL_SystemVariable["WeaponListMax"]] = Part;
      end;
    end;
    return;
  end;

  local function SearchWeapons_OnePass_GG_GS(Part, GG, GS)
    if ((GG == Mek_G(Part)) and (GS == Mek_S(Part))) then
      return true;
    end;
    return false;
  end;


  local function SearchWeapons_TwoPass()
    local i;
    local RefV = 0;
    for i = 1, g_QRL_SystemVariable["WeaponListMax"] do
      local Part = g_QRL_SystemVariable["WeaponList"][i];
      local ret, V = (switch["##111##"].func2)(Part, RefV);
      if ret then
        RefV = V;
      end;
    end;
    for i = 1, g_QRL_SystemVariable["WeaponListMax"] do
      local Part = g_QRL_SystemVariable["WeaponList"][i];
      local ret, V = (switch["##111##"].func2)(Part, RefV);
      if ret then
        new_g_QRL_SystemVariable["WeaponListMax"] = new_g_QRL_SystemVariable["WeaponListMax"] + 1;
        new_g_QRL_SystemVariable["WeaponList"][new_g_QRL_SystemVariable["WeaponListMax"]] = Part;
      end;
    end;
    return;
  end;

  local function SearchWeapons_TwoPass_MaxRange(Part, RefV)
    local V = WeaponRange(GB, Part);
    if (RefV <= V) then
      return true, V;
    end;
    return false, 0;
  end;

  local function SearchWeapons_TwoPass_MinRange(Part, RefV)
    local V = WeaponRange(GB, Part);
    if (V <= RefV) then
      return true, V;
    end;
    return false, 0;
  end;

  local function SearchWeapons_TwoPass_MaxDC(Part, RefV)
    local V = WeaponDC(Part, 0);
    if (RefV <= V) then
      return true, V;
    end;
    return false, 0;
  end;

  local function SearchWeapons_TwoPass_MinDC(Part, RefV)
    local V = WeaponDC(Part, 0);
    if (V <= RefV) then
      return true, V;
    end;
    return false, 0;
  end;

  local function SearchWeapons_TwoPass_MaxAmmo(Part, RefV)
    local n = NeedAmmo(Part);
    if not n then
      return true, 0;
    end;
    local p = AmmoPresent(Part);
    local s = AmmoSpent(Part);
    local V = (p - s);
    if (RefV <= V) then
      return true, V;
    end;
    return false, 0;
  end;

  local function SearchWeapons_TwoPass_MinAmmo(Part, RefV)
    local n = NeedAmmo(Part);
    if not n then
      return false, 0;
    end;
    local p = AmmoPresent(Part);
    local s = AmmoSpent(Part);
    local V = (p - s);
    if (V <= RefV) then
      return true, V;
    end;
    return false, 0;
  end;


  switch = {
    ["ALL"]       = { func1 = function() SearchWeapons_ZeroPass(); end, func2 = function() return SearchWeapons_ZeroPass(); end; },
    ["Melee"]     = { func1 = function() SearchWeapons_OnePass(); end, func2 = function(Part) return SearchWeapons_OnePass_GG_GS(Part, GG_Weapon, GS_Melee    ); end; },
    ["EMelee"]    = { func1 = function() SearchWeapons_OnePass(); end, func2 = function(Part) return SearchWeapons_OnePass_GG_GS(Part, GG_Weapon, GS_EMelee   ); end; },
    ["Ballistic"] = { func1 = function() SearchWeapons_OnePass(); end, func2 = function(Part) return SearchWeapons_OnePass_GG_GS(Part, GG_Weapon, GS_Ballistic); end; },
    ["BeamGun"]   = { func1 = function() SearchWeapons_OnePass(); end, func2 = function(Part) return SearchWeapons_OnePass_GG_GS(Part, GG_Weapon, GS_BeamGun  ); end; },
    ["Missile"]   = { func1 = function() SearchWeapons_OnePass(); end, func2 = function(Part) return SearchWeapons_OnePass_GG_GS(Part, GG_Weapon, GS_Missile  ); end; },
    ["Grenade"]   = { func1 = function() SearchWeapons_OnePass(); end, func2 = function(Part) return SearchWeapons_OnePass_GG_GS(Part, GG_Ammo,   GS_Grenade  ); end; },
    ["Arm"]       = { func1 = function() SearchWeapons_OnePass(); end, func2 = function(Part) return SearchWeapons_OnePass_GG_GS(Part, GG_Module, GS_Arm      ); end; },
    ["Leg"]       = { func1 = function() SearchWeapons_OnePass(); end, func2 = function(Part) return SearchWeapons_OnePass_GG_GS(Part, GG_Module, GS_Leg      ); end; },
    ["Tail"]      = { func1 = function() SearchWeapons_OnePass(); end, func2 = function(Part) return SearchWeapons_OnePass_GG_GS(Part, GG_Module, GS_Tail     ); end; },
    ["MaxRange"]  = { func1 = function() SearchWeapons_TwoPass(); end, func2 = function(Part, RefV) return SearchWeapons_TwoPass_MaxRange(Part, RefV); end; },
    ["MinRange"]  = { func1 = function() SearchWeapons_TwoPass(); end, func2 = function(Part, RefV) return SearchWeapons_TwoPass_MinRange(Part, RefV); end; },
    ["MaxDC"]     = { func1 = function() SearchWeapons_TwoPass(); end, func2 = function(Part, RefV) return SearchWeapons_TwoPass_MaxDC(Part, RefV); end; },
    ["MinDC"]     = { func1 = function() SearchWeapons_TwoPass(); end, func2 = function(Part, RefV) return SearchWeapons_TwoPass_MinDC(Part, RefV); end; },
    ["MaxAmmo"]   = { func1 = function() SearchWeapons_TwoPass(); end, func2 = function(Part, RefV) return SearchWeapons_TwoPass_MaxAmmo(Part, RefV); end; },
    ["MinAmmo"]   = { func1 = function() SearchWeapons_TwoPass(); end, func2 = function(Part, RefV) return SearchWeapons_TwoPass_MinAmmo(Part, RefV); end; },
  };
  (switch["##111##"].func1)();


  if (0 == new_g_QRL_SystemVariable["WeaponListMax"]) then
    return '##031##';
  end;

  g_QRL_SystemVariable["WeaponListMax"] = new_g_QRL_SystemVariable["WeaponListMax"];
  g_QRL_SystemVariable["WeaponList"] = new_g_QRL_SystemVariable["WeaponList"];
  g_QRL_SystemVariable["WeaponListPtr"] = 1;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
