#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sat,19 Dec,2015
--@date   Fri,18 Aug,2017
--@date   Sun,03 Sep,2017
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sat,16 Feb,2019
--@date   Tue,28 Apr,2020
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@author Copyright(C)2015-2022 G-HAL
--]]

-- ##begin##
-- name : Get Weapon List
-- size : 3 , 1
-- footprint :
-- ###
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010013
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010013
-- argument : 0
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Get_Weapon_List');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  g_QRL_SystemVariable["WeaponListMax"] = 0;

  local function SeekWeapon(Part)
    while (nil ~= Part) do
      if (GG_Module == Mek_G(Part)) or (GG_Weapon == Mek_G(Part)) then
        if ReadyToFire(GB, Mek, Part, false, false, false) then
          g_QRL_SystemVariable["WeaponListMax"] = g_QRL_SystemVariable["WeaponListMax"] + 1;
          g_QRL_SystemVariable["WeaponList"][g_QRL_SystemVariable["WeaponListMax"]] = Part;
        end;
      end;
      SeekWeapon(Mek_SubCom(Part));
      SeekWeapon(Mek_InvCom(Part));
      Part = Mek_Next(Part);
    end;
    return;
  end;

  SeekWeapon(Mek_SubCom(Mek));
  SeekWeapon(Mek_InvCom(Mek));

  g_QRL_SystemVariable["WeaponListPtr"] = 0;
  if (0 == g_QRL_SystemVariable["WeaponListMax"]) then
    return '##031##';
  end;

  g_QRL_SystemVariable["WeaponListPtr"] = 1;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
