#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,22 Nov,2015
--@date   Sat,19 Dec,2015
--@date   Fri,18 Aug,2017
--@date   Sun,03 Sep,2017
--@date   Wed,03 Jan,2018
--@date   Sat,23 Jun,2018
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sat,16 Feb,2019
--@date   Tue,28 Apr,2020
--@date   Sat,19 Sep,2020
--@date   Sat,30 Oct,2021
--@date   Sun,06 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2015-2023 G-HAL
--]]

-- ##begin##
-- name : Seek Far Weapon
-- size : 4 , 3
-- footprint :
-- ####
-- ####
-- ####
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010033
-- next_address_condition_false_coordinates_tag : ##030##
-- next_address_condition_false_tag : ##031##
-- next_address_condition_false : 0010033
-- argument : 1
-- argument_comment[1] : Weapon
-- argument[1] : wep
-- argument_tag[1] : ##111##
-- argument_type[1] : var
-- argument_geometry[1] : x:50 , y:161 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Seek_Far_Weapon');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;
  local Weapon = nil;

  local function SeekFarWeapon(Part)
    while (nil ~= Part) do
      if (GG_Module == Mek_G(Part)) or (GG_Weapon == Mek_G(Part)) then
        if ReadyToFire(GB, Mek, Part, true, true, true) then
          if (nil == Weapon) then
            Weapon = Part;
          elseif WeaponRange(GB, Weapon) < WeaponRange(GB, Part) then
            Weapon = Part;
          end;
        end;
      end;
      SeekFarWeapon(Mek_SubCom(Part));
      SeekFarWeapon(Mek_InvCom(Part));
      Part = Mek_Next(Part);
    end;
    return;
  end;

  SeekFarWeapon(Mek_SubCom(Mek));
  SeekFarWeapon(Mek_InvCom(Mek));

  if (nil == Weapon) then
    g_QRL_UserVariable_Type["##111##"] = nil;
    g_QRL_UserVariable_Contents["##111##"] = nil;
    return '##031##';
  end;
  g_QRL_UserVariable_Type["##111##"] = c_Variable_Type_Weapon;
  g_QRL_UserVariable_Contents["##111##"] = Weapon;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
