#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sun,08 Nov,2020
--@date   Sat,30 Oct,2021
--@date   Sun,06 Mar,2022
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Mon,26 Jun,2023
--@author Copyright(C)2020-2023 G-HAL
--]]

-- ##begin##
-- name : Transformation
-- size : 2 , 2
-- footprint :
-- ##
-- ##
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- argument : 1
-- argument_comment[1] : Transform
-- argument[1] : form
-- argument_tag[1] : ##111##
-- argument_type[1] : var
-- argument_geometry[1] : x:10 , y:102 , w:123 , h:31
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Transformation');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;

  if (c_Variable_Type_Num == g_QRL_UserVariable_Type["##111##"]) then
    g_QRL_SystemVariable["ExecQueue_Type"]                = c_ExecQueue_Type_Transformation;
    g_QRL_SystemVariable["ExecQueue_Type_Transformation"] = g_QRL_UserVariable_Contents["##111##"];
  else
    PrintErrorMessage(GB, Mek, '##010##:##011##:Transformation:Argument type mismatch.');
  end;
  return '##021##';
end;

-- ##end##
-- [ End of File ]
