#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; LuaChip
--@date   Sat,17 Nov,2018
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sun,20 Jan,2019
--@date   Sat,16 Feb,2019
--@date   Sat,16 Mar,2019
--@date   Sat,18 Apr,2020
--@date   Tue,28 Apr,2020
--@date   Sat,30 Oct,2021
--@date   Fri,11 Mar,2022
--@date   Mon,09 Jan,2023
--@date   Sat,24 Jun,2023
--@date   Mon,26 Jun,2023
--@date   Tue,27 Jun,2023
--@author Copyright(C)2018-2023 G-HAL
--]]

-- ##begin##
-- name : Move Mode by Condition
-- size : 3 , 2
-- footprint :
-- ###
-- ###
-- address :
-- chip_coordinates_tag : ##010##
-- chip_number_tag : ##011##
-- chip_number : 
-- chip_footprint_tag : ##012##
-- next_address_condition_true_coordinates_tag : ##020##
-- next_address_condition_true_tag : ##021##
-- next_address_condition_true : 0010023
-- argument : 1
-- argument_comment[1] : Move Mode
-- argument[1] : Fastest
-- argument_tag[1] : ##111##
-- argument_type[1] : list
-- argument_list[1] : Fastest
-- argument_geometry[1] : x:16 , y:81 , w:194 , h:46
-- ##body##

function qrl_chip##011##(Mek, GB)
  PrintTraceMessage(GB, Mek, '##010##:##011##:Move_Mode_by_Condition');
  PrintTracer(GB, Mek, '##012##');
  if enable_debugger then
    dbg();
  end;

  local function SelectMoveMode_Fastest(Mek, GB)
    local T;
    local MM = 0;
    local MaxSpeed = 0;
    for T = 1, NumMoveMode, 1 do
      if (MaxSpeed < BaseMoveRate_withMode(Mek, T)) and MoveLegal_withMode(Mek, T, NAV_NormSpeed, GB_ComTime(GB)) then
        if not ((nil ~= GB) and (Mek_Scale(Mek) < GB_Scale(GB)) and (MM_Fly == T) and (0 < JumpTime(Mek))) then
          MM = T;
          MaxSpeed = BaseMoveRate_withMode(Mek, T);
        end;
      end;
    end;
    if (0 ~= MM) then
      g_QRL_SystemVariable["ExecQueue_Type"]          = c_ExecQueue_Type_MoveMode;
      g_QRL_SystemVariable["ExecQueue_Type_MoveMode"] = MM;
    end;
    return;
  end;

  local switch = {
    ["Fastest"] = function(Mek, GB) SelectMoveMode_Fastest(Mek, GB); end;
  };
  (switch["##111##"])(Mek, GB);

  return '##021##';
end;

-- ##end##
-- [ End of File ]
