/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.foldermenu;

import gen.core.filters.Files;
import gen.core.filters.Filter;
import gen.core.filters.Filters;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.util.Language;

public class FilterHelper {
    public static File getTargetFile(String filename) {
        try {
            ProjectProperties props = Core.getProject().getProjectProperties();
            String sourcedir = props.getSourceRoot();
            String targetdir = props.getTargetRoot();
            FilterMaster fm = Core.getFilterMaster();
            FilterContext fc = new FilterContext(props);
            LookupInformation lookup = FilterHelper.lookupFilter(sourcedir + File.separator + filename, fc, fm.getConfig());
            if (lookup == null) {
                return null;
            }
            File inFile = new File(sourcedir + File.separator + filename);
            String name = inFile.getName();
            String path = filename.substring(0, filename.length() - name.length());
            File outFile = new File(targetdir + File.separator + path + File.separator + FilterHelper.constructTargetFilename(lookup.outFilesInfo.getSourceFilenameMask(), name, lookup.outFilesInfo.getTargetFilenamePattern(), fc.getTargetLang(), lookup.outFilesInfo.getSourceEncoding(), lookup.outFilesInfo.getTargetEncoding(), lookup.filterObject.getFileFormatName()));
            return outFile;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static LookupInformation lookupFilter(String filename, FilterContext fc, Filters filters) throws TranslationException, IOException {
        File inFile = new File(filename);
        String name = inFile.getName();
        String path = inFile.getParent();
        if (path == null) {
            path = "";
        }
        block0: for (Filter f : filters.getFilters()) {
            if (!f.isEnabled()) continue;
            for (Files ff : f.getFiles()) {
                IFilter filterObject;
                if (!FilterHelper.matchesMask(name, ff.getSourceFilenameMask()) || (filterObject = FilterMaster.getFilterInstance(f.getClassName())) == null) continue;
                fc.setInEncoding(ff.getSourceEncoding());
                fc.setOutEncoding(ff.getTargetEncoding());
                Map<String, String> config = FilterMaster.forFilter(f.getOption());
                if (!filterObject.isFileSupported(inFile, config, fc)) continue block0;
                return new LookupInformation(filterObject, ff, config);
            }
        }
        return null;
    }

    private static String constructTargetFilename(String sourceMask, String filename, String pattern, Language targetLang, String sourceEncoding, String targetEncoding, String filterFormatName) {
        int lastStarPos = sourceMask.lastIndexOf(42);
        int dot = 0;
        if (lastStarPos >= 0) {
            int lastDotPos = sourceMask.indexOf(46, lastStarPos);
            int extlength = sourceMask.length() - lastDotPos;
            dot = filename.length() - extlength;
        } else {
            dot = filename.lastIndexOf(46);
        }
        String nameOnly = filename;
        String extension = "";
        if (dot >= 0) {
            nameOnly = filename.substring(0, dot);
            extension = filename.substring(dot + 1);
        }
        String res = pattern;
        res = res.replace("${filename}", filename);
        res = res.replace("${nameOnly}", nameOnly);
        res = res.replace("${extension}", extension);
        res = res.replace("${targetLocale}", targetLang.getLocaleCode());
        res = res.replace("${targetLanguage}", targetLang.getLanguage());
        res = res.replace("${targetLanguageCode}", targetLang.getLanguageCode());
        res = res.replace("${targetCountryCode}", targetLang.getCountryCode());
        res = res.replace("${targetCoutryCode}", targetLang.getCountryCode());
        res = res.replace("${targetLocaleLCID}", targetLang.getLocaleLCID());
        res = res.replace("${timestamp-a}", FilterMaster.now("a"));
        res = res.replace("${timestamp-d}", FilterMaster.now("d"));
        res = res.replace("${timestamp-dd}", FilterMaster.now("dd"));
        res = res.replace("${timestamp-h}", FilterMaster.now("h"));
        res = res.replace("${timestamp-hh}", FilterMaster.now("hh"));
        res = res.replace("${timestamp-m}", FilterMaster.now("m"));
        res = res.replace("${timestamp-mm}", FilterMaster.now("mm"));
        res = res.replace("${timestamp-s}", FilterMaster.now("s"));
        res = res.replace("${timestamp-ss}", FilterMaster.now("ss"));
        res = res.replace("${timestamp-yyyy}", FilterMaster.now("yyyy"));
        res = res.replace("${timestamp-D}", FilterMaster.now("D"));
        res = res.replace("${timestamp-EEE}", FilterMaster.now("EEE"));
        res = res.replace("${timestamp-EEEE}", FilterMaster.now("EEEE"));
        res = res.replace("${timestamp-H}", FilterMaster.now("H"));
        res = res.replace("${timestamp-HH}", FilterMaster.now("HH"));
        res = res.replace("${timestamp-M}", FilterMaster.now("M"));
        res = res.replace("${timestamp-MM}", FilterMaster.now("MM"));
        res = res.replace("${timestamp-MMM}", FilterMaster.now("MMM"));
        res = res.replace("${system-os-name}", System.getProperty("os.name"));
        res = res.replace("${system-os-version}", System.getProperty("os.arch"));
        res = res.replace("${system-os-arch}", System.getProperty("os.version"));
        res = res.replace("${system-user-name}", System.getProperty("user.name"));
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            hostName = "";
        }
        res = res.replace("${system-host-name}", hostName);
        String sourceEncodingText = "auto";
        if (sourceEncoding != null) {
            sourceEncodingText = sourceEncoding;
        }
        res = res.replace("${file-source-encoding}", sourceEncodingText);
        String targetEncodingText = "auto";
        if (targetEncoding != null) {
            targetEncodingText = targetEncoding;
        }
        res = res.replace("${file-target-encoding}", targetEncodingText);
        res = res.replace("${file-filter-name}", filterFormatName);
        String sourceMaskPattern = sourceMask.replaceAll("\\?", "(.)").replaceAll("\\*", "(.*?)");
        Matcher sourceMatcher = Pattern.compile(sourceMaskPattern).matcher(filename);
        if (sourceMatcher.find()) {
            for (int i = 1; i <= sourceMatcher.groupCount(); ++i) {
                res = res.replaceAll("\\$\\{" + i + "\\}", sourceMatcher.group(i));
            }
        }
        String[] splitName = filename.split("\\.");
        StringBuffer nameOnlyBuf = new StringBuffer(splitName[0]);
        StringBuffer extensionBuf = new StringBuffer(splitName[splitName.length - 1]);
        for (int i = 0; i < splitName.length; ++i) {
            res = res.replaceAll("\\$\\{nameOnly-" + i + "\\}", nameOnlyBuf.toString());
            res = res.replaceAll("\\$\\{extension-" + i + "\\}", extensionBuf.toString());
            if (i + 1 >= splitName.length) continue;
            nameOnlyBuf.append(".").append(splitName[i + 1]);
            extensionBuf.insert(0, splitName[splitName.length - i - 2] + '.');
        }
        return res;
    }

    private static boolean matchesMask(String filename, String mask) {
        mask = mask.replaceAll("\\.", "\\\\.");
        mask = mask.replaceAll("\\*", ".*");
        mask = mask.replaceAll("\\?", ".");
        return filename.matches("(?iu)" + mask);
    }

    static class LookupInformation {
        public final Files outFilesInfo;
        public final IFilter filterObject;
        public final Map<String, String> config;

        public LookupInformation(IFilter filterObject, Files outFilesInfo, Map<String, String> config) {
            this.filterObject = filterObject;
            this.outFilesInfo = outFilesInfo;
            this.config = config;
        }
    }
}

