/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.foldermenu.filepreview;

import java.io.File;
import java.io.IOException;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

public class TempFileCleaner {
    private static final String LOG_FILE_NAME = "FilePreviewTempFiles.log";
    private static final File logFile = new File(StaticUtils.getConfigDir(), "FilePreviewTempFiles.log");

    private TempFileCleaner() {
    }

    public static void cleanup() {
        String[] list = TempFileCleaner.readTempFileList().split("\\n");
        String content = "";
        for (String path : list) {
            File f;
            if (path.isEmpty() || !(f = new File(path)).isFile() || f.delete()) continue;
            f.deleteOnExit();
            content = content + path + "\n";
        }
        TempFileCleaner.writeTempFileList(content);
    }

    public static void addToList(String[] filePaths) {
        String list = TempFileCleaner.readTempFileList();
        for (String path : filePaths) {
            list = list + path + "\n";
        }
        TempFileCleaner.writeTempFileList(list);
    }

    private static String readTempFileList() {
        String ret = "";
        if (logFile.isFile()) {
            try {
                ret = FileUtil.readTextFile(logFile);
                if (!ret.isEmpty() && !ret.endsWith("\n")) {
                    ret = ret + "\n";
                }
            }
            catch (IOException ex) {
                Log.log(ex);
            }
        }
        return ret;
    }

    private static void writeTempFileList(String content) {
        if (content.isEmpty()) {
            if (logFile.isFile()) {
                logFile.delete();
            }
        } else {
            try {
                FileUtil.writeTextFile(logFile, content);
            }
            catch (IOException ex) {
                Log.log(ex);
            }
        }
    }
}

