/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.foldermenu;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenuItem;
import org.omegat.core.Core;
import org.omegat.plugin.foldermenu.L10n;
import org.omegat.plugin.foldermenu.MenuHelper;
import org.omegat.plugin.foldermenu.filepreview.FilePreview;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;

public class ShellLinkMenuItem {
    protected JMenuItem menuItem;

    public ShellLinkMenuItem() {
        this.menuItem = new JMenuItem();
    }

    public ShellLinkMenuItem(JMenuItem mi) {
        this.menuItem = mi;
    }

    public ShellLinkMenuItem(File file) throws IOException {
        JMenuItem m = new JMenuItem(file.getName(), MenuHelper.getIcon(file));
        m.setActionCommand(file.getCanonicalPath());
        m.addActionListener(MenuHelper.getActionListener());
        this.menuItem = m;
    }

    public boolean isEnabled() {
        return this.menuItem.isEnabled();
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public void open() {
        if (!this.menuItem.isEnabled()) {
            return;
        }
        String path = this.menuItem.getActionCommand();
        try {
            switch (Platform.getOsType()) {
                case WIN64: 
                case WIN32: {
                    File file = new File(path);
                    if (!FilePreview.open(file)) {
                        Desktop.getDesktop().open(file);
                    }
                    break;
                }
                case MAC64: 
                case MAC32: {
                    new ProcessBuilder("open", path).start();
                    break;
                }
                default: {
                    new ProcessBuilder("xdg-open", path).start();
                    break;
                }
            }
        }
        catch (IOException ex) {
            Log.log(ex);
            Core.getMainWindow().showMessageDialog(StaticUtils.format(L10n.getErrMsgFileHasNoAssoc(), path));
        }
    }
}

