/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.foldermenu;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.omegat.core.Core;
import org.omegat.plugin.foldermenu.L10n;
import org.omegat.plugin.foldermenu.Submenu;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class MenuManager {
    private JMenu root = this.createLocalizedMenu(L10n.getFoldersMenuLabel());
    private JMenu currentProject;
    private JMenu userConfig;

    public MenuManager() {
        this.root.addMenuKeyListener(Submenu.getMenuKeyListener());
        this.root.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                if (MenuManager.this.currentProject.isEnabled()) {
                    MenuManager.this.currentProject.removeAll();
                }
                if (MenuManager.this.userConfig.isEnabled()) {
                    MenuManager.this.userConfig.removeAll();
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        try {
            this.currentProject = Submenu.create(L10n.getProjectRootMenuLabel(), this.root);
        }
        catch (IOException ex) {
            Log.log(ex);
            return;
        }
        try {
            File confDir = new File(StaticUtils.getConfigDir());
            this.userConfig = Submenu.create(confDir, L10n.getUserConfigMenuLabel(), this.root);
        }
        catch (IOException ex) {
            Log.log(ex);
        }
        JMenuBar mainMenuBar = (JMenuBar)Core.getMainWindow().getMainMenu().getOptionsMenu().getParent();
        mainMenuBar.add((Component)this.root, mainMenuBar.getMenuCount() - 1);
    }

    public void createProjectItems() {
        File rootDir = new File(Core.getProject().getProjectProperties().getProjectRoot());
        try {
            Submenu.associate(this.currentProject, rootDir);
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }

    public void removeAllProjectItems() {
        Submenu.removeChildren(this.currentProject);
    }

    private JMenu createLocalizedMenu(String labelString) {
        JMenu m = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)m, (String)labelString);
        return m;
    }
}

