﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU Lesser General Public License(LGPL ver3).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

namespace DotNetEx
{
    //! @addtogroup DotNetEx名前空間
    //! @{

    //! @brief 描画処理を行うクラス
    public class Drawing
    {
        //! @brief 埋め込みリソースまたはファイルから読み取り専用のイメージデータを開いて格納します。
	    //!	@details イメージのメモリの実態はストリーム入力になっています。デストラクトされるまで読み取りストリームは開きっぱなしになります。
	    public class StreamedBitmap : System.IDisposable {
	    
            //! @brief
            public System.String path { get { return m_path; } }
            public System.Drawing.Bitmap img { get { return m_img; } }
            
            ~StreamedBitmap() { Dispose(false); }

            //! @brief コンストラクタ
            public StreamedBitmap()
            {
                m_path = null;
                m_stream = null;
                m_img = null;
            }

            //! @brief ファイルから画像を読み込んで返します。例外は返しませんが、失敗するとnullを返します。
            public static StreamedBitmap FromFile(System.String path)
            {
			    if (System.IO.File.Exists( path ) == false) return null;
			    StreamedBitmap ret = new StreamedBitmap();
                try {
				    ret.m_stream = new System.IO.FileStream(path,System.IO.FileMode.Open);
				    ret.m_img = new System.Drawing.Bitmap(ret.m_stream);
				    ret.m_path = path;
			    }
                catch (System.Exception) { return null; }
                return ret;
            }

            //! @brief アセンブリに関連付けられたリソースファイルから、リソース名を指定して画像を読み込みます。
            //! @details 例外は返しません。失敗するとnullを返します。
            //! @param [in] path 探査するリソース名。リソースはSystem.Reflection.Assembly.GetEntryAssembly().GetManifestResourceStream(path)で開かれます。
            public static StreamedBitmap FromResource(System.String path) { return FromResource(path, null); }

            //! @brief アセンブリに関連付けられたリソースファイルから、リソース名を指定して画像を読み込みます。
            //! @details 例外は返しません。失敗するとnullを返します。
            //! @param [in] path 探査するリソース名。リソースはassembly.GetManifestResourceStream(path)で開かれます。
            //! @param [in] assembly リソース名を探査するアセンブリ。nullを指定するとSystem.Reflection.Assembly.GetEntryAssembly()に置換されます。
            public static StreamedBitmap FromResource(System.String path, System.Reflection.Assembly assembly)
            {
                StreamedBitmap ret = new StreamedBitmap();
                if (assembly == null) assembly = System.Reflection.Assembly.GetEntryAssembly();
                try {
				    ret.m_stream = assembly.GetManifestResourceStream(path);
				    ret.m_img = new System.Drawing.Bitmap(ret.m_stream);
				    ret.m_path = path;
                }
                catch (System.Exception) { return null; }
                return ret;
            }

            //! @brief 明示的に破棄します。
            public void Dispose()
            {
                Dispose(true);
                System.GC.SuppressFinalize(this);
            }

            //! @brief 破棄の実装を提供します。
            protected virtual void Dispose(bool ExplicitDisposing)
            {
                if (m_img != null) { m_img.Dispose(); m_img = null; }
                if (m_stream != null) { m_stream.Dispose(); m_stream = null; }
            }

		    private System.String m_path;
		    private System.IO.Stream m_stream;
		    private System.Drawing.Bitmap m_img;
	    }
    }

    //! @}
}
