// This file implements the IDropTargetHelper Interface and Gateway for Python.
// Generated by makegw.py

// @doc
#include "shell_pch.h"
#include "PyIDropTargetHelper.h"

static BOOL PyObject_AsPOINT(PyObject *ob, POINT *pp)
{
	return PyArg_ParseTuple(ob, "ll", &pp->x, &pp->y);
}

static PyObject *PyObject_FromPOINT(POINT &p)
{
	return Py_BuildValue("ii", p.x, p.y);
}
// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIDropTargetHelper::PyIDropTargetHelper(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIDropTargetHelper::~PyIDropTargetHelper()
{
}

/* static */ IDropTargetHelper *PyIDropTargetHelper::GetI(PyObject *self)
{
	return (IDropTargetHelper *)PyIUnknown::GetI(self);
}

// @pymethod |PyIDropTargetHelper|DragEnter|Description of DragEnter.
PyObject *PyIDropTargetHelper::DragEnter(PyObject *self, PyObject *args)
{
	IDropTargetHelper *pIDT = GetI(self);
	if ( pIDT == NULL )
		return NULL;
	POINT pt;
	PyObject *obpt;
	PyObject *obpDataObj;
	IDataObject *pDataObj;
	HWND hwnd;
	PyObject *obhwnd;
    DWORD dwEffect;
	
	if (!PyArg_ParseTuple(args, "OOOl:DragEnter", 
		&obhwnd,		// @pyparm <o PyHANDLE>|hwnd||Handle to target window
		&obpDataObj,	// @pyparm <o PyIDataObject>|pDataObj||Object that is dragged onto the window
		&obpt,			// @pyparm (int, int)|pt||Coordinates where drag operation entered the window
		&dwEffect))		// @pyparm int|dwEffect||One of shellcon.DROPEFFECT_* values
		return NULL;
	if (!PyWinObject_AsHANDLE(obhwnd, (HANDLE *)&hwnd))
		return NULL;
	BOOL bPythonIsHappy = TRUE;
	if (bPythonIsHappy && !PyCom_InterfaceFromPyInstanceOrObject(obpDataObj, IID_IDataObject, (void **)&pDataObj, TRUE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (bPythonIsHappy && !PyObject_AsPOINT( obpt, &pt )) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr;
	PY_INTERFACE_PRECALL;
	hr = pIDT->DragEnter( hwnd, pDataObj, &pt, dwEffect );
	if (pDataObj) pDataObj->Release();
	PY_INTERFACE_POSTCALL;

	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIDT, IID_IDropTargetHelper );
	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod |PyIDropTargetHelper|DragOver|Description of DragOver.
PyObject *PyIDropTargetHelper::DragOver(PyObject *self, PyObject *args)
{
	IDropTargetHelper *pIDT = GetI(self);
	if ( pIDT == NULL )
		return NULL;
	// @pyparm int|hwnd||
	POINT pt;
	PyObject *obpt;
	// @pyparm (int, int)|pt||Description for pt
	DWORD dwEffect;
	// @pyparm int|pdwEffect||Description for pdwEffect
	if ( !PyArg_ParseTuple(args, "Ol:DragOver", &obpt, &dwEffect) )
		return NULL;
	BOOL bPythonIsHappy = TRUE;
	if (bPythonIsHappy && !PyObject_AsPOINT( obpt, &pt )) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr;
	PY_INTERFACE_PRECALL;
	hr = pIDT->DragOver( &pt, dwEffect );
	PY_INTERFACE_POSTCALL;

	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIDT, IID_IDropTargetHelper );
	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod |PyIDropTargetHelper|DragLeave|Description of DragLeave.
PyObject *PyIDropTargetHelper::DragLeave(PyObject *self, PyObject *args)
{
	IDropTargetHelper *pIDT = GetI(self);
	if ( pIDT == NULL )
		return NULL;
	if ( !PyArg_ParseTuple(args, ":DragLeave") )
		return NULL;
	HRESULT hr;
	PY_INTERFACE_PRECALL;
	hr = pIDT->DragLeave( );

	PY_INTERFACE_POSTCALL;

	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIDT, IID_IDropTargetHelper );
	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod |PyIDropTargetHelper|Drop|Description of Drop.
PyObject *PyIDropTargetHelper::Drop(PyObject *self, PyObject *args)
{
	IDropTargetHelper *pIDT = GetI(self);
	if ( pIDT == NULL )
		return NULL;
	// @pyparm <o PyIDataObject>|pDataObj||Description for pDataObj
	POINT pt;
	PyObject *obpt;
	// @pyparm (int, int)|pt||Description for pt
	DWORD dwEffect;
	// @pyparm int|dwEffect||Description for dwEffect
	PyObject *obpDataObj;
	IDataObject * pDataObj;
	if ( !PyArg_ParseTuple(args, "OOi:Drop", &obpDataObj, &obpt, &dwEffect) )
		return NULL;
	BOOL bPythonIsHappy = TRUE;
	if (bPythonIsHappy && !PyCom_InterfaceFromPyInstanceOrObject(obpDataObj, IID_IDataObject, (void **)&pDataObj, TRUE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (bPythonIsHappy && !PyObject_AsPOINT( obpt, &pt )) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr;
	PY_INTERFACE_PRECALL;
	hr = pIDT->Drop( pDataObj, &pt, dwEffect );
	if (pDataObj) pDataObj->Release();
	PY_INTERFACE_POSTCALL;

	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIDT, IID_IDropTargetHelper );
	Py_INCREF(Py_None);
	return Py_None;
}

// @object PyIDropTargetHelper|Description of the interface
static struct PyMethodDef PyIDropTargetHelper_methods[] =
{
	{ "DragEnter", PyIDropTargetHelper::DragEnter, 1 }, // @pymeth DragEnter|Description of DragEnter
	{ "DragOver", PyIDropTargetHelper::DragOver, 1 }, // @pymeth DragOver|Description of DragOver
	{ "DragLeave", PyIDropTargetHelper::DragLeave, 1 }, // @pymeth DragLeave|Description of DragLeave
	{ "Drop", PyIDropTargetHelper::Drop, 1 }, // @pymeth Drop|Description of Drop
	{ NULL }
};

PyComTypeObject PyIDropTargetHelper::type("PyIDropTargetHelper",
		&PyIUnknown::type,
		sizeof(PyIDropTargetHelper),
		PyIDropTargetHelper_methods,
		GET_PYCOM_CTOR(PyIDropTargetHelper));
// ---------------------------------------------------
//
// Gateway Implementation
STDMETHODIMP PyGDropTargetHelper::DragEnter(
		/* [in] */ HWND hwnd,
		/* [unique][in] */ IDataObject * pDataObj,
		/* [in] */ POINT *pt,
		/* [out][in] */ DWORD dwEffect)
{
	PY_GATEWAY_METHOD;
	PyObject *obpt = PyObject_FromPOINT(*pt);
	if (obpt==NULL) return MAKE_PYCOM_GATEWAY_FAILURE_CODE("DragEnter");
	PyObject *obpDataObj;
	obpDataObj = PyCom_PyObjectFromIUnknown(pDataObj, IID_IDataObject, TRUE);
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("DragEnter", &result, "NOOl", PyWinLong_FromHANDLE(hwnd), obpDataObj, obpt, dwEffect);
	Py_XDECREF(obpDataObj);
	Py_DECREF(obpt);
	if (FAILED(hr)) return hr;
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGDropTargetHelper::DragOver(
		/* [in] */ POINT *pt,
		/* [out][in] */ DWORD dwEffect)
{
	PY_GATEWAY_METHOD;
	PyObject *obpt = PyObject_FromPOINT(*pt);
	if (obpt==NULL) return MAKE_PYCOM_GATEWAY_FAILURE_CODE("DragOver");
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("DragOver", &result, "Ol", obpt, dwEffect);
	Py_DECREF(obpt);
	if (FAILED(hr)) return hr;
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGDropTargetHelper::DragLeave(
		void)
{
	PY_GATEWAY_METHOD;
	HRESULT hr=InvokeViaPolicy("DragLeave", NULL);
	return hr;
}

STDMETHODIMP PyGDropTargetHelper::Drop(
		/* [unique][in] */ IDataObject * pDataObj,
		/* [in] */ POINT *pt,
		/* [out][in] */ DWORD dwEffect)
{
	PY_GATEWAY_METHOD;
	PyObject *obpt = PyObject_FromPOINT(*pt);
	if (obpt==NULL) return MAKE_PYCOM_GATEWAY_FAILURE_CODE("Drop");
	PyObject *obpDataObj;
	obpDataObj = PyCom_PyObjectFromIUnknown(pDataObj, IID_IDataObject, TRUE);
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("Drop", &result, "OOl", obpDataObj, obpt, dwEffect);
	Py_XDECREF(obpDataObj);
	Py_DECREF(obpt);
	if (FAILED(hr)) return hr;
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGDropTargetHelper::Show(
		BOOL fShow)
{
	PY_GATEWAY_METHOD;
	HRESULT hr=InvokeViaPolicy("Show", NULL, "O", fShow ? Py_True : Py_False);
	return hr;
}
