/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    aRts_a.c by Peter L Jones <peter@drealm.org.uk>
    based on esd_a.c

    Functions to play sound through aRts
*/
/*  MidiEvent.h  this codes are imported from MT-32 Emulator source. 
    MT-32 Emulator is a "Public Domain" MIDI rendering engine. 
 */

// MidiEvent.h: interface for the CMidiEvent class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MIDIEVENT_H__5C526A6F_AE86_4423_9DA3_9496FFA3A9E1__INCLUDED_)
#define AFX_MIDIEVENT_H__5C526A6F_AE86_4423_9DA3_9496FFA3A9E1__INCLUDED_

	enum MidiEventType {
		ShortMsg,
		SysexData
	};

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMidiEvent  
{
public:


private:
	LONGLONG timemarker;
	MidiEventType myType;
	CMidiEvent *nxtEvent;
	bool finalEvent;

public:
	char *SysexInfo;
	LONG sysexLen;
	LONG MidiMsg;

	CMidiEvent() {
		SysexInfo = NULL;
		nxtEvent = NULL;
		finalEvent = true;
	};
	~CMidiEvent() {};
	

	LONGLONG getTime(void) {
		return timemarker;
	}
	MidiEventType getType(void) {
		return myType;
	}
	CMidiEvent * Consume(void) {
		if (myType==SysexData) {
			if(SysexInfo!=NULL) free(SysexInfo);
		}
		
		return nxtEvent;
	}

	bool isFinal() {
		return finalEvent;
	}
	void ChainEvent(CMidiEvent *newEvent) {
		finalEvent = false;
		nxtEvent = newEvent;
	}

	void AssignSysex(char *Sysex, LONG len, LONGLONG setTime) {
		myType = SysexData;
		sysexLen = len;
		SysexInfo = Sysex;
		timemarker = setTime;
	}

	void AssignMsg(LONG Msg, LONGLONG setTime) {
		myType = ShortMsg;
		MidiMsg = Msg;
		timemarker = setTime;
	}





};

#endif // !defined(AFX_MIDIEVENT_H__5C526A6F_AE86_4423_9DA3_9496FFA3A9E1__INCLUDED_)
