/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model.constraint;

import java.io.Serializable;

public class Constraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int x;
    private int y;
    private int width;
    private int height;

    public Constraint() {
        this(0, 0, -1, -1);
    }

    public Constraint(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Constraint(Constraint constraint) {
        this.x = constraint.x;
        this.y = constraint.y;
        this.width = constraint.width;
        this.height = constraint.height;
    }

    public Constraint getCopy() {
        return new Constraint(this);
    }

    public Constraint getTranslated(int dx, int dy) {
        return this.getCopy().translate(dx, dy);
    }

    public Constraint translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public String toString() {
        return "Constraint [x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }

    public boolean isInitialPosition() {
        return this.x == 0 && this.y == 0;
    }

    public Constraint newPosition(int x, int y) {
        Constraint c = this.getCopy();
        c.x = x;
        c.y = y;
        return c;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

